/*
 * Decompiled with CFR 0.152.
 */
package toufoumaster.btwaila.tooltips.block;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityNoteblock;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.item.ItemStack;
import toufoumaster.btwaila.BTWaila;
import toufoumaster.btwaila.demo.DemoEntry;
import toufoumaster.btwaila.gui.components.AdvancedInfoComponent;
import toufoumaster.btwaila.tooltips.TileTooltip;

public class NoteBlockTooltip
extends TileTooltip<TileEntityNoteblock> {
    public static HashMap<Material, String> materialList = new HashMap<Material, String>(){
        {
            this.put(Material.stone, BTWaila.translator.translateKey("btwaila.tooltip.noteblock.material.stone"));
            this.put(Material.sand, BTWaila.translator.translateKey("btwaila.tooltip.noteblock.material.sand"));
            this.put(Material.glass, BTWaila.translator.translateKey("btwaila.tooltip.noteblock.material.glass"));
            this.put(Material.wood, BTWaila.translator.translateKey("btwaila.tooltip.noteblock.material.wood"));
        }
    };

    @Override
    public void initTooltip() {
        this.addClass(TileEntityNoteblock.class);
    }

    @Override
    public void drawAdvancedTooltip(TileEntityNoteblock entityNote, AdvancedInfoComponent advancedInfoComponent) {
        Material material;
        byte note = entityNote.note;
        String blockModifier = BTWaila.translator.translateKey("btwaila.tooltip.noteblock.material.none");
        WorldClient world = advancedInfoComponent.getGame().currentWorld;
        if (world != null && (material = advancedInfoComponent.getGame().currentWorld.getBlockMaterial(entityNote.x, entityNote.y - 1, entityNote.z)) != null && materialList.containsKey(material)) {
            blockModifier = materialList.get(material);
        }
        String noteString = Integer.toHexString(note).length() == 1 ? "0" + Integer.toHexString(note) : Integer.toHexString(note);
        advancedInfoComponent.drawStringWithShadow(BTWaila.translator.translateKey("btwaila.tooltip.noteblock.pitch").replace("{note}", noteString), 0);
        advancedInfoComponent.drawStringWithShadow(BTWaila.translator.translateKey("btwaila.tooltip.noteblock.modifier").replace("{modifier}", blockModifier), 0);
    }

    @Override
    public DemoEntry tooltipDemo(Random random) {
        TileEntityNoteblock demoNote = new TileEntityNoteblock();
        demoNote.note = (byte)random.nextInt(25);
        Block noteBlock = Blocks.NOTEBLOCK;
        return new DemoEntry(noteBlock, 0, (TileEntity)demoNote, new ItemStack[]{noteBlock.getDefaultStack()});
    }
}

