/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.blocks;

import net.minecraft.core.block.BlockLogicMoss;
import net.minecraft.core.block.BlockLogicNote;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.crafting.LookupFuelFurnace;
import teamport.aether.AetherMod;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.items.AetherItems;

public class AetherBlockDetails {
    public static final MaterialColor[] PAINTED_COLORS = new MaterialColor[]{MaterialColor.paintedWhite, MaterialColor.paintedOrange, MaterialColor.paintedMagenta, MaterialColor.paintedLightblue, MaterialColor.paintedYellow, MaterialColor.paintedLime, MaterialColor.paintedPink, MaterialColor.paintedGrey, MaterialColor.paintedSilver, MaterialColor.paintedCyan, MaterialColor.paintedPurple, MaterialColor.paintedBlue, MaterialColor.paintedBrown, MaterialColor.paintedGreen, MaterialColor.paintedRed, MaterialColor.paintedBlack};

    public static void initializeBlockDetails() {
        AetherBlockDetails.registerBlockInstruments();
        AetherBlockDetails.registerNewFurnaceFuel();
        AetherBlockDetails.registerMapColors();
        AetherBlockDetails.registerMossMap();
    }

    public static void registerNewFurnaceFuel() {
        LookupFuelFurnace.instance.addFuelEntry(AetherItems.STICK_SKYROOT.id, 100);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.PLANKS_SKYROOT.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.PLANKS_SKYROOT_PAINTED.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.STAIRS_PLANKS_SKYROOT.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.STAIRS_PLANKS_SKYROOT_PAINTED.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.SLAB_PLANKS_SKYROOT.id(), 150);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.SLAB_PLANKS_SKYROOT_PAINTED.id(), 150);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.FENCE_PLANKS_SKYROOT.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.FENCE_PLANKS_SKYROOT_PAINTED.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.FENCEGATE_PLANKS_SKYROOT.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.FENCEGATE_PLANKS_SKYROOT_PAINTED.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.CHEST_PLANKS_SKYROOT.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.CHEST_PLANKS_SKYROOT_PAINTED.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.PRESSURE_PLATE_PLANKS_SKYROOT.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.PRESSURE_PLATE_PLANKS_SKYROOT_PAINTED.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.TRAPDOOR_PLANKS_SKYROOT.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.TRAPDOOR_PLANKS_SKYROOT_PAINTED.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherItems.SIGN_SKYROOT.id, 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherItems.SIGN_SKYROOT_PAINTED.id, 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherItems.DOOR_SKYROOT.id, 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherItems.DOOR_SKYROOT_PAINTED.id, 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.BUTTON_PLANKS_SKYROOT.id(), 75);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.BUTTON_PLANKS_SKYROOT_PAINTED.id(), 75);
        LookupFuelFurnace.instance.addFuelEntry(Blocks.BUTTON_PLANKS.id(), 75);
        LookupFuelFurnace.instance.addFuelEntry(Blocks.BUTTON_PLANKS_PAINTED.id(), 75);
        LookupFuelFurnace.instance.addFuelEntry(AetherItems.BUCKET_SKYROOT.id, 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.LOG_SKYROOT.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.LOG_OAK_GOLDEN.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.SAPLING_SKYROOT.id(), 100);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.SAPLING_OAK_GOLDEN.id(), 100);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.CHEST_MIMIC_OAK.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.CHEST_MIMIC_OAK_PAINTED.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.CHEST_MIMIC_SKYROOT.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherBlocks.CHEST_MIMIC_SKYROOT_PAINTED.id(), 300);
        LookupFuelFurnace.instance.addFuelEntry(AetherItems.TOOL_PICKAXE_SKYROOT.id, 500);
        LookupFuelFurnace.instance.addFuelEntry(AetherItems.TOOL_SWORD_SKYROOT.id, 500);
        LookupFuelFurnace.instance.addFuelEntry(AetherItems.TOOL_AXE_SKYROOT.id, 500);
        LookupFuelFurnace.instance.addFuelEntry(AetherItems.TOOL_SHOVEL_SKYROOT.id, 500);
        LookupFuelFurnace.instance.addFuelEntry(AetherItems.TOOL_SHOOTER.id, 300);
    }

    public static void registerBlockInstruments() {
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.AERCLOUD_WHITE.id(), AetherMod.FLUTE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.AERCLOUD_BLUE.id(), AetherMod.FLUTE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.AERCLOUD_GOLD.id(), AetherMod.FLUTE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_PLANKS_SKYROOT.id(), AetherMod.CLICK);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_PLANKS_SKYROOT_PAINTED.id(), AetherMod.CLICK);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_MIMIC_OAK.id(), BlockLogicNote.Instrument.WOOD_BLOCK);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_MIMIC_OAK_PAINTED.id(), BlockLogicNote.Instrument.WOOD_BLOCK);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_MIMIC_SKYROOT.id(), AetherMod.CLICK);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_MIMIC_SKYROOT_PAINTED.id(), AetherMod.CLICK);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_DUNGEON_BRONZE.id(), AetherMod.TRANCE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_DUNGEON_BRONZE_LOCKED.id(), AetherMod.TRANCE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_MIMIC_BRONZE.id(), AetherMod.TRANCE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_DUNGEON_SILVER.id(), AetherMod.BELL);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_DUNGEON_SILVER_LOCKED.id(), AetherMod.BELL);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_MIMIC_SILVER.id(), AetherMod.BELL);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_DUNGEON_GOLD.id(), AetherMod.ORGAN);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_DUNGEON_GOLD_LOCKED.id(), AetherMod.ORGAN);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CHEST_MIMIC_GOLD.id(), AetherMod.ORGAN);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.BLOCK_ZANITE.id(), AetherMod.MUSICBOX);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.BRICK_ZANITE.id(), AetherMod.MUSICBOX);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.SLAB_BRICK_ZANITE.id(), AetherMod.MUSICBOX);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.STAIRS_BRICK_ZANITE.id(), AetherMod.MUSICBOX);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.BLOCK_AMBER.id(), AetherMod.SAXOPHONE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.QUICKSOIL.id(), AetherMod.SITAR);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.GLASS_QUICKSOIL.id(), AetherMod.SITAR);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.BLOCK_GRAVITITE.id(), AetherMod.XYLOPHONE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_HELLFIRE.id(), AetherMod.ORGAN);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_HELLFIRE_LIGHT.id(), AetherMod.ORGAN);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.SLAB_CARVED_HELLFIRE.id(), AetherMod.ORGAN);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.STAIRS_CARVED_HELLFIRE.id(), AetherMod.ORGAN);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_HELLFIRE_LOCKED.id(), AetherMod.ORGAN);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_HELLFIRE_LIGHT_LOCKED.id(), AetherMod.ORGAN);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_ANGELIC.id(), AetherMod.BELL);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_ANGELIC_LIGHT.id(), AetherMod.BELL);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.SLAB_CARVED_ANGELIC.id(), AetherMod.BELL);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.STAIRS_CARVED_ANGELIC.id(), AetherMod.BELL);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_ANGELIC_LOCKED.id(), AetherMod.BELL);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_ANGELIC_LIGHT_LOCKED.id(), AetherMod.BELL);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_ANGELIC_TRAPPED_LOCKED.id(), AetherMod.BELL);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_STONE.id(), AetherMod.TRANCE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_STONE_LIGHT.id(), AetherMod.TRANCE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.SLAB_CARVED_STONE.id(), AetherMod.TRANCE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.STAIRS_CARVED_STONE.id(), AetherMod.TRANCE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_STONE_LOCKED.id(), AetherMod.TRANCE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_STONE_LIGHT_LOCKED.id(), AetherMod.TRANCE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.CARVED_STONE_TRAPPED.id(), AetherMod.TRANCE);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.ICESTONE.id(), BlockLogicNote.Instrument.CELESTA);
        AetherMod.BLOCK_INSTRUMENTS.put(AetherBlocks.BLOCK_AMBROSIUM.id(), AetherMod.TRUMPET);
    }

    public static void registerMossMap() {
        BlockLogicMoss.stoneToMossMap.put(AetherBlocks.HOLYSTONE, AetherBlocks.HOLYSTONE_MOSSY);
        BlockLogicMoss.stoneToMossMap.put(AetherBlocks.COBBLE_HOLYSTONE, AetherBlocks.COBBLE_HOLYSTONE_MOSSY);
    }

    public static void registerMapColors() {
        int i;
        MaterialColor.registerManualBlockColor(AetherBlocks.PORTAL_AETHER, (int)0, (MaterialColor)MaterialColor.paintedLightblue);
        MaterialColor.registerManualBlockColor(AetherBlocks.GRASS_AETHER, (int)0, (MaterialColor)MaterialColor.birchLeaves);
        MaterialColor.registerManualBlockColor(AetherBlocks.DIRT_AETHER, (int)0, (MaterialColor)MaterialColor.permafrost);
        MaterialColor.registerManualBlockColor(AetherBlocks.LEAVES_SKYROOT, (int)0, (MaterialColor)MaterialColor.paintedLime);
        MaterialColor.registerManualBlockColor(AetherBlocks.LEAVES_OAK_GOLDEN, (int)0, (MaterialColor)MaterialColor.paintedYellow);
        MaterialColor.registerManualBlockColor(AetherBlocks.PATH_DIRT_AETHER, (int)0, (MaterialColor)MaterialColor.permafrost);
        MaterialColor.registerManualBlockColor(AetherBlocks.HOLYSTONE, (int)0, (MaterialColor)MaterialColor.metal);
        MaterialColor.registerManualBlockColor(AetherBlocks.HOLYSTONE_MOSSY, (int)0, (MaterialColor)MaterialColor.birchLeaves);
        MaterialColor.registerManualBlockColor(AetherBlocks.HOLYSTONE_POLISHED, (int)0, (MaterialColor)MaterialColor.iron);
        MaterialColor.registerManualBlockColor(AetherBlocks.HOLYSTONE_CARVED, (int)0, (MaterialColor)MaterialColor.iron);
        MaterialColor.registerManualBlockColor(AetherBlocks.SLAB_HOLYSTONE_POLISHED, (int)0, (MaterialColor)MaterialColor.iron);
        MaterialColor.registerManualBlockColor(AetherBlocks.COBBLE_HOLYSTONE, (int)0, (MaterialColor)MaterialColor.metal);
        MaterialColor.registerManualBlockColor(AetherBlocks.COBBLE_HOLYSTONE_MOSSY, (int)0, (MaterialColor)MaterialColor.metal);
        MaterialColor.registerManualBlockColor(AetherBlocks.SLAB_COBBLE_HOLYSTONE, (int)0, (MaterialColor)MaterialColor.metal);
        MaterialColor.registerManualBlockColor(AetherBlocks.STAIRS_COBBLE_HOLYSTONE, (int)0, (MaterialColor)MaterialColor.metal);
        MaterialColor.registerManualBlockColor(AetherBlocks.BRICK_HOLYSTONE, (int)0, (MaterialColor)MaterialColor.metal);
        MaterialColor.registerManualBlockColor(AetherBlocks.STAIRS_BRICK_HOLYSTONE, (int)0, (MaterialColor)MaterialColor.metal);
        MaterialColor.registerManualBlockColor(AetherBlocks.SLAB_BRICK_HOLYSTONE, (int)0, (MaterialColor)MaterialColor.metal);
        MaterialColor.registerManualBlockColor(AetherBlocks.ICESTONE, (int)0, (MaterialColor)MaterialColor.clay);
        MaterialColor.registerManualBlockColor(AetherBlocks.ORE_GRAVITITE_HOLYSTONE, (int)0, (MaterialColor)MaterialColor.metal);
        MaterialColor.registerManualBlockColor(AetherBlocks.ORE_ZANITE_HOLYSTONE, (int)0, (MaterialColor)MaterialColor.metal);
        MaterialColor.registerManualBlockColor(AetherBlocks.ORE_AMBROSIUM_HOLYSTONE, (int)0, (MaterialColor)MaterialColor.metal);
        MaterialColor.registerManualBlockColor(AetherBlocks.QUICKSOIL, (int)0, (MaterialColor)MaterialColor.paintedYellow);
        MaterialColor.registerManualBlockColor(AetherBlocks.GLASS_QUICKSOIL, (int)0, (MaterialColor)MaterialColor.paintedYellow);
        MaterialColor.registerManualBlockColor(AetherBlocks.TRAPDOOR_GLASS_QUICKSOIL, (int)0, (MaterialColor)MaterialColor.paintedYellow);
        MaterialColor.registerManualBlockColor(AetherBlocks.DOOR_GLASS_QUICKSOIL_BOTTOM, (int)0, (MaterialColor)MaterialColor.paintedYellow);
        MaterialColor.registerManualBlockColor(AetherBlocks.DOOR_GLASS_QUICKSOIL_TOP, (int)0, (MaterialColor)MaterialColor.paintedYellow);
        MaterialColor.registerManualBlockColor(AetherBlocks.BLOCK_AMBER, (int)0, (MaterialColor)MaterialColor.gold);
        MaterialColor.registerManualBlockColor(AetherBlocks.BLOCK_AMBROSIUM, (int)0, (MaterialColor)MaterialColor.gold);
        MaterialColor.registerManualBlockColor(AetherBlocks.BLOCK_ZANITE, (int)0, (MaterialColor)MaterialColor.paintedPurple);
        MaterialColor.registerManualBlockColor(AetherBlocks.BLOCK_GRAVITITE, (int)0, (MaterialColor)MaterialColor.paintedPink);
        MaterialColor.registerManualBlockColor(AetherBlocks.BRICK_ZANITE, (int)0, (MaterialColor)MaterialColor.paintedPurple);
        MaterialColor.registerManualBlockColor(AetherBlocks.STAIRS_BRICK_ZANITE, (int)0, (MaterialColor)MaterialColor.paintedPurple);
        MaterialColor.registerManualBlockColor(AetherBlocks.SLAB_BRICK_ZANITE, (int)0, (MaterialColor)MaterialColor.paintedPurple);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_STONE, (int)0, (MaterialColor)MaterialColor.stone);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_STONE_LIGHT, (int)0, (MaterialColor)MaterialColor.stone);
        MaterialColor.registerManualBlockColor(AetherBlocks.STAIRS_CARVED_STONE, (int)0, (MaterialColor)MaterialColor.stone);
        MaterialColor.registerManualBlockColor(AetherBlocks.SLAB_CARVED_STONE, (int)0, (MaterialColor)MaterialColor.stone);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_STONE_LOCKED, (int)0, (MaterialColor)MaterialColor.stone);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_STONE_LIGHT_LOCKED, (int)0, (MaterialColor)MaterialColor.stone);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_STONE_TRAPPED, (int)0, (MaterialColor)MaterialColor.stone);
        MaterialColor.registerManualBlockColor(AetherBlocks.CHEST_DUNGEON_BRONZE, (int)0, (MaterialColor)MaterialColor.stone);
        MaterialColor.registerManualBlockColor(AetherBlocks.CHEST_DUNGEON_BRONZE_LOCKED, (int)0, (MaterialColor)MaterialColor.stone);
        MaterialColor.registerManualBlockColor(AetherBlocks.CHEST_MIMIC_BRONZE, (int)0, (MaterialColor)MaterialColor.stone);
        MaterialColor.registerManualBlockColor(AetherBlocks.DOOR_DUNGEON_BRONZE, (int)0, (MaterialColor)MaterialColor.stone);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_ANGELIC, (int)0, (MaterialColor)MaterialColor.grassScorched);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_ANGELIC_LIGHT, (int)0, (MaterialColor)MaterialColor.grassScorched);
        MaterialColor.registerManualBlockColor(AetherBlocks.STAIRS_CARVED_ANGELIC, (int)0, (MaterialColor)MaterialColor.grassScorched);
        MaterialColor.registerManualBlockColor(AetherBlocks.SLAB_CARVED_ANGELIC, (int)0, (MaterialColor)MaterialColor.grassScorched);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_ANGELIC_LOCKED, (int)0, (MaterialColor)MaterialColor.grassScorched);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_ANGELIC_LIGHT_LOCKED, (int)0, (MaterialColor)MaterialColor.grassScorched);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_ANGELIC_TRAPPED_LOCKED, (int)0, (MaterialColor)MaterialColor.grassScorched);
        MaterialColor.registerManualBlockColor(AetherBlocks.CHEST_DUNGEON_SILVER, (int)0, (MaterialColor)MaterialColor.grassScorched);
        MaterialColor.registerManualBlockColor(AetherBlocks.CHEST_DUNGEON_SILVER_LOCKED, (int)0, (MaterialColor)MaterialColor.grassScorched);
        MaterialColor.registerManualBlockColor(AetherBlocks.CHEST_MIMIC_SILVER, (int)0, (MaterialColor)MaterialColor.grassScorched);
        MaterialColor.registerManualBlockColor(AetherBlocks.DOOR_DUNGEON_SILVER, (int)0, (MaterialColor)MaterialColor.grassScorched);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_HELLFIRE, (int)0, (MaterialColor)MaterialColor.brick);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_HELLFIRE_LIGHT, (int)0, (MaterialColor)MaterialColor.brick);
        MaterialColor.registerManualBlockColor(AetherBlocks.STAIRS_CARVED_HELLFIRE, (int)0, (MaterialColor)MaterialColor.brick);
        MaterialColor.registerManualBlockColor(AetherBlocks.SLAB_CARVED_HELLFIRE, (int)0, (MaterialColor)MaterialColor.brick);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_HELLFIRE_LOCKED, (int)0, (MaterialColor)MaterialColor.brick);
        MaterialColor.registerManualBlockColor(AetherBlocks.CARVED_HELLFIRE_LIGHT_LOCKED, (int)0, (MaterialColor)MaterialColor.brick);
        MaterialColor.registerManualBlockColor(AetherBlocks.CHEST_DUNGEON_GOLD, (int)0, (MaterialColor)MaterialColor.brick);
        MaterialColor.registerManualBlockColor(AetherBlocks.CHEST_DUNGEON_GOLD_LOCKED, (int)0, (MaterialColor)MaterialColor.brick);
        MaterialColor.registerManualBlockColor(AetherBlocks.CHEST_MIMIC_GOLD, (int)0, (MaterialColor)MaterialColor.brick);
        MaterialColor.registerManualBlockColor(AetherBlocks.DOOR_DUNGEON_GOLD, (int)0, (MaterialColor)MaterialColor.brick);
        MaterialColor.registerManualBlockColor(AetherBlocks.PILLAR, (int)0, (MaterialColor)MaterialColor.quartz);
        MaterialColor.registerManualBlockColor(AetherBlocks.PILLAR_CAPSTONE, (int)0, (MaterialColor)MaterialColor.quartz);
        for (i = 0; i < 256; ++i) {
            int colorIndex = i % 16;
            MaterialColor.registerManualBlockColor(AetherBlocks.PLANKS_SKYROOT_PAINTED, (int)i, (MaterialColor)PAINTED_COLORS[colorIndex]);
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int meta = i << 4 | j;
                MaterialColor.registerManualBlockColor(AetherBlocks.STAIRS_PLANKS_SKYROOT_PAINTED, (int)meta, (MaterialColor)PAINTED_COLORS[i]);
                MaterialColor.registerManualBlockColor(AetherBlocks.SLAB_PLANKS_SKYROOT_PAINTED, (int)meta, (MaterialColor)PAINTED_COLORS[i]);
                MaterialColor.registerManualBlockColor(AetherBlocks.CHEST_PLANKS_SKYROOT_PAINTED, (int)meta, (MaterialColor)PAINTED_COLORS[i]);
                MaterialColor.registerManualBlockColor(AetherBlocks.CHEST_MIMIC_SKYROOT_PAINTED, (int)meta, (MaterialColor)PAINTED_COLORS[i]);
                MaterialColor.registerManualBlockColor(AetherBlocks.CHEST_MIMIC_OAK_PAINTED, (int)meta, (MaterialColor)PAINTED_COLORS[i]);
            }
        }
    }
}

