/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.effect;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import sunsetsatellite.catalyst.effects.api.effect.Effect;
import sunsetsatellite.catalyst.effects.api.effect.EffectContainer;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.EffectTimeType;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.Modifier;
import teamport.aether.effect.AetherEffects;
import teamport.aether.effect.ILockInteractable;
import teamport.aether.helper.ParticleHelper;

public class RemedyEffect
extends Effect
implements ILockInteractable {
    public RemedyEffect(String nameKey, String id, List<Modifier<?>> modifiers, EffectTimeType effectTimeType, int maxStack) {
        super(nameKey, id, modifiers, effectTimeType, maxStack);
    }

    public <T> void activated(EffectStack effectStack, EffectContainer<T> effectContainer) {
        HashSet<Effect> remove = AetherEffects.LookupLooks.instance.getLockedEffects(this);
        if (remove == null) {
            return;
        }
        ArrayList check = new ArrayList(effectContainer.getEffects());
        for (EffectStack stack : check) {
            for (Effect effect : remove) {
                if (!effect.equals((Object)stack.getEffect())) continue;
                effectContainer.remove(stack.getEffect());
                Mob mob = (Mob)effectContainer.getParent();
                RemedyEffect.spawnParticles(mob);
            }
        }
    }

    public boolean canApplyTo(Entity target) {
        return target instanceof Mob && super.canApplyTo(target);
    }

    @Override
    public void lockTriggered(IHasEffects hasEffects) {
        if (!(hasEffects instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)hasEffects;
        RemedyEffect.spawnParticles(mob);
    }

    private static void spawnParticles(Mob mob) {
        if (mob instanceof Player) {
            ParticleHelper.spawnRemedyParticle(mob.world, mob.x, mob.y - (double)mob.bbHeight, mob.z, mob.bbHeight, mob.bbWidth);
        } else {
            ParticleHelper.spawnRemedyParticle(mob.world, mob.x, mob.y, mob.z, mob.bbHeight, mob.bbWidth);
        }
    }
}

