/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.sentry;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.Enemy;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tool.ItemToolPickaxe;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.entity.AetherDeathMessage;
import teamport.aether.entity.AetherMobImmuneToSpikes;
import teamport.aether.entity.monster.MobMonsterAether;
import teamport.aether.items.itemtool.ItemToolPickaxeAether;

public class MobSentry
extends MobMonsterAether
implements Enemy,
AetherDeathMessage,
AetherMobImmuneToSpikes {
    public int jumpDelay;
    public int cooldownInactive;
    public boolean activated;

    public MobSentry(World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"sentry");
        this.scoreValue = 200;
        this.setSize(1.0f, 1.0f);
        this.activated = false;
        this.cooldownInactive = 0;
        this.canBreatheUnderwater();
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public int getMaxHealth() {
        return 10;
    }

    @Override
    public boolean hurt(Entity attacker, int damage, DamageType type) {
        ItemStack item;
        if (attacker instanceof Player && (item = ((Player)attacker).inventory.getCurrentItem()) != null && (item.getItem() instanceof ItemToolPickaxe || item.getItem() instanceof ItemToolPickaxeAether)) {
            return super.hurt(attacker, damage * 2, type);
        }
        return super.hurt(attacker, damage, type);
    }

    public void tick() {
        boolean flag = this.onGround;
        super.tick();
        if (this.onGround && !flag) {
            this.world.playSoundAtEntity(null, (Entity)this, "step.stone", this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
        }
        if (!this.world.isClientSide && !this.world.getDifficulty().canHostileMobsSpawn()) {
            this.remove();
        }
    }

    public void updateAI() {
        boolean targetPlayer;
        this.tryToDespawn();
        Player entityplayer = this.world.getClosestPlayerToEntity((Entity)this, 16.0);
        boolean bl = targetPlayer = entityplayer != null && entityplayer.getGamemode().areMobsHostile() && this.canEntityBeSeen((Entity)entityplayer);
        if (entityplayer != null && targetPlayer) {
            this.target = entityplayer;
        }
        if (this.target != null && !this.canEntityBeSeen(this.target)) {
            this.target = null;
            targetPlayer = false;
            this.activated = false;
        }
        if (this.cooldownInactive > 0) {
            --this.cooldownInactive;
        }
        if (targetPlayer) {
            this.target = entityplayer;
            this.lookAt((Entity)entityplayer, 10.0f, 20.0f);
            this.activated = true;
            this.cooldownInactive = 100;
        } else {
            this.activated = false;
        }
        if (this.onGround && this.jumpDelay-- <= 0 && this.cooldownInactive > 0) {
            this.jumpDelay = this.random.nextInt(20) + 10;
            if (targetPlayer) {
                this.jumpDelay /= 3;
            } else {
                float rotation = (this.world.rand.nextFloat() - 0.5f) * 90.0f;
                this.yRot += rotation;
            }
            this.isJumping = true;
            this.world.playSoundAtEntity(null, (Entity)this, "step.stone", this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            this.moveStrafing = 1.0f - this.random.nextFloat() * 2.0f;
            this.moveForward = 2.0f;
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.moveForward = 0.0f;
                this.moveStrafing = 0.0f;
            }
        }
    }

    public void playerTouch(Player player) {
        if (this.findPlayerToAttack() == player && this.canEntityBeSeen((Entity)player) && (double)this.distanceTo((Entity)player) < 1.5) {
            this.findPlayerToAttack().hurt((Entity)this, this.attackStrength, DamageType.COMBAT);
            this.world.createExplosion((Entity)this, this.x, this.y - 0.5, this.z, 1.0f, false, true);
        }
    }

    public String getHurtSound() {
        return "step.stone";
    }

    public String getDeathSound() {
        return "step.stone";
    }

    public void dropDeathItems() {
        if (this.random.nextInt(5) == 0) {
            this.dropItem(AetherBlocks.CARVED_STONE_LIGHT.id(), 1);
        } else {
            this.dropItem(AetherBlocks.CARVED_STONE.id(), 1);
        }
        super.dropDeathItems();
    }

    @Override
    public boolean canSpawnHere() {
        return this.world.getDifficulty().canHostileMobsSpawn();
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }
}

