/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.items;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.animal.MobCow;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import teamport.aether.entity.animal.phow.MobPhow;
import teamport.aether.items.AetherItems;

public class ItemBucketSkyrootEmpty
extends Item {
    public ItemBucketSkyrootEmpty(String name, String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 64;
    }

    public ItemStack onUseItem(ItemStack itemstack, World world, Player entityplayer) {
        double reachDistance = entityplayer.getGamemode().getBlockReachDistance();
        HitResult hitResult = entityplayer.rayTrace(reachDistance, 1.0f, true, false);
        if (hitResult != null && hitResult.hitType == HitResult.HitType.TILE) {
            int i = hitResult.x;
            int j = hitResult.y;
            int k = hitResult.z;
            if (!world.canMineBlock(entityplayer, i, j, k)) {
                return itemstack;
            }
            if (world.getBlockMaterial(i, j, k) == Material.water && world.getBlockMetadata(i, j, k) == 0 && ItemBucketSkyrootEmpty.useBucket(entityplayer, new ItemStack(AetherItems.BUCKET_SKYROOT_WATER))) {
                world.setBlockWithNotify(i, j, k, 0);
                entityplayer.swingItem();
            }
        }
        return itemstack;
    }

    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        if (itemStack.stackSize <= 1) {
            List entities;
            AABB box;
            int z;
            int y;
            int x = blockX + direction.getOffsetX();
            if (world.getBlockMaterial(x, y = blockY + direction.getOffsetY(), z = blockZ + direction.getOffsetZ()) == Material.water && world.getBlockMetadata(x, y, z) == 0) {
                world.setBlockWithNotify(x, y, z, 0);
                itemStack.itemID = AetherItems.BUCKET_SKYROOT_WATER.id;
            } else {
                box = AABB.getTemporaryBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
                entities = world.getEntitiesWithinAABB(MobCow.class, box);
                if (!entities.isEmpty()) {
                    itemStack.itemID = AetherItems.BUCKET_SKYROOT_MILK.id;
                }
            }
            box = AABB.getTemporaryBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            entities = world.getEntitiesWithinAABB(MobPhow.class, box);
            if (!entities.isEmpty()) {
                itemStack.itemID = AetherItems.BUCKET_SKYROOT_MILK.id;
            }
        }
    }

    public static boolean useBucket(Player player, ItemStack itemToGive) {
        if (Objects.requireNonNull(player.inventory.getCurrentItem()).stackSize <= 1) {
            player.inventory.setItem(player.inventory.getCurrentItemIndex(), itemToGive);
            return true;
        }
        player.inventory.insertItem(itemToGive, true);
        if (itemToGive.stackSize < 1) {
            player.inventory.getCurrentItem().consumeItem(player);
            return true;
        }
        return false;
    }
}

