/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.mixin.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemBucket;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.helper.ParticleHelper;
import teamport.aether.world.AetherDimension;

@Mixin(value={ItemBucket.class}, remap=false)
public abstract class LavaBucketMixin
extends Item {
    @Shadow
    @Final
    @Nullable
    private Block<?> blockToPlace;

    public LavaBucketMixin(NamespaceID namespaceId, int id) {
        super(namespaceId, id);
    }

    @Inject(method={"onUseItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void netherAttemptPlaceWater(ItemStack stack, World world, Player player, CallbackInfoReturnable<ItemStack> info) {
        if (world.dimension == Dimension.NETHER && this.blockToPlace != null && this.blockToPlace.hasTag(BlockTags.IS_WATER)) {
            float pitchYawSin;
            float yawSin;
            double distance;
            float yawCos;
            float pitch = player.xRotO + (player.xRot - player.xRotO);
            float yaw = player.yRotO + (player.yRot - player.yRotO);
            double playerPosX = player.xo + (player.x - player.xo);
            double playerPosY = player.yo + (player.y - player.yo) + 1.62 - (double)player.heightOffset;
            double playerPosZ = player.zo + (player.z - player.zo);
            Vec3 playerPosition = Vec3.getTempVec3((double)playerPosX, (double)playerPosY, (double)playerPosZ);
            float pitchCos = MathHelper.cos((float)(-yaw * 0.01745329f - 3.141593f));
            float pitchSin = MathHelper.sin((float)(-yaw * 0.01745329f - 3.141593f));
            float pitchYawCos = pitchSin * (yawCos = -MathHelper.cos((float)(-pitch * 0.01745329f)));
            Vec3 endPosition = playerPosition.add((double)pitchYawCos * (distance = 7.0), (double)(yawSin = MathHelper.sin((float)(-pitch * 0.01745329f))) * distance, (double)(pitchYawSin = pitchCos * yawCos) * distance);
            HitResult rayTraceResult = world.checkBlockCollisionBetweenPoints(playerPosition, endPosition, this.blockToPlace == null);
            if (rayTraceResult != null && rayTraceResult.hitType == HitResult.HitType.TILE) {
                int z;
                int y;
                int x = rayTraceResult.side.getOffsetX() + rayTraceResult.x;
                if (world.getBlockId(x, y = rayTraceResult.side.getOffsetY() + rayTraceResult.y, z = rayTraceResult.side.getOffsetZ() + rayTraceResult.z) != 0) {
                    info.setReturnValue((Object)stack);
                    return;
                }
                player.swingItem();
                world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
                for (int i = 0; i < 8; ++i) {
                    ParticleHelper.spawnParticle(world, "largesmoke", (double)x + Math.random(), (double)y + 0.2, (double)z + Math.random(), 0.0, 0.0, 0.0, 0);
                }
                world.setBlockWithNotify(x, y, z, 0);
                if (player.getGamemode().consumeBlocks()) {
                    info.setReturnValue((Object)new ItemStack(Items.BUCKET));
                    return;
                }
                info.setReturnValue((Object)stack);
            }
        }
    }

    @Inject(method={"onUseItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void aetherAttemptPlaceLava(ItemStack stack, World world, Player player, CallbackInfoReturnable<ItemStack> info) {
        if (world.dimension == AetherDimension.AETHER && this.blockToPlace != null && this.blockToPlace.hasTag(BlockTags.IS_LAVA)) {
            float pitchYawSin;
            float yawSin;
            double distance;
            float yawCos;
            float pitch = player.xRotO + (player.xRot - player.xRotO);
            float yaw = player.yRotO + (player.yRot - player.yRotO);
            double playerPosX = player.xo + (player.x - player.xo);
            double playerPosY = player.yo + (player.y - player.yo) + 1.62 - (double)player.heightOffset;
            double playerPosZ = player.zo + (player.z - player.zo);
            Vec3 playerPosition = Vec3.getTempVec3((double)playerPosX, (double)playerPosY, (double)playerPosZ);
            float pitchCos = MathHelper.cos((float)(-yaw * 0.01745329f - 3.141593f));
            float pitchSin = MathHelper.sin((float)(-yaw * 0.01745329f - 3.141593f));
            float pitchYawCos = pitchSin * (yawCos = -MathHelper.cos((float)(-pitch * 0.01745329f)));
            Vec3 endPosition = playerPosition.add((double)pitchYawCos * (distance = 7.0), (double)(yawSin = MathHelper.sin((float)(-pitch * 0.01745329f))) * distance, (double)(pitchYawSin = pitchCos * yawCos) * distance);
            HitResult rayTraceResult = world.checkBlockCollisionBetweenPoints(playerPosition, endPosition, this.blockToPlace == null);
            if (rayTraceResult != null && rayTraceResult.hitType == HitResult.HitType.TILE) {
                int z;
                int y;
                int x = rayTraceResult.side.getOffsetX() + rayTraceResult.x;
                if (world.getBlockId(x, y = rayTraceResult.side.getOffsetY() + rayTraceResult.y, z = rayTraceResult.side.getOffsetZ() + rayTraceResult.z) != 0) {
                    info.setReturnValue((Object)stack);
                    return;
                }
                player.swingItem();
                world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, itemRand.nextFloat() * 0.4f + 0.8f);
                for (int l = 0; l < 8; ++l) {
                    double angle = Math.toRadians(l * 45);
                    ParticleHelper.spawnParticle(world, "smoke", (double)x + 0.5, y, (double)z + 0.5, -(Math.cos(angle) * 2.0) / 20.0, 0.03, -(Math.sin(angle) * 2.0) / 20.0, 0);
                }
                world.setBlockWithNotify(x, y, z, AetherBlocks.AEROGEL.id());
                if (player.getGamemode().consumeBlocks()) {
                    info.setReturnValue((Object)new ItemStack(Items.BUCKET));
                    return;
                }
                info.setReturnValue((Object)stack);
            }
        }
    }
}

