/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.generate.chunk;

import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.perlin.DensityGenerator;
import net.minecraft.core.world.noise.PerlinNoise;

public class DensityGeneratorAether
implements DensityGenerator {
    public World world;
    public PerlinNoise minLimitNoise;
    public PerlinNoise maxLimitNoise;
    public PerlinNoise mainNoise;

    public DensityGeneratorAether(World world) {
        this.world = world;
        this.minLimitNoise = new PerlinNoise(world.getRandomSeed(), 16, 0);
        this.maxLimitNoise = new PerlinNoise(world.getRandomSeed(), 16, 16);
        this.mainNoise = new PerlinNoise(world.getRandomSeed(), 8, 16);
    }

    public double[] generateDensityMap(Chunk chunk) {
        int terrainHeight = this.world.getWorldType().getMaxY() + 1 - this.world.getWorldType().getMinY();
        int xSize = 5;
        int ySize = terrainHeight / 8 + 1;
        int zSize = 5;
        int x = chunk.xPosition * 4;
        boolean y = false;
        int z = chunk.zPosition * 4;
        double[] densityMapArray = new double[xSize * ySize * zSize];
        double mainNoiseScaleX = 60.0;
        double mainNoiseScaleY = 60.0;
        double mainNoiseScaleZ = 60.0;
        double coordScale = 171.103;
        double heightScale = 342.206;
        double upperLimitScale = 128.0;
        double lowerLimitScale = 128.0;
        double[] mainNoiseArray = this.mainNoise.get(null, (double)x, (double)y, (double)z, xSize, ySize, zSize, 171.103 / mainNoiseScaleX, 342.206 / mainNoiseScaleY, 171.103 / mainNoiseScaleZ);
        double[] minLimitArray = this.minLimitNoise.get(null, (double)x, (double)y, (double)z, xSize, ySize, zSize, 855.5150000000001, 3079.8540000000003, 855.5150000000001);
        double[] maxLimitArray = this.maxLimitNoise.get(null, (double)x, (double)y, (double)z, xSize, ySize, zSize, 855.5150000000001, 3079.8540000000003, 855.5150000000001);
        int mainIndex = 0;
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                for (int dy = 0; dy < ySize; ++dy) {
                    double densityMod;
                    int absoluteY = this.world.getWorldType().getMinY() + dy * 8;
                    double minDensity = minLimitArray[mainIndex] / upperLimitScale;
                    double maxDensity = maxLimitArray[mainIndex] / lowerLimitScale;
                    double mainDensity = mainNoiseArray[mainIndex] / 10.0 + 1.0;
                    double density = mainDensity < 0.0 ? minDensity : (mainDensity > 1.0 ? maxDensity : minDensity + (maxDensity - minDensity) * mainDensity);
                    density -= 32.0;
                    double yFactor = 1.0 - (double)(absoluteY - this.world.getWorldType().getMinY()) / (double)terrainHeight;
                    yFactor = Math.max(0.0, Math.min(1.0, yFactor));
                    density *= yFactor * 0.8 + 0.4;
                    int upperLowerLimit = 35;
                    if (dy > ySize - upperLowerLimit) {
                        densityMod = (float)(dy - (ySize - upperLowerLimit)) / ((float)upperLowerLimit - 1.0f);
                        density = density * (1.0 - densityMod) + -30.0 * densityMod;
                    }
                    if (dy < (upperLowerLimit = 5)) {
                        densityMod = (float)(upperLowerLimit - dy) / ((float)upperLowerLimit - 1.0f);
                        density = density * (1.0 - densityMod) + -30.0 * densityMod;
                    }
                    densityMapArray[mainIndex] = density;
                    ++mainIndex;
                }
            }
        }
        return densityMapArray;
    }
}

