/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.world.generate.feature.components.dungeon.bronze;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.util.helper.Direction;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.world.generate.feature.BlockPallet;
import teamport.aether.world.generate.feature.components.WorldFeatureBlock;
import teamport.aether.world.generate.feature.components.WorldFeatureComponent;
import teamport.aether.world.generate.feature.components.WorldFeaturePoint;
import teamport.aether.world.generate.feature.components.dungeon.bronze.BaseBronzeRoom;

public class TallRoom
extends BaseBronzeRoom {
    public static BlockPallet ROOM_PALLET = new BlockPallet();

    public TallRoom() {
        this.height = 30;
        this.roomWeight = 0.5f;
        this.liquidTolerance = 0.75f;
        this.airTolerance = 0.75f;
        this.bottomLiquidTolerance = 1.0f;
        this.topLiquidTolerance = 1.0f;
        this.bottomAirTolerance = 1.0f;
        this.topAirTolerance = 1.0f;
        this.addDoor(Direction.NORTH, WorldFeaturePoint.wfp(4, 1, 0), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.EAST, WorldFeaturePoint.wfp(11, 1, 4), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.SOUTH, WorldFeaturePoint.wfp(4, 1, 11), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.WEST, WorldFeaturePoint.wfp(0, 1, 4), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.NORTH, WorldFeaturePoint.wfp(4, 19, 0), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.EAST, WorldFeaturePoint.wfp(11, 19, 4), Direction.UP, 6, Direction.SOUTH, 4);
        this.addDoor(Direction.SOUTH, WorldFeaturePoint.wfp(4, 19, 11), Direction.UP, 6, Direction.EAST, 4);
        this.addDoor(Direction.WEST, WorldFeaturePoint.wfp(0, 19, 4), Direction.UP, 6, Direction.SOUTH, 4);
    }

    public void makeShell() {
        this.room.add(WorldFeatureComponent.drawShell(this.random, ROOM_PALLET, Direction.SOUTH, this.width, Direction.UP, this.height, Direction.EAST, this.width, this.x, this.y, this.z, false));
        this.room.add(WorldFeatureComponent.drawVolume(0, 0, Direction.SOUTH, this.width - 2, Direction.UP, this.height - 2, Direction.EAST, this.width - 2, this.x + 1, this.y + 1, this.z + 1, false));
        ArrayList<WorldFeaturePoint> pillar = new ArrayList<WorldFeaturePoint>();
        pillar.add(WorldFeaturePoint.wfp(this.x + 3, this.y, this.z + 3));
        pillar.add(WorldFeaturePoint.wfp(this.x + 3, this.y, this.z + 7));
        pillar.add(WorldFeaturePoint.wfp(this.x + 7, this.y, this.z + 3));
        pillar.add(WorldFeaturePoint.wfp(this.x + 7, this.y, this.z + 7));
        Collections.shuffle(pillar, this.random);
        int pillar_height = this.height - 10;
        int index = 0;
        for (int i = 0; i < 6; ++i) {
            index %= 4;
            WorldFeaturePoint point = (WorldFeaturePoint)pillar.get(index++);
            this.decoration.add(WorldFeatureComponent.drawPlane(this.random, ROOM_PALLET, Direction.SOUTH, 2, Direction.EAST, 2, point.x, this.y + pillar_height, point.z, false));
            if (pillar_height < 6) {
                this.decoration.add(WorldFeatureComponent.drawVolume(this.random, ROOM_PALLET, Direction.SOUTH, 2, Direction.EAST, 2, Direction.DOWN, pillar_height, point.x, this.y + pillar_height, point.z, false));
                pillar_height -= 4;
                continue;
            }
            this.decoration.add(WorldFeatureBlock.wfb(point.x, this.y - 1 + pillar_height, point.z, AetherBlocks.AERCLOUD_WHITE.id(), 0));
            this.decoration.add(WorldFeatureBlock.wfb(point.x + 1, this.y - 1 + pillar_height, point.z, AetherBlocks.AERCLOUD_WHITE.id(), 0));
            this.decoration.add(WorldFeatureBlock.wfb(point.x, this.y - 1 + pillar_height, point.z + 1, AetherBlocks.AERCLOUD_WHITE.id(), 0));
            this.decoration.add(WorldFeatureBlock.wfb(point.x, this.y - 2 + pillar_height, point.z, AetherBlocks.AERCLOUD_WHITE.id(), 0));
            pillar_height -= 4;
        }
        this.chest.add(WorldFeatureComponent.drawPlane(this.random, chestOrMimic, Direction.SOUTH, 2, Direction.EAST, 2, this.x + 5, this.y + this.height - 4, this.z + 5, false));
        this.decoration.add(WorldFeatureComponent.drawPlane(this.random, ROOM_PALLET, Direction.SOUTH, 2, Direction.EAST, 2, this.x + 5, this.y + this.height - 5, this.z + 5, false));
        this.decoration.add(WorldFeatureBlock.wfb(this.x + 5, this.y + this.height - 6, this.z + 5, AetherBlocks.AERCLOUD_WHITE.id(), 0, false));
        this.decoration.add(WorldFeatureBlock.wfb(this.x + 6, this.y + this.height - 6, this.z + 5, AetherBlocks.AERCLOUD_WHITE.id(), 0, false));
        this.decoration.add(WorldFeatureBlock.wfb(this.x + 5, this.y + this.height - 6, this.z + 6, AetherBlocks.AERCLOUD_WHITE.id(), 0, false));
        this.decoration.add(WorldFeatureBlock.wfb(this.x + 5, this.y + this.height - 7, this.z + 5, AetherBlocks.AERCLOUD_WHITE.id(), 0, false));
    }

    @Override
    public void makeRoom() {
        this.makeShell();
    }

    static {
        ROOM_PALLET.addEntry(AetherBlocks.CARVED_STONE.id(), 0, 85.0);
        ROOM_PALLET.addEntry(AetherBlocks.CARVED_STONE_LIGHT.id(), 0, 5.0);
        ROOM_PALLET.addEntry(AetherBlocks.CARVED_STONE_TRAPPED.id(), 0, 10.0);
    }
}

