/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util;

import java.util.Arrays;
import net.minecraft.core.world.World;
import sunsetsatellite.catalyst.core.util.mixin.interfaces.IAbsoluteWorldTime;

public class AveragingCounter {
    private final long defaultValue;
    private final long[] values;
    private long lastUpdatedWorldTime = 0L;
    private int currentIndex = 0;
    private boolean dirty = true;
    private double lastAverage = 0.0;

    public AveragingCounter() {
        this(0L, 20);
    }

    public AveragingCounter(long defaultValue, int length) {
        this.defaultValue = defaultValue;
        this.values = new long[length];
        Arrays.fill(this.values, defaultValue);
    }

    private void update(World world) {
        if (world == null) {
            return;
        }
        long currentWorldTime = ((IAbsoluteWorldTime)world).getAbsoluteWorldTime();
        if (currentWorldTime != this.lastUpdatedWorldTime) {
            long dif = currentWorldTime - this.lastUpdatedWorldTime;
            if (dif >= (long)this.values.length || dif < 0L) {
                Arrays.fill(this.values, this.defaultValue);
                this.currentIndex = 0;
            } else {
                this.currentIndex += (int)dif;
                if (this.currentIndex > this.values.length - 1) {
                    this.currentIndex -= this.values.length;
                }
                int i = 0;
                int n = this.values.length;
                while ((long)i < dif) {
                    int index = i + this.currentIndex;
                    if (index >= n) {
                        index -= n;
                    }
                    this.values[index] = this.defaultValue;
                    ++i;
                }
            }
            this.lastUpdatedWorldTime = currentWorldTime;
            this.dirty = true;
        }
    }

    public long getLast(World world) {
        this.update(world);
        return this.values[this.currentIndex];
    }

    public double getAverage(World world) {
        this.update(world);
        if (!this.dirty) {
            return this.lastAverage;
        }
        this.dirty = false;
        this.lastAverage = (double)Arrays.stream(this.values).sum() / (double)this.values.length;
        return this.lastAverage;
    }

    public void increment(World world, long value) {
        this.update(world);
        int n = this.currentIndex;
        this.values[n] = this.values[n] + value;
    }

    public void set(World world, long value) {
        this.update(world);
        this.values[this.currentIndex] = value;
    }
}

