/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util;

import java.util.Objects;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.core.util.vector.Vec3i;

public class BlockInstance {
    @NotNull
    public Block<?> block;
    @NotNull
    public Vec3i pos;
    public int meta = 0;
    public TileEntity tile;
    public Vec3i offset;

    public BlockInstance(@NotNull Block<?> block, @NotNull Vec3i pos, TileEntity tile) {
        this.block = block;
        this.pos = pos;
        this.tile = tile;
    }

    public BlockInstance(@NotNull Block<?> block, @NotNull Vec3i pos, int meta, TileEntity tile) {
        this.block = block;
        this.pos = pos;
        this.tile = tile;
        this.meta = meta;
    }

    public boolean exists(World world) {
        Block block = world.getBlock(this.pos.x, this.pos.y, this.pos.z);
        int meta = world.getBlockMetadata(this.pos.x, this.pos.y, this.pos.z);
        return block == this.block && (meta == this.meta || this.meta == -1);
    }

    public boolean existsWithTile(World world) {
        Block block = world.getBlock(this.pos.x, this.pos.y, this.pos.z);
        int meta = world.getBlockMetadata(this.pos.x, this.pos.y, this.pos.z);
        TileEntity tile = world.getTileEntity(this.pos.x, this.pos.y, this.pos.z);
        return block == this.block && (meta == this.meta || this.meta == -1) && tile == this.tile;
    }

    public boolean place(World world) {
        if (world.getBlockId(this.pos.x, this.pos.y, this.pos.z) == 0) {
            world.setBlockWithNotify(this.pos.x, this.pos.y, this.pos.z, this.block.id());
            world.setBlockMetadata(this.pos.x, this.pos.y, this.pos.z, this.meta);
            return true;
        }
        return false;
    }

    public String toString() {
        return "BlockInstance{block=" + this.block + ", pos=" + this.pos + ", meta=" + this.meta + ", tile=" + this.tile + '}';
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockInstance)) {
            return false;
        }
        BlockInstance that = (BlockInstance)o;
        return this.meta == that.meta && Objects.equals(this.block, that.block) && Objects.equals(this.pos, that.pos) && Objects.equals(this.tile, that.tile);
    }

    public int hashCode() {
        int result = this.block.hashCode();
        result = 31 * result + this.pos.hashCode();
        result = 31 * result + this.meta;
        result = 31 * result + (this.tile != null ? this.tile.hashCode() : 0);
        return result;
    }
}

