/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.io;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.io.IItemStackList;
import sunsetsatellite.catalyst.core.util.mixin.interfaces.UnlimitedItemStack;

public class ItemStackList
implements IItemStackList,
Iterable<ItemStack> {
    protected final ArrayList<ItemStack> contents;
    private final int maxItemSize = Integer.MAX_VALUE;
    private final int maxStackSize = Integer.MAX_VALUE;

    public ItemStackList() {
        this.contents = new ArrayList();
    }

    public ItemStackList(List<ItemStack> contents) {
        this.contents = new ArrayList<ItemStack>(contents);
    }

    @Override
    public ItemStack add(ItemStack stack) {
        ItemStack invStack;
        if (stack == null) {
            return stack;
        }
        int index = this.find(stack.itemID, stack.getMetadata(), stack.getData());
        if (index != -1 && !(invStack = this.contents.get(index)).getData().equals((Object)stack.getData())) {
            index = -1;
        }
        if (index != -1) {
            if (this.getAmount() + (long)stack.stackSize <= this.getItemCapacity()) {
                invStack = this.contents.get(index);
                invStack.stackSize += stack.stackSize;
                this.inventoryChanged();
                return null;
            }
            long remainder = this.getAmount() + (long)stack.stackSize - this.getItemCapacity();
            ItemStack split = stack.splitStack((int)remainder);
            ItemStack invStack2 = this.contents.get(index);
            invStack2.stackSize += stack.stackSize;
            this.inventoryChanged();
            return split;
        }
        if (this.getAmount() + (long)stack.stackSize <= this.getItemCapacity() && this.getStackAmount() + 1L <= this.getStackCapacity()) {
            ((UnlimitedItemStack)stack).setUnlimited(true);
            this.contents.add(stack);
            this.inventoryChanged();
            return null;
        }
        if (this.getAmount() + (long)stack.stackSize > this.getItemCapacity()) {
            long remainder = this.getAmount() + (long)stack.stackSize - this.getItemCapacity();
            ((UnlimitedItemStack)stack).setUnlimited(true);
            ItemStack split = stack.splitStack((int)remainder);
            this.contents.add(stack);
            this.inventoryChanged();
            return split;
        }
        return stack;
    }

    @Override
    public ItemStack add(int index, ItemStack stack) {
        if (index >= this.contents.size()) {
            return stack;
        }
        ItemStack invStack = this.contents.get(index);
        if (invStack == null) {
            this.contents.add(index, stack);
            this.inventoryChanged();
            return null;
        }
        if (invStack.isItemEqual(stack) && invStack.getData().equals((Object)stack.getData()) && this.getAmount() + (long)stack.stackSize > this.getItemCapacity()) {
            long remainder = this.getAmount() + (long)stack.stackSize - this.getItemCapacity();
            ((UnlimitedItemStack)stack).setUnlimited(true);
            ItemStack split = stack.splitStack((int)remainder);
            invStack.stackSize += stack.stackSize;
            this.inventoryChanged();
            return split.stackSize <= 0 ? null : split;
        }
        return stack;
    }

    @Override
    public @UnmodifiableView List<ItemStack> addAll(ItemStackList stacks) {
        return this.addAll(stacks.getStacks());
    }

    @Override
    public @UnmodifiableView List<ItemStack> addAll(List<ItemStack> stacks) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            newStacks.add(this.add(stack));
        }
        return Collections.unmodifiableList(Catalyst.condenseItemList(newStacks));
    }

    @Override
    public long getItemCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getStackCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getStackAmount() {
        return this.contents.stream().filter(Objects::nonNull).count();
    }

    @Override
    public long getAmount() {
        return this.contents.stream().mapToInt(C -> C.stackSize).sum();
    }

    @Override
    public ItemStack remove(int slot, long amount, boolean strict, boolean unlimited) {
        if (slot >= this.contents.size()) {
            return null;
        }
        ItemStack stack = this.contents.get(slot);
        if (stack == null) {
            return null;
        }
        if (strict && amount > (long)stack.stackSize) {
            return null;
        }
        if (!strict) {
            amount = Math.min(amount, (long)stack.stackSize);
            if (!unlimited) {
                amount = Math.min(amount, (long)stack.getItem().getItemStackLimit(stack));
            }
            ItemStack splitStack = stack.splitStack((int)amount);
            if (stack.stackSize <= 0) {
                this.contents.remove(slot);
            }
            this.inventoryChanged();
            return splitStack;
        }
        return null;
    }

    @Override
    public ItemStack remove(int slot, boolean strict, boolean unlimited) {
        if (slot >= this.contents.size()) {
            return null;
        }
        ItemStack stack = this.contents.get(slot);
        if (stack == null) {
            return null;
        }
        return this.remove(slot, stack.getItem().getItemStackLimit(stack), strict, unlimited);
    }

    @Override
    public @UnmodifiableView List<ItemStack> move(ItemStackList what, ItemStackList where, boolean strict) {
        return this.move(what.getStacks(), where, strict);
    }

    @Override
    public @UnmodifiableView List<ItemStack> move(List<ItemStack> what, ItemStackList where, boolean strict) {
        ArrayList<ItemStack> leftovers = new ArrayList<ItemStack>();
        for (ItemStack stack : what) {
            ItemStack removed = this.remove(stack.itemID, stack.getMetadata(), stack.stackSize, stack.getData(), strict, true);
            if (removed == null) {
                leftovers.add(stack);
                continue;
            }
            ItemStack addLeftover = where.add(removed);
            leftovers.add(addLeftover);
        }
        return Collections.unmodifiableList(Catalyst.condenseItemList(leftovers));
    }

    @Override
    public ItemStack remove(int id, int meta, long amount, CompoundTag data, boolean strict, boolean unlimited) {
        int index = this.find(id, meta, data);
        if (index != -1) {
            return this.remove(index, amount, strict, unlimited);
        }
        return null;
    }

    @Override
    public boolean removeAll(List<ItemStack> stacks, boolean strict, boolean unlimited) {
        for (ItemStack stack : stacks) {
            ItemStack removed = this.remove(stack.itemID, stack.getMetadata(), stack.stackSize, stack.getData(), strict, unlimited);
            if (removed != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ItemStack> exportAll(List<ItemStack> stacks, boolean strict, boolean unlimited) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            ItemStack removed = this.remove(stack.itemID, stack.getMetadata(), stack.stackSize, stack.getData(), strict, unlimited);
            if (removed == null) continue;
            list.add(removed);
        }
        return list;
    }

    @Override
    public boolean eject(World world, int x, int y, int z, int slot, long amount, boolean strict) {
        ItemStack content = this.remove(slot, amount, strict, false);
        if (content != null) {
            float f = world.rand.nextFloat() * 0.8f + 0.1f;
            float f1 = world.rand.nextFloat() * 0.8f + 0.1f;
            float f2 = world.rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), content);
            float f3 = 0.05f;
            entityitem.xd = (float)world.rand.nextGaussian() * f3;
            entityitem.yd = (float)world.rand.nextGaussian() * f3 + 0.2f;
            entityitem.zd = (float)world.rand.nextGaussian() * f3;
            world.entityJoinedWorld((Entity)entityitem);
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean eject(World world, int x, int y, int z, int id, int meta, CompoundTag data, long amount, boolean strict) {
        ItemStack content = this.remove(id, meta, amount, data, strict, false);
        if (content != null) {
            float f = world.rand.nextFloat() * 0.8f + 0.1f;
            float f1 = world.rand.nextFloat() * 0.8f + 0.1f;
            float f2 = world.rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), content);
            float f3 = 0.05f;
            entityitem.xd = (float)world.rand.nextGaussian() * f3;
            entityitem.yd = (float)world.rand.nextGaussian() * f3 + 0.2f;
            entityitem.zd = (float)world.rand.nextGaussian() * f3;
            world.entityJoinedWorld((Entity)entityitem);
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    @Override
    public void ejectAll(World world, int x, int y, int z) {
        for (ItemStack content : this.getStacks()) {
            if (content == null) continue;
            this.eject(world, x, y, z, content.itemID, content.getMetadata(), content.getData(), content.stackSize, false);
        }
    }

    @Override
    public boolean contains(int id, int meta, CompoundTag data) {
        return this.contents.stream().anyMatch(S -> S.itemID == id && S.getMetadata() == meta);
    }

    @Override
    public boolean containsAtLeast(int id, int meta, CompoundTag data, long amount) {
        return this.contents.stream().anyMatch(S -> S.itemID == id && S.getMetadata() == meta && (long)S.stackSize >= amount);
    }

    @Override
    public boolean containsAtLeast(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            boolean contains = this.containsAtLeast(stack.itemID, stack.getMetadata(), stack.getData(), stack.stackSize);
            if (contains) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeast(ItemStackList stacks) {
        for (ItemStack stack : stacks) {
            boolean contains = this.containsAtLeast(stack.itemID, stack.getMetadata(), stack.getData(), stack.stackSize);
            if (contains) continue;
            return false;
        }
        return true;
    }

    @Override
    public ArrayList<ItemStack> returnMissing(ArrayList<ItemStack> stacks) {
        ArrayList<ItemStack> missing = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            long c = this.count(stack.itemID, stack.getMetadata(), stack.getData());
            if (c <= 0L) {
                missing.add(stack.copy());
                continue;
            }
            if (c == (long)stack.stackSize) continue;
            ItemStack copy = stack.copy();
            copy.stackSize -= (int)c;
            missing.add(stack.copy());
        }
        return missing;
    }

    @Override
    public long count(int id, int meta, CompoundTag data) {
        return this.contents.stream().mapToInt(S -> {
            if (S.itemID == id && (S.getMetadata() == meta || meta == -1)) {
                return S.stackSize;
            }
            return 0;
        }).sum();
    }

    @Override
    public long count(int id) {
        return this.contents.stream().mapToInt(S -> {
            if (S.itemID == id) {
                return S.stackSize;
            }
            return 0;
        }).sum();
    }

    @Override
    public int find(int id, int meta, CompoundTag data) {
        for (int i = 0; i < this.contents.size(); ++i) {
            ItemStack content = this.contents.get(i);
            if (content.getMetadata() != meta && meta != -1 || content.itemID != id) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ItemStack get(int index) {
        if (index < 0 || index >= this.contents.size()) {
            return null;
        }
        return this.contents.get(index);
    }

    @Override
    public ItemStack get(int id, int meta, CompoundTag data) {
        return this.get(this.find(id, meta, data));
    }

    @Override
    public ItemStack getLast() {
        return this.contents.get(this.contents.size() - 1);
    }

    @Override
    public void inventoryChanged() {
    }

    @Override
    public void clear() {
        this.contents.clear();
        this.inventoryChanged();
    }

    @Override
    public IItemStackList copy() {
        ItemStackList inv = new ItemStackList();
        inv.contents.stream().map(ItemStack::copy).forEach(inv.contents::add);
        return inv;
    }

    @Override
    public List<ItemStack> getStacks() {
        return Collections.unmodifiableList(this.contents);
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public String toString() {
        return this.contents.toString();
    }

    @Override
    @NotNull
    public Iterator<ItemStack> iterator() {
        return this.contents.iterator();
    }

    public void writeToNbt(CompoundTag tag) {
        for (int i = 0; i < this.contents.size(); ++i) {
            ItemStack item = this.contents.get(i);
            CompoundTag itemNBT = new CompoundTag();
            if (item != null) {
                item.writeToNBT(itemNBT);
                itemNBT.putInt("Count", item.stackSize);
                tag.putCompound(String.valueOf(i), itemNBT);
                continue;
            }
            ((Map)tag.getValue()).remove(String.valueOf(i));
        }
    }

    public void readFromNbt(CompoundTag tag) {
        for (Tag value : tag.getValues()) {
            CompoundTag itemNBT = (CompoundTag)value;
            ItemStack stack = new ItemStack(0, 0, 0, new CompoundTag());
            stack.readFromNBT(itemNBT);
            stack.stackSize = itemNBT.getInteger("Count");
            if (stack.stackSize <= 0) continue;
            this.contents.add(stack);
        }
    }
}

