/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.mp;

import com.mojang.nbt.tags.CompoundTag;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.core.block.entity.TileEntity;
import org.jetbrains.annotations.NotNull;
import sunsetsatellite.catalyst.Catalyst;
import sunsetsatellite.catalyst.core.util.mp.MpGuiEntryClient;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class PacketOpenGui
implements NetworkMessage {
    public int windowId;
    public String windowTitle;
    public String type;
    public int blockX;
    public int blockY;
    public int blockZ;
    public int stackIndex;
    public boolean isArmor;
    public CompoundTag data = null;

    public PacketOpenGui() {
    }

    public PacketOpenGui(int windowId, String windowTitle, int x, int y, int z) {
        this.windowId = windowId;
        this.windowTitle = windowTitle;
        this.type = "tile";
        this.blockX = x;
        this.blockY = y;
        this.blockZ = z;
    }

    public PacketOpenGui(int windowId, String windowTitle, int x, int y, int z, CompoundTag data) {
        this.windowId = windowId;
        this.windowTitle = windowTitle;
        this.type = "tile";
        this.blockX = x;
        this.blockY = y;
        this.blockZ = z;
        this.data = data;
    }

    public PacketOpenGui(int windowId, String windowTitle, int stackIndex, boolean isArmor) {
        this.windowId = windowId;
        this.windowTitle = windowTitle;
        this.type = "item";
        this.stackIndex = stackIndex;
        this.isArmor = isArmor;
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        packet.writeByte(this.windowId);
        packet.writeString(this.windowTitle);
        packet.writeString(this.type);
        packet.writeInt(this.blockX);
        packet.writeInt(this.blockY);
        packet.writeInt(this.blockZ);
        packet.writeInt(this.stackIndex);
        packet.writeBoolean(this.isArmor);
        packet.writeBoolean(this.data != null);
        if (this.data != null) {
            packet.writeCompoundTag(this.data);
        }
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.windowId = packet.readByte();
        this.windowTitle = packet.readString();
        this.type = packet.readString();
        this.blockX = packet.readInt();
        this.blockY = packet.readInt();
        this.blockZ = packet.readInt();
        this.stackIndex = packet.readInt();
        this.isArmor = packet.readBoolean();
        boolean hasData = packet.readBoolean();
        this.data = hasData ? packet.readCompoundTag() : null;
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (Objects.equals(this.type, "tile")) {
            TileEntity tile = null;
            if (context.player.world != null) {
                tile = context.player.world.getTileEntity(this.blockX, this.blockY, this.blockZ);
            }
            if (tile != null) {
                if (this.data == null) {
                    try {
                        Minecraft.getMinecraft().displayScreen((Screen)((MpGuiEntryClient)Catalyst.GUIS.getItem((String)this.windowTitle)).guiClass.getDeclaredConstructors()[0].newInstance(context.player.inventory, tile));
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    Minecraft.getMinecraft().displayScreen((Screen)((MpGuiEntryClient)Catalyst.GUIS.getItem((String)this.windowTitle)).guiClass.getDeclaredConstructors()[0].newInstance(context.player.inventory, tile, this.data));
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            context.player.craftingInventory.containerId = this.windowId;
        } else if (Objects.equals(this.type, "item")) {
            try {
                Minecraft.getMinecraft().displayScreen((Screen)((MpGuiEntryClient)Catalyst.GUIS.getItem((String)this.windowTitle)).guiClass.getDeclaredConstructors()[0].newInstance(context.player.inventory, this.stackIndex, this.isArmor));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            context.player.craftingInventory.containerId = this.windowId;
        }
    }
}

