/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.tile;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import sunsetsatellite.catalyst.core.util.mixin.interfaces.ITileEntityInit;
import sunsetsatellite.catalyst.core.util.tile.TEFeature;
import sunsetsatellite.catalyst.core.util.tile.feature.IHasFeatures;

public class ExtendableTileEntity
extends TileEntity
implements ITileEntityInit,
IHasFeatures {
    protected Map<String, TEFeature> features = new HashMap<String, TEFeature>();
    private CompoundTag loadData;

    @Override
    @MustBeInvokedByOverriders
    public void init(Block<?> block) {
        this.loadFeatures();
        this.features.forEach((S, F) -> F.init(block));
    }

    @MustBeInvokedByOverriders
    public void tick() {
        super.tick();
        this.features.forEach((S, F) -> F.tick());
    }

    @MustBeInvokedByOverriders
    public void writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        CompoundTag featuresTag = new CompoundTag();
        this.features.forEach((S, F) -> {
            CompoundTag featureTag = new CompoundTag();
            F.writeToNBT(featureTag);
            featuresTag.putCompound(S, featureTag);
        });
        nbttagcompound.put("Features", (Tag)featuresTag);
    }

    public void loadFeatures() {
        if (this.loadData != null) {
            CompoundTag featuresTag = this.loadData.getCompound("Features");
            for (Tag tag : featuresTag.getValues()) {
                CompoundTag featureTag;
                TEFeature feature;
                if (!(tag instanceof CompoundTag) || (feature = TEFeature.loadFeature(featureTag = (CompoundTag)tag, this.worldObj)) == null) continue;
                this.features.put(feature.id, feature);
            }
            this.loadData = null;
        }
    }

    @MustBeInvokedByOverriders
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.loadData = nbttagcompound;
    }

    @Override
    public boolean hasFeature(String id) {
        return this.features.get(id) != null;
    }

    @Override
    public TEFeature getFeature(String id) {
        return this.features.get(id);
    }

    @Override
    public TEFeature createAndAddFeature(String featureId) {
        TEFeature feature = TEFeature.createFeature(featureId, this.worldObj, this.x, this.y, this.z);
        this.features.put(featureId, feature);
        return feature;
    }
}

