/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.core.util.vector;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.util.helper.MathHelper;

public class Vec2f {
    public double x;
    public double y;

    public Vec2f(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vec2f() {
        this.y = 0.0;
        this.x = 0.0;
    }

    public Vec2f(double size) {
        this.x = this.y = size;
    }

    public Vec2f(CompoundTag tag) {
        this.readFromNBT(tag);
    }

    public double distanceTo(Vec2f vec3f) {
        double d = vec3f.x - this.x;
        double d1 = vec3f.y - this.y;
        return MathHelper.sqrt((double)(d * d + d1 * d1));
    }

    public Vec2f add(double value) {
        this.x += value;
        this.y += value;
        return this;
    }

    public Vec2f subtract(double value) {
        this.x -= value;
        this.y -= value;
        return this;
    }

    public Vec2f divide(double value) {
        this.x /= value;
        this.y /= value;
        return this;
    }

    public Vec2f multiply(double value) {
        this.x *= value;
        this.y *= value;
        return this;
    }

    public Vec2f add(Vec2f value) {
        this.x += value.x;
        this.y += value.y;
        return this;
    }

    public Vec2f subtract(Vec2f value) {
        this.x -= value.x;
        this.y -= value.y;
        return this;
    }

    public Vec2f divide(Vec2f value) {
        this.x /= value.x;
        this.y /= value.y;
        return this;
    }

    public Vec2f multiply(Vec2f value) {
        this.x *= value.x;
        this.y *= value.y;
        return this;
    }

    public void writeToNBT(CompoundTag tag) {
        tag.putDouble("x", this.x);
        tag.putDouble("y", this.y);
    }

    public void readFromNBT(CompoundTag tag) {
        this.x = tag.getDouble("x");
        this.y = tag.getDouble("y");
    }

    public Vec2f copy() {
        return new Vec2f(this.x, this.y);
    }

    public Vec2f abs() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        return this;
    }

    public String toString() {
        return String.format("(%f, %f)", this.x, this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vec2f vec2f = (Vec2f)o;
        if (this.x != vec2f.x) {
            return false;
        }
        return this.y == vec2f.y;
    }

    public int hashCode() {
        int result = (int)this.x;
        result = (int)((double)(31 * result) + this.y);
        return result;
    }
}

