/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.attribute.type;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import sunsetsatellite.catalyst.effects.api.attribute.Attribute;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.ModifierType;
import sunsetsatellite.catalyst.effects.api.modifier.type.BooleanModifier;

public final class BooleanAttribute
extends Attribute<Boolean> {
    public BooleanAttribute(String key, boolean defaultValue) {
        super(key, defaultValue);
    }

    @Override
    public Boolean calculate(IHasEffects target) {
        if (target.getContainer().getAttributes().contains(this)) {
            for (EffectStack effectStack : target.getContainer().getEffects()) {
                if (!effectStack.hasAttribute(this)) continue;
                boolean value = (Boolean)this.getBaseValue();
                List validModifiers = effectStack.getEffect().getModifiers().stream().filter(M -> M.attribute.getClass().isAssignableFrom(this.getClass())).map(M -> {
                    if (M instanceof BooleanModifier) {
                        return (BooleanModifier)M;
                    }
                    return null;
                }).filter(Objects::nonNull).sorted(Comparator.comparing(M -> M.type)).collect(Collectors.toList());
                for (BooleanModifier modifier : validModifiers) {
                    if (Objects.requireNonNull(modifier.type) != ModifierType.SET || (Boolean)modifier.value == value) continue;
                    return (Boolean)modifier.value;
                }
            }
            return (Boolean)this.getBaseValue();
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }

    @Override
    public Boolean calculate(IHasEffects target, Boolean baseValue) {
        if (target.getContainer().getAttributes().contains(this)) {
            for (EffectStack effectStack : target.getContainer().getEffects()) {
                if (!effectStack.hasAttribute(this) || !effectStack.isActive()) continue;
                boolean value = baseValue;
                List validModifiers = effectStack.getEffect().getModifiers().stream().filter(M -> M.attribute.getClass().isAssignableFrom(this.getClass())).map(M -> {
                    if (M instanceof BooleanModifier) {
                        return (BooleanModifier)M;
                    }
                    return null;
                }).filter(Objects::nonNull).sorted(Comparator.comparing(M -> M.type)).collect(Collectors.toList());
                for (BooleanModifier modifier : validModifiers) {
                    if (Objects.requireNonNull(modifier.type) != ModifierType.SET || (Boolean)modifier.value == value) continue;
                    return (Boolean)modifier.value;
                }
            }
            return baseValue;
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }
}

