/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.attribute.type;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import sunsetsatellite.catalyst.effects.api.attribute.type.NumberAttribute;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.type.NumberModifier;

public final class DoubleAttribute
extends NumberAttribute<Double> {
    public DoubleAttribute(String key, Double defaultValue, Double minValue, Double maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    public DoubleAttribute(String key, Double defaultValue) {
        super(key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    @Override
    public Double calculate(IHasEffects target) {
        if (target.getContainer().getAttributes().contains(this)) {
            for (EffectStack effectStack : target.getContainer().getEffects()) {
                if (!effectStack.hasAttribute(this) || !effectStack.isActive()) continue;
                double value = (Double)this.getBaseValue();
                List validModifiers = effectStack.getEffect().getModifiers().stream().filter(M -> M.attribute.getClass().isAssignableFrom(this.getClass())).map(M -> {
                    if (M instanceof NumberModifier) {
                        return (NumberModifier)M;
                    }
                    return null;
                }).filter(Objects::nonNull).sorted(Comparator.comparing(M -> M.type)).collect(Collectors.toList());
                for (NumberModifier modifier : validModifiers) {
                    switch (modifier.type) {
                        case SET: {
                            if (!(((Number)modifier.calculate(effectStack)).doubleValue() > value)) break;
                            value = ((Number)modifier.calculate(effectStack)).doubleValue();
                            break;
                        }
                        case ADD: {
                            value += ((Number)modifier.calculate(effectStack)).doubleValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= ((Number)modifier.calculate(effectStack)).doubleValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100.0 * ((Number)modifier.calculate(effectStack)).doubleValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100.0 * ((Number)modifier.calculate(effectStack)).doubleValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= ((Number)modifier.calculate(effectStack)).doubleValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= ((Number)modifier.calculate(effectStack)).doubleValue();
                        }
                    }
                }
                return Math.min((Double)this.maxValue, Math.max(value, (Double)this.minValue));
            }
            return (Double)this.getBaseValue();
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }

    @Override
    public Double calculate(IHasEffects target, Double baseValue) {
        if (target.getContainer().getAttributes().contains(this)) {
            for (EffectStack effectStack : target.getContainer().getEffects()) {
                if (!effectStack.hasAttribute(this)) continue;
                double value = baseValue;
                List validModifiers = effectStack.getEffect().getModifiers().stream().filter(M -> M.attribute.getClass().isAssignableFrom(this.getClass())).map(M -> {
                    if (M instanceof NumberModifier) {
                        return (NumberModifier)M;
                    }
                    return null;
                }).filter(Objects::nonNull).sorted(Comparator.comparing(M -> M.type)).collect(Collectors.toList());
                for (NumberModifier modifier : validModifiers) {
                    switch (modifier.type) {
                        case SET: {
                            if (!(((Number)modifier.calculate(effectStack)).doubleValue() > value)) break;
                            value = ((Number)modifier.calculate(effectStack)).doubleValue();
                            break;
                        }
                        case ADD: {
                            value += ((Number)modifier.calculate(effectStack)).doubleValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= ((Number)modifier.calculate(effectStack)).doubleValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100.0 * ((Number)modifier.calculate(effectStack)).doubleValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100.0 * ((Number)modifier.calculate(effectStack)).doubleValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= ((Number)modifier.calculate(effectStack)).doubleValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= ((Number)modifier.calculate(effectStack)).doubleValue();
                        }
                    }
                }
                return Math.min((Double)this.maxValue, Math.max(value, (Double)this.minValue));
            }
            return baseValue;
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }
}

