/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.attribute.type;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import sunsetsatellite.catalyst.effects.api.attribute.type.NumberAttribute;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.type.NumberModifier;

public final class IntAttribute
extends NumberAttribute<Integer> {
    public IntAttribute(String key, Integer defaultValue, Integer minValue, Integer maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    public IntAttribute(String key, Integer defaultValue) {
        super(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Integer calculate(IHasEffects target) {
        if (target.getContainer().getAttributes().contains(this)) {
            for (EffectStack effectStack : target.getContainer().getEffects()) {
                if (!effectStack.hasAttribute(this)) continue;
                int value = (Integer)this.getBaseValue();
                List validModifiers = effectStack.getEffect().getModifiers().stream().filter(M -> M.attribute.getClass().isAssignableFrom(this.getClass())).map(M -> {
                    if (M instanceof NumberModifier) {
                        return (NumberModifier)M;
                    }
                    return null;
                }).filter(Objects::nonNull).sorted(Comparator.comparing(M -> M.type)).collect(Collectors.toList());
                for (NumberModifier modifier : validModifiers) {
                    switch (modifier.type) {
                        case SET: {
                            if (((Number)modifier.calculate(effectStack)).intValue() <= value) break;
                            value = ((Number)modifier.calculate(effectStack)).intValue();
                            break;
                        }
                        case ADD: {
                            value += ((Number)modifier.calculate(effectStack)).intValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= ((Number)modifier.calculate(effectStack)).intValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100 * ((Number)modifier.calculate(effectStack)).intValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100 * ((Number)modifier.calculate(effectStack)).intValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= ((Number)modifier.calculate(effectStack)).intValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= ((Number)modifier.calculate(effectStack)).intValue();
                        }
                    }
                }
                return Math.min((Integer)this.maxValue, Math.max(value, (Integer)this.minValue));
            }
            return (Integer)this.getBaseValue();
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }

    @Override
    public Integer calculate(IHasEffects target, Integer baseValue) {
        if (target.getContainer().getAttributes().contains(this)) {
            for (EffectStack effectStack : target.getContainer().getEffects()) {
                if (!effectStack.hasAttribute(this) || !effectStack.isActive()) continue;
                int value = baseValue;
                List validModifiers = effectStack.getEffect().getModifiers().stream().filter(M -> M.attribute.getClass().isAssignableFrom(this.getClass())).map(M -> {
                    if (M instanceof NumberModifier) {
                        return (NumberModifier)M;
                    }
                    return null;
                }).filter(Objects::nonNull).sorted(Comparator.comparing(M -> M.type)).collect(Collectors.toList());
                for (NumberModifier modifier : validModifiers) {
                    switch (modifier.type) {
                        case SET: {
                            if (((Number)modifier.calculate(effectStack)).intValue() <= value) break;
                            value = ((Number)modifier.calculate(effectStack)).intValue();
                            break;
                        }
                        case ADD: {
                            value += ((Number)modifier.calculate(effectStack)).intValue();
                            break;
                        }
                        case SUBTRACT: {
                            value -= ((Number)modifier.calculate(effectStack)).intValue();
                            break;
                        }
                        case PERCENT_ADD: {
                            value += value / 100 * ((Number)modifier.calculate(effectStack)).intValue();
                            break;
                        }
                        case PERCENT_SUBTRACT: {
                            value -= value / 100 * ((Number)modifier.calculate(effectStack)).intValue();
                            break;
                        }
                        case MULTIPLY: {
                            value *= ((Number)modifier.calculate(effectStack)).intValue();
                            break;
                        }
                        case DIVIDE: {
                            value /= ((Number)modifier.calculate(effectStack)).intValue();
                        }
                    }
                }
                return Math.min((Integer)this.maxValue, Math.max(value, (Integer)this.minValue));
            }
            return baseValue;
        }
        throw new IllegalStateException(String.format("Target '%s' doesn't contain attribute '%s'", target, this.getName()));
    }
}

