/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.effect;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.lang.I18n;
import sunsetsatellite.catalyst.effects.api.effect.EffectContainer;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.EffectTimeType;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;
import sunsetsatellite.catalyst.effects.api.modifier.Modifier;

public class Effect
implements ITaggable<Effect> {
    private final String nameKey;
    public final String id;
    private final List<Modifier<?>> modifiers;
    private final EffectTimeType effectTimeType;
    private int defaultDuration;
    private int durationIncrease;
    private final int maxStack;
    private boolean persistent = false;

    public Effect(String nameKey, String id, List<Modifier<?>> modifiers, EffectTimeType effectTimeType, int maxStack) {
        this.nameKey = nameKey;
        this.id = id;
        this.modifiers = modifiers;
        this.effectTimeType = effectTimeType;
        this.maxStack = maxStack;
    }

    public Effect setDefaultDuration(int defaultDuration) {
        this.defaultDuration = defaultDuration;
        return this;
    }

    public Effect setPersistent() {
        this.persistent = true;
        return this;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public Effect setDurationIncrease(int increase) {
        if (this.effectTimeType != EffectTimeType.ADD) {
            throw new IllegalArgumentException("Duration increase can only be applied to effects with time type ADD!");
        }
        this.durationIncrease = increase;
        return this;
    }

    public int getDurationIncrease() {
        if (this.effectTimeType != EffectTimeType.ADD) {
            return 0;
        }
        return this.durationIncrease;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public String getName() {
        return I18n.getInstance().translateNameKey(this.nameKey);
    }

    public List<Modifier<?>> getModifiers() {
        return Collections.unmodifiableList(this.modifiers);
    }

    public EffectTimeType getTimeType() {
        return this.effectTimeType;
    }

    public int getDefaultDuration() {
        return this.defaultDuration;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public boolean canApplyTo(Entity target) {
        for (Tag<Effect> tag : ((IHasEffects)target).getImmunities()) {
            if (!tag.appliesTo((ITaggable)this)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Effect effect = (Effect)o;
        if (this.getDefaultDuration() != effect.getDefaultDuration()) {
            return false;
        }
        if (this.getMaxStack() != effect.getMaxStack()) {
            return false;
        }
        if (this.getNameKey() != null ? !this.getNameKey().equals(effect.getNameKey()) : effect.getNameKey() != null) {
            return false;
        }
        if (!Objects.equals(this.id, effect.id)) {
            return false;
        }
        if (this.getModifiers() != null ? !this.getModifiers().equals(effect.getModifiers()) : effect.getModifiers() != null) {
            return false;
        }
        return this.effectTimeType == effect.effectTimeType;
    }

    public <T> void removed(EffectStack effectStack, EffectContainer<T> effectContainer) {
    }

    public <T> void activated(EffectStack effectStack, EffectContainer<T> container) {
    }

    public <T> void paused(EffectStack effectStack, EffectContainer<T> container) {
    }

    public <T> void unpaused(EffectStack effectStack, EffectContainer<T> container) {
    }

    public <T> void tick(EffectStack effectStack, EffectContainer<T> effectContainer) {
    }

    public <T> void expired(EffectStack effectStack, EffectContainer<T> effectContainer) {
    }

    public <T> void stackAdded(EffectStack effectStack, EffectContainer<T> effectContainer) {
    }

    public <T> void stackSubtracted(EffectStack effectStack, EffectContainer<T> effectContainer) {
    }

    public boolean isIn(Tag tag) {
        return tag.appliesTo((ITaggable)this);
    }
}

