/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.effect;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.entity.Entity;
import sunsetsatellite.catalyst.effects.api.attribute.Attribute;
import sunsetsatellite.catalyst.effects.api.effect.Effect;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.net.SyncEffectContainerForEntityNetworkMessage;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class EffectContainer<T> {
    private final List<EffectStack> effects = new ArrayList<EffectStack>();
    private final Set<Attribute<?>> attributes = new HashSet();
    private final T parent;

    public EffectContainer(T parent) {
        this.parent = parent;
    }

    public Set<Attribute<?>> getAttributes() {
        return this.attributes;
    }

    public List<EffectStack> getEffects() {
        return Collections.unmodifiableList(this.effects);
    }

    public T getParent() {
        return this.parent;
    }

    public void add(EffectStack effectStack) {
        if (!effectStack.getEffect().canApplyTo((Entity)this.parent)) {
            return;
        }
        for (EffectStack effect : this.effects) {
            if (effect.getEffect() != effectStack.getEffect()) continue;
            int amount = effect.getAmount() + effectStack.getAmount() >= effect.getEffect().getMaxStack() ? effect.getEffect().getMaxStack() - effect.getAmount() : effectStack.getAmount();
            effect.add(amount, this);
            if (EnvironmentHelper.isServerEnvironment()) {
                NetworkHandler.sendToAllPlayers((NetworkMessage)new SyncEffectContainerForEntityNetworkMessage((Entity)this.getParent()));
            }
            return;
        }
        this.effects.add(effectStack);
        if (EnvironmentHelper.isServerEnvironment()) {
            NetworkHandler.sendToAllPlayers((NetworkMessage)new SyncEffectContainerForEntityNetworkMessage((Entity)this.getParent()));
        }
    }

    public void subtract(EffectStack effectStack) {
        for (EffectStack effect : this.effects) {
            if (effect.getEffect() != effectStack.getEffect()) continue;
            effect.subtract(effectStack.getAmount(), this);
            if (EnvironmentHelper.isServerEnvironment()) {
                NetworkHandler.sendToAllPlayers((NetworkMessage)new SyncEffectContainerForEntityNetworkMessage((Entity)this.getParent()));
            }
            return;
        }
    }

    public void remove(Effect effect) {
        ArrayList<EffectStack> copy = new ArrayList<EffectStack>(this.effects);
        for (EffectStack effectStack : copy) {
            if (effectStack.getEffect() != effect) continue;
            this.effects.remove(effectStack);
            effectStack.getEffect().removed(effectStack, this);
        }
        if (EnvironmentHelper.isServerEnvironment()) {
            NetworkHandler.sendToAllPlayers((NetworkMessage)new SyncEffectContainerForEntityNetworkMessage((Entity)this.getParent()));
        }
    }

    public void removeAll() {
        ArrayList<EffectStack> copy = new ArrayList<EffectStack>(this.effects);
        for (EffectStack effectStack : copy) {
            effectStack.getEffect().removed(effectStack, this);
            this.effects.remove(effectStack);
        }
    }

    public boolean hasEffect(Effect effect) {
        for (EffectStack effectStack : this.effects) {
            if (effectStack.getEffect() != effect) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(Attribute<?> attribute) {
        return this.attributes.contains(attribute);
    }

    public void tick() {
        ArrayList<EffectStack> copy = new ArrayList<EffectStack>(this.effects);
        for (EffectStack effectStack : copy) {
            effectStack.tick(this);
            if (effectStack.getAmount() < 1) {
                this.effects.remove(effectStack);
            }
            if (!effectStack.isFinished()) continue;
            this.effects.remove(effectStack);
        }
    }

    public void saveToNbt(CompoundTag tag) {
        for (int i = 0; i < this.effects.size(); ++i) {
            EffectStack effect = this.effects.get(i);
            CompoundTag effectTag = new CompoundTag();
            effect.saveToNbt(effectTag);
            tag.putCompound(String.valueOf(i), effectTag);
        }
    }

    public void loadFromNbt(CompoundTag tag) {
        for (Tag value : tag.getValues()) {
            if (!(value instanceof CompoundTag)) continue;
            this.effects.add(new EffectStack((CompoundTag)value));
        }
    }
}

