/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.api.effect.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.core.net.command.TextFormatting;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import sunsetsatellite.catalyst.effects.api.effect.Effect;
import sunsetsatellite.catalyst.effects.api.effect.EffectContainer;
import sunsetsatellite.catalyst.effects.api.effect.EffectStack;
import sunsetsatellite.catalyst.effects.api.effect.EffectTimeType;
import sunsetsatellite.catalyst.effects.api.effect.render.EffectRenderer;
import sunsetsatellite.catalyst.effects.api.effect.render.EffectRendererDispatcher;
import sunsetsatellite.catalyst.effects.api.modifier.Modifier;
import sunsetsatellite.catalyst.effects.api.modifier.type.BooleanModifier;
import sunsetsatellite.catalyst.effects.api.modifier.type.DoubleModifier;
import sunsetsatellite.catalyst.effects.api.modifier.type.FloatModifier;
import sunsetsatellite.catalyst.effects.api.modifier.type.IntModifier;
import sunsetsatellite.catalyst.effects.api.modifier.type.LongModifier;

@Environment(value=EnvType.CLIENT)
public class EffectRendererManager
extends Gui {
    private static final EffectRendererDispatcher dispatcher = EffectRendererDispatcher.getInstance();

    @Nullable
    public static EffectStack resolveDominantEffect(EffectContainer<?> container) {
        EffectStack dominant = null;
        for (EffectStack effectStack : container.getEffects()) {
            int dominantPotency;
            int effectStackPotency;
            Effect effect = effectStack.getEffect();
            EffectRenderer<?> renderer = dispatcher.getDispatch(effect);
            if (!renderer.shouldDisplayScreenEffect()) continue;
            if (dominant == null) {
                dominant = effectStack;
            }
            if ((effectStackPotency = effectStack.getAmount() * effectStack.getDuration()) <= (dominantPotency = dominant.getAmount() * dominant.getDuration())) continue;
            dominant = effectStack;
        }
        return dominant;
    }

    public void drawScreenEffects(EffectContainer<?> container, Minecraft mc, int mouseX, int mouseY, float partialTick) {
        EffectStack mostPotent = EffectRendererManager.resolveDominantEffect(container);
        if (mostPotent == null) {
            return;
        }
        Effect effect = mostPotent.getEffect();
        EffectRenderer<?> renderer = dispatcher.getDispatch(effect);
        int width = mc.resolution.getScaledWidthScreenCoords();
        int height = mc.resolution.getScaledHeightScreenCoords();
        renderer.drawScreenEffect(mc, this, mostPotent, width, height, mouseX, mouseY, partialTick);
    }

    public void drawEffectIndicators(EffectContainer<?> container, Minecraft mc, int mouseX, int mouseY, float partialTick) {
        this.begin();
        int x = 4;
        int y = 4;
        for (EffectStack stack : container.getEffects()) {
            EffectRenderer<?> renderer = dispatcher.getDispatch(stack.getEffect());
            if (!renderer.shouldDisplayIcon()) continue;
            this.drawEffectIcon(mc, renderer, stack, x, y, mouseX, mouseY);
            if (mouseX > x && mouseX < x + 20 && mouseY > y && mouseY < y + 20) {
                this.end();
                this.drawTooltip(mc, stack, mouseX, mouseY);
                this.begin();
            }
            x += 24;
        }
        this.end();
    }

    private void drawTooltip(Minecraft mc, EffectStack effect, int mouseX, int mouseY) {
        TooltipElement tooltip = new TooltipElement(mc);
        StringBuilder sb = new StringBuilder();
        sb.append(effect.getEffect().getName()).append(" ").append("(x").append(effect.getAmount()).append(")").append("\n");
        for (Modifier<?> modifier : effect.getEffect().getModifiers()) {
            if (modifier instanceof IntModifier) {
                sb.append("  ").append(String.format(modifier.type.template, ((IntModifier)modifier).calculate(effect), modifier.attribute.getName()));
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    sb.append(": ").append(TextFormatting.GRAY).append(modifier.attribute.getDesc()).append(TextFormatting.WHITE).append("\n");
                    continue;
                }
                sb.append("\n");
                continue;
            }
            if (modifier instanceof LongModifier) {
                sb.append("  ").append(String.format(modifier.type.template, ((LongModifier)modifier).calculate(effect), modifier.attribute.getName()));
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    sb.append(": ").append(TextFormatting.GRAY).append(modifier.attribute.getDesc()).append(TextFormatting.WHITE).append("\n");
                    continue;
                }
                sb.append("\n");
                continue;
            }
            if (modifier instanceof FloatModifier) {
                sb.append("  ").append(String.format(modifier.type.template, String.format("%.2f", ((FloatModifier)modifier).calculate(effect)), modifier.attribute.getName()));
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    sb.append(": ").append(TextFormatting.GRAY).append(modifier.attribute.getDesc()).append(TextFormatting.WHITE).append("\n");
                    continue;
                }
                sb.append("\n");
                continue;
            }
            if (modifier instanceof DoubleModifier) {
                sb.append("  ").append(String.format(modifier.type.template, String.format("%.2f", ((DoubleModifier)modifier).calculate(effect)), modifier.attribute.getName()));
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    sb.append(": ").append(TextFormatting.GRAY).append(modifier.attribute.getDesc()).append(TextFormatting.WHITE).append("\n");
                    continue;
                }
                sb.append("\n");
                continue;
            }
            if (!(modifier instanceof BooleanModifier)) continue;
            sb.append("  ").append(modifier);
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                sb.append(": ").append(TextFormatting.GRAY).append(modifier.attribute.getDesc()).append(TextFormatting.WHITE).append("\n");
                continue;
            }
            sb.append("\n");
        }
        if (effect.getEffect().getTimeType() != EffectTimeType.PERMANENT) {
            sb.append("(").append(effect.getTimeLeft() / 20).append("s)");
        }
        if (effect.getEffect().getTimeType() == EffectTimeType.ADD) {
            sb.append(" (+").append(effect.getEffect().getDurationIncrease() / 20).append("s/ea)");
        }
        tooltip.render(sb.toString(), mouseX, mouseY, 4, 4);
    }

    private void drawEffectIcon(Minecraft mc, EffectRenderer<?> effectRenderer, EffectStack stack, int x, int y, int mouseX, int mouseY) {
        this.drawRectWidthHeight(x, y, 20, 20, effectRenderer.getColor());
        this.end();
        effectRenderer.drawIcon(mc, this, x, y);
        this.drawString(mc.font, "x" + stack.getAmount(), x + 1, y + 10, -1);
        this.begin();
        this.drawRectWidthHeight(x, y, 20, (int)(20.0f - (float)stack.getTimeLeft() / (float)stack.getDuration() * 20.0f), Integer.MIN_VALUE);
    }

    private void begin() {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
    }

    private void end() {
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }
}

