/*
 * Decompiled with CFR 0.152.
 */
package sunsetsatellite.catalyst.effects.mixin;

import com.mojang.nbt.tags.CompoundTag;
import java.util.Set;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sunsetsatellite.catalyst.effects.api.attribute.Attribute;
import sunsetsatellite.catalyst.effects.api.attribute.Attributes;
import sunsetsatellite.catalyst.effects.api.effect.Effect;
import sunsetsatellite.catalyst.effects.api.effect.EffectContainer;
import sunsetsatellite.catalyst.effects.api.effect.EffectTagDispatcher;
import sunsetsatellite.catalyst.effects.api.effect.IHasEffects;

@Mixin(value={Entity.class}, remap=false)
public class EntityMixin
implements IHasEffects {
    @Unique
    private final Entity thisAs = (Entity)this;
    @Unique
    public EffectContainer<Entity> effectContainer = new EffectContainer<Entity>(this.thisAs);

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(World world, CallbackInfo ci) {
        Attributes.getInstance().forEach(A -> {
            if (A.isDefault() && A.getValidEntities().stream().anyMatch(E -> E.isAssignableFrom(this.thisAs.getClass()))) {
                this.effectContainer.getAttributes().add((Attribute<?>)A);
            }
        });
    }

    public EffectContainer<Entity> getContainer() {
        return this.effectContainer;
    }

    @Override
    public boolean isImmuneTo(Tag<Effect> effect) {
        Set<Tag<Effect>> set = EffectTagDispatcher.getImmunitiesFor(this.thisAs.getClass());
        return set.contains(effect);
    }

    @Override
    public Set<Tag<Effect>> getImmunities() {
        return EffectTagDispatcher.getImmunitiesFor(this.thisAs.getClass());
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        this.effectContainer.tick();
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        CompoundTag effects = new CompoundTag();
        this.getContainer().saveToNbt(effects);
        tag.putCompound("Effects", effects);
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.getContainer().loadFromNbt(tag.getCompound("Effects"));
    }
}

