/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.mappingio.tree;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.impl.lib.mappingio.MappedElementKind;
import net.fabricmc.loader.impl.lib.mappingio.MappingFlag;
import net.fabricmc.loader.impl.lib.mappingio.MappingVisitor;
import net.fabricmc.loader.impl.lib.mappingio.tree.HierarchyInfoProvider;
import net.fabricmc.loader.impl.lib.mappingio.tree.MappingTree;
import net.fabricmc.loader.impl.lib.mappingio.tree.VisitOrder;
import net.fabricmc.loader.impl.lib.mappingio.tree.VisitableMappingTree;
import org.jetbrains.annotations.Nullable;

public final class MemoryMappingTree
implements VisitableMappingTree {
    private boolean indexByDstNames;
    private String srcNamespace;
    private List<String> dstNamespaces = Collections.emptyList();
    private final List<MappingTree.MetadataEntry> metadata = new ArrayList<MappingTree.MetadataEntry>();
    private final Map<String, ClassEntry> classesBySrcName = new LinkedHashMap<String, ClassEntry>();
    private Map<String, ClassEntry>[] classesByDstNames;
    private HierarchyInfoProvider<?> hierarchyInfo;
    private int srcNsMap;
    private int[] dstNameMap;
    private Entry<?> currentEntry;
    private ClassEntry currentClass;
    private MethodEntry currentMethod;
    private Map<GlobalMemberKey, MemberEntry<?>> pendingMembers;

    public MemoryMappingTree() {
        this(false);
    }

    public MemoryMappingTree(boolean indexByDstNames) {
        this.indexByDstNames = indexByDstNames;
    }

    private void initClassesByDstNames() {
        this.classesByDstNames = new Map[this.dstNamespaces.size()];
        for (int i = 0; i < this.classesByDstNames.length; ++i) {
            this.classesByDstNames[i] = new HashMap<String, ClassEntry>(this.classesBySrcName.size());
        }
        for (ClassEntry cls : this.classesBySrcName.values()) {
            for (int i = 0; i < cls.dstNames.length; ++i) {
                String dstName = cls.dstNames[i];
                if (dstName == null) continue;
                this.classesByDstNames[i].put(dstName, cls);
            }
        }
    }

    @Override
    @Nullable
    public String getSrcNamespace() {
        return this.srcNamespace;
    }

    @Override
    public List<String> getDstNamespaces() {
        return this.dstNamespaces;
    }

    private void resizeDstNames(int newSize) {
        for (ClassEntry cls : this.classesBySrcName.values()) {
            cls.resizeDstNames(newSize);
            for (FieldEntry field : cls.getFields()) {
                field.resizeDstNames(newSize);
            }
            for (MethodEntry method : cls.getMethods()) {
                method.resizeDstNames(newSize);
                for (MethodArgEntry arg : method.getArgs()) {
                    arg.resizeDstNames(newSize);
                }
                for (MethodVarEntry var : method.getVars()) {
                    var.resizeDstNames(newSize);
                }
            }
        }
    }

    public void addMetadata(MappingTree.MetadataEntry entry) {
        this.metadata.add(entry);
    }

    @Override
    public Collection<? extends MappingTree.ClassMapping> getClasses() {
        return this.classesBySrcName.values();
    }

    @Override
    @Nullable
    public MappingTree.ClassMapping getClass(String srcName) {
        return this.classesBySrcName.get(srcName);
    }

    @Override
    @Nullable
    public MappingTree.ClassMapping getClass(String name, int namespace) {
        if (namespace < 0 || !this.indexByDstNames) {
            return VisitableMappingTree.super.getClass(name, namespace);
        }
        return this.classesByDstNames[namespace].get(name);
    }

    private int getSrcNsEquivalent(MappingTree.ElementMapping mapping) {
        int ret = mapping.getTree().getNamespaceId(this.srcNamespace);
        if (ret == -2) {
            throw new UnsupportedOperationException("can't find source namespace in referenced mapping tree");
        }
        return ret;
    }

    @Override
    public void accept(MappingVisitor visitor, VisitOrder order) throws IOException {
        do {
            if (visitor.visitHeader()) {
                Object uniqueMetadata;
                visitor.visitNamespaces(this.srcNamespace, this.dstNamespaces);
                Object metadataToVisit = this.metadata;
                if (visitor.getFlags().contains((Object)MappingFlag.NEEDS_METADATA_UNIQUENESS)) {
                    uniqueMetadata = new ArrayDeque();
                    HashSet<String> addedKeys = new HashSet<String>();
                    for (int i = this.metadata.size() - 1; i >= 0; --i) {
                        MappingTree.MetadataEntry entry = this.metadata.get(i);
                        if (addedKeys.contains(entry.getKey())) continue;
                        addedKeys.add(entry.getKey());
                        uniqueMetadata.addFirst(entry);
                    }
                    metadataToVisit = uniqueMetadata;
                }
                uniqueMetadata = metadataToVisit.iterator();
                while (uniqueMetadata.hasNext()) {
                    MappingTree.MetadataEntry entry = (MappingTree.MetadataEntry)uniqueMetadata.next();
                    visitor.visitMetadata(entry.getKey(), entry.getValue());
                }
            }
            if (!visitor.visitContent()) continue;
            Set<MappingFlag> flags = visitor.getFlags();
            boolean supplyFieldDstDescs = flags.contains((Object)MappingFlag.NEEDS_DST_FIELD_DESC);
            boolean supplyMethodDstDescs = flags.contains((Object)MappingFlag.NEEDS_DST_METHOD_DESC);
            for (ClassEntry cls : order.sortClasses(this.classesBySrcName.values())) {
                cls.accept(visitor, order, supplyFieldDstDescs, supplyMethodDstDescs);
            }
        } while (!visitor.visitEnd());
    }

    @Override
    public void reset() {
        this.currentEntry = null;
        this.currentClass = null;
        this.currentMethod = null;
    }

    @Override
    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) {
        this.srcNsMap = -1;
        this.dstNameMap = new int[dstNamespaces.size()];
        if (this.srcNamespace != null) {
            if (!srcNamespace.equals(this.srcNamespace)) {
                this.srcNsMap = this.dstNamespaces.indexOf(srcNamespace);
                if (this.srcNsMap < 0) {
                    throw new UnsupportedOperationException("can't merge with disassociated src namespace");
                }
            }
            int newDstNamespaces = 0;
            for (int i = 0; i < this.dstNameMap.length; ++i) {
                int idx;
                String dstNs = dstNamespaces.get(i);
                if (dstNs.equals(srcNamespace)) {
                    idx = -1;
                } else {
                    idx = this.dstNamespaces.indexOf(dstNs);
                    if (idx < 0) {
                        if (dstNs.equals(this.srcNamespace)) {
                            throw new UnsupportedOperationException("can't merge with existing src namespace in new dst namespaces");
                        }
                        if (newDstNamespaces == 0) {
                            this.dstNamespaces = new ArrayList<String>(this.dstNamespaces);
                        }
                        idx = this.dstNamespaces.size();
                        this.dstNamespaces.add(dstNs);
                        ++newDstNamespaces;
                    }
                }
                this.dstNameMap[i] = idx;
            }
            if (newDstNamespaces > 0) {
                int newSize = this.dstNamespaces.size();
                this.resizeDstNames(newSize);
                if (this.indexByDstNames) {
                    this.classesByDstNames = Arrays.copyOf(this.classesByDstNames, newSize);
                    for (int i = newSize - newDstNamespaces; i < this.classesByDstNames.length; ++i) {
                        this.classesByDstNames[i] = new HashMap<String, ClassEntry>(this.classesBySrcName.size());
                    }
                }
            }
        } else {
            this.srcNamespace = srcNamespace;
            this.dstNamespaces = dstNamespaces;
            for (int i = 0; i < this.dstNameMap.length; ++i) {
                this.dstNameMap[i] = dstNamespaces.get(i).equals(srcNamespace) ? -1 : i;
            }
            if (this.indexByDstNames) {
                this.initClassesByDstNames();
            }
        }
    }

    @Override
    public void visitMetadata(String key, @Nullable String value) {
        MetadataEntryImpl entry = new MetadataEntryImpl(key, value);
        this.addMetadata(entry);
    }

    @Override
    public boolean visitClass(String srcName) {
        this.currentMethod = null;
        ClassEntry cls = (ClassEntry)this.getClass(srcName, this.srcNsMap);
        if (cls == null) {
            if (this.srcNsMap >= 0) {
                cls = new ClassEntry(this, null);
                cls.setDstName(srcName, this.srcNsMap);
            } else {
                cls = new ClassEntry(this, srcName);
                this.classesBySrcName.put(srcName, cls);
            }
        }
        this.currentEntry = this.currentClass = cls;
        return true;
    }

    @Override
    public boolean visitField(String srcName, @Nullable String srcDesc) {
        if (this.currentClass == null) {
            throw new UnsupportedOperationException("Tried to visit field before owning class");
        }
        this.currentMethod = null;
        FieldEntry field = this.currentClass.getField(srcName, srcDesc, this.srcNsMap);
        if (field == null) {
            if (this.srcNsMap >= 0) {
                field = (FieldEntry)this.queuePendingMember(srcName, srcDesc, true);
            } else {
                field = new FieldEntry(this.currentClass, srcName, srcDesc);
                field = this.currentClass.addField(field);
            }
        } else if (srcDesc != null && field.srcDesc == null) {
            field.setSrcDesc(this.mapDesc(srcDesc, this.srcNsMap, -1));
        }
        this.currentEntry = field;
        return true;
    }

    @Override
    public boolean visitMethod(String srcName, @Nullable String srcDesc) {
        if (this.currentClass == null) {
            throw new UnsupportedOperationException("Tried to visit method before owning class");
        }
        MethodEntry method = this.currentClass.getMethod(srcName, srcDesc, this.srcNsMap);
        if (method == null) {
            if (this.srcNsMap >= 0) {
                method = (MethodEntry)this.queuePendingMember(srcName, srcDesc, false);
            } else {
                method = new MethodEntry(this.currentClass, srcName, srcDesc);
                method = this.currentClass.addMethod(method);
            }
        } else if (srcDesc != null && (method.srcDesc == null || method.srcDesc.endsWith(")") && !srcDesc.endsWith(")"))) {
            method.setSrcDesc(this.mapDesc(srcDesc, this.srcNsMap, -1));
        }
        this.currentEntry = this.currentMethod = method;
        return true;
    }

    private MemberEntry<?> queuePendingMember(String name, @Nullable String desc, boolean isField) {
        GlobalMemberKey key;
        MemberEntry member;
        if (this.pendingMembers == null) {
            this.pendingMembers = new HashMap();
        }
        if ((member = this.pendingMembers.get(key = new GlobalMemberKey(this.currentClass, name, desc, isField))) == null) {
            member = isField ? new FieldEntry(this.currentClass, null, desc) : new MethodEntry(this.currentClass, null, desc);
            this.pendingMembers.put(key, member);
        }
        if (this.srcNsMap >= 0) {
            member.setDstName(name, this.srcNsMap);
        }
        return member;
    }

    private void addPendingMember(MemberEntry<?> member) {
        String name = member.getName(this.srcNsMap);
        if (name == null) {
            return;
        }
        String desc = member.getDesc(this.srcNsMap);
        if (member.getKind() == MappedElementKind.FIELD) {
            FieldEntry field = member.getOwner().getField(name, desc);
            if (field == null) {
                member.srcName = name;
                member.setSrcDesc(desc);
            } else {
                field.copyFrom((FieldEntry)member, false);
            }
        } else {
            MethodEntry method = member.getOwner().getMethod(name, desc);
            if (method == null) {
                member.srcName = name;
                member.setSrcDesc(desc);
            } else {
                method.copyFrom((MethodEntry)member, false);
            }
        }
    }

    @Override
    public boolean visitMethodArg(int argPosition, int lvIndex, @Nullable String srcName) {
        if (this.currentMethod == null) {
            throw new UnsupportedOperationException("Tried to visit method argument before owning method");
        }
        MethodArgEntry arg = this.currentMethod.getArg(argPosition, lvIndex, srcName);
        if (arg == null) {
            arg = new MethodArgEntry(this.currentMethod, argPosition, lvIndex, srcName);
            arg = this.currentMethod.addArg(arg);
        } else {
            if (argPosition >= 0 && arg.argPosition < 0) {
                arg.setArgPosition(argPosition);
            }
            if (lvIndex >= 0 && arg.lvIndex < 0) {
                arg.setLvIndex(lvIndex);
            }
            if (srcName != null) {
                assert (!srcName.isEmpty());
                arg.setSrcName(srcName);
            }
        }
        this.currentEntry = arg;
        return true;
    }

    @Override
    public boolean visitMethodVar(int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName) {
        if (this.currentMethod == null) {
            throw new UnsupportedOperationException("Tried to visit method variable before owning method");
        }
        MethodVarEntry var = this.currentMethod.getVar(lvtRowIndex, lvIndex, startOpIdx, endOpIdx, srcName);
        if (var == null) {
            var = new MethodVarEntry(this.currentMethod, lvtRowIndex, lvIndex, startOpIdx, endOpIdx, srcName);
            var = this.currentMethod.addVar(var);
        } else {
            if (lvtRowIndex >= 0 && var.lvtRowIndex < 0) {
                var.setLvtRowIndex(lvtRowIndex);
            }
            if (lvIndex >= 0 && startOpIdx >= 0 && (var.lvIndex < 0 || var.startOpIdx < 0)) {
                var.setLvIndex(lvIndex, startOpIdx, endOpIdx);
            }
            if (srcName != null) {
                assert (!srcName.isEmpty());
                var.setSrcName(srcName);
            }
        }
        this.currentEntry = var;
        return true;
    }

    @Override
    public boolean visitEnd() {
        this.currentEntry = null;
        this.currentClass = null;
        this.currentMethod = null;
        if (this.pendingMembers != null) {
            for (MemberEntry<?> member : this.pendingMembers.values()) {
                this.addPendingMember(member);
            }
            this.pendingMembers = null;
        }
        if (this.hierarchyInfo != null) {
            this.propagateNames(this.hierarchyInfo);
        }
        return true;
    }

    private <T> void propagateNames(HierarchyInfoProvider<T> provider) {
        int nsId = this.getNamespaceId(provider.getNamespace());
        if (nsId == -2) {
            return;
        }
        Set processed = Collections.newSetFromMap(new IdentityHashMap());
        for (ClassEntry cls : this.classesBySrcName.values()) {
            for (MethodEntry method : cls.getMethods()) {
                String curName;
                int i;
                Collection<MappingTree.MethodMapping> hierarchyMethods;
                T hierarchy;
                String name = method.getName(nsId);
                if (name == null || name.startsWith("<") || !processed.add(method) || provider.getHierarchySize(hierarchy = provider.getMethodHierarchy(method)) <= 1 || (hierarchyMethods = provider.getHierarchyMethods(hierarchy, this)).size() <= 1) continue;
                String[] dstNames = new String[this.dstNamespaces.size()];
                int rem = dstNames.length;
                block2: for (MappingTree.MethodMapping m : hierarchyMethods) {
                    for (i = 0; i < dstNames.length; ++i) {
                        if (dstNames[i] != null || (curName = m.getDstName(i)) == null) continue;
                        dstNames[i] = curName;
                        if (--rem == 0) break block2;
                    }
                }
                for (MappingTree.MethodMapping m : hierarchyMethods) {
                    processed.add((MethodEntry)m);
                    for (i = 0; i < dstNames.length; ++i) {
                        curName = dstNames[i];
                        if (curName == null) continue;
                        m.setDstName(curName, i);
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitDstName(MappedElementKind targetKind, int namespace, String name) {
        namespace = this.dstNameMap[namespace];
        if (this.currentEntry == null) {
            throw new UnsupportedOperationException("Tried to visit mapped name before owner");
        }
        if (namespace < 0) {
            if (name.equals(this.currentEntry.getSrcName())) {
                return;
            }
            switch (this.currentEntry.getKind()) {
                case CLASS: {
                    assert (this.currentClass == this.currentEntry);
                    if (this.currentClass.srcName != null) throw new UnsupportedOperationException("can't change src name for " + (Object)((Object)this.currentEntry.getKind()));
                    this.currentClass.srcName = name;
                    return;
                }
                case METHOD_ARG: {
                    ((MethodArgEntry)this.currentEntry).setSrcName(name);
                    return;
                }
                case METHOD_VAR: {
                    ((MethodVarEntry)this.currentEntry).setSrcName(name);
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("can't change src name for " + (Object)((Object)this.currentEntry.getKind()));
                }
            }
        }
        this.currentEntry.setDstName(name, namespace);
    }

    @Override
    public boolean visitElementContent(MappedElementKind targetKind) throws IOException {
        return targetKind != MappedElementKind.CLASS || this.currentClass.getSrcName() != null;
    }

    @Override
    public void visitComment(MappedElementKind targetKind, String comment) {
        Entry entry;
        switch (targetKind) {
            case CLASS: {
                entry = this.currentClass;
                break;
            }
            case METHOD: {
                entry = this.currentMethod;
                break;
            }
            default: {
                entry = this.currentEntry;
            }
        }
        if (entry == null) {
            throw new UnsupportedOperationException("Tried to visit comment before owning target");
        }
        entry.setComment(comment);
    }

    static final class ClassEntry
    extends Entry<ClassEntry>
    implements MappingTree.ClassMapping {
        protected final MemoryMappingTree tree;
        private Map<MemberKey, FieldEntry> fields = null;
        private Map<MemberKey, MethodEntry> methods = null;
        private byte flags;

        ClassEntry(MemoryMappingTree tree, String srcName) {
            super(tree, srcName);
            this.tree = tree;
        }

        @Override
        public MappedElementKind getKind() {
            return MappedElementKind.CLASS;
        }

        @Override
        public MemoryMappingTree getTree() {
            return this.tree;
        }

        @Override
        public void setDstName(String name, int namespace) {
            String oldName;
            if (this.tree.indexByDstNames && !Objects.equals(name, oldName = this.dstNames[namespace])) {
                Map map = this.tree.classesByDstNames[namespace];
                if (oldName != null) {
                    map.remove(oldName);
                }
                if (name != null) {
                    map.put(name, this);
                } else {
                    map.remove(oldName);
                }
            }
            super.setDstName(name, namespace);
        }

        public Collection<FieldEntry> getFields() {
            if (this.fields == null) {
                return Collections.emptyList();
            }
            return this.fields.values();
        }

        @Override
        @Nullable
        public FieldEntry getField(String srcName, @Nullable String srcDesc) {
            return ClassEntry.getMember(srcName, srcDesc, this.fields, this.flags, 1, 2);
        }

        @Override
        @Nullable
        public FieldEntry getField(String name, @Nullable String desc, int namespace) {
            return (FieldEntry)MappingTree.ClassMapping.super.getField(name, desc, namespace);
        }

        public FieldEntry addField(MappingTree.FieldMapping field) {
            FieldEntry entry;
            FieldEntry fieldEntry = entry = field instanceof FieldEntry && field.getOwner() == this ? (FieldEntry)field : new FieldEntry(this, field, this.tree.getSrcNsEquivalent(field));
            if (this.fields == null) {
                this.fields = new LinkedHashMap<MemberKey, FieldEntry>();
            }
            return this.addMember(entry, this.fields, 1, 2);
        }

        public Collection<MethodEntry> getMethods() {
            if (this.methods == null) {
                return Collections.emptyList();
            }
            return this.methods.values();
        }

        @Override
        @Nullable
        public MethodEntry getMethod(String srcName, @Nullable String srcDesc) {
            return ClassEntry.getMember(srcName, srcDesc, this.methods, this.flags, 4, 8);
        }

        @Override
        @Nullable
        public MethodEntry getMethod(String name, @Nullable String desc, int namespace) {
            return (MethodEntry)MappingTree.ClassMapping.super.getMethod(name, desc, namespace);
        }

        public MethodEntry addMethod(MappingTree.MethodMapping method) {
            MethodEntry entry;
            MethodEntry methodEntry = entry = method instanceof MethodEntry && method.getOwner() == this ? (MethodEntry)method : new MethodEntry(this, method, this.tree.getSrcNsEquivalent(method));
            if (this.methods == null) {
                this.methods = new LinkedHashMap<MemberKey, MethodEntry>();
            }
            return this.addMember(entry, this.methods, 4, 8);
        }

        private static <T extends MemberEntry<T>> T getMember(String srcName, @Nullable String srcDesc, @Nullable Map<MemberKey, T> map, int flags, int flagHasAny, int flagMissesAny) {
            block13: {
                MemberEntry ret;
                boolean missedAnyDesc;
                boolean hasAnyDesc;
                block14: {
                    block12: {
                        Object ret2;
                        if (map == null) {
                            return null;
                        }
                        hasAnyDesc = (flags & flagHasAny) != 0;
                        boolean bl = missedAnyDesc = (flags & flagMissesAny) != 0;
                        if (srcDesc != null) break block12;
                        if (missedAnyDesc && (ret2 = (MemberEntry)map.get(new MemberKey(srcName, null))) != null) {
                            return (T)ret2;
                        }
                        if (!hasAnyDesc) break block13;
                        for (MemberEntry entry : map.values()) {
                            if (!entry.srcName.equals(srcName)) continue;
                            return (T)entry;
                        }
                        break block13;
                    }
                    if (!srcDesc.endsWith(")")) break block14;
                    if (missedAnyDesc) {
                        Object ret3 = (MemberEntry)map.get(new MemberKey(srcName, srcDesc));
                        if (ret3 != null) {
                            return (T)ret3;
                        }
                        ret3 = (MemberEntry)map.get(new MemberKey(srcName, null));
                        if (ret3 != null) {
                            return (T)ret3;
                        }
                    }
                    if (!hasAnyDesc) break block13;
                    for (MemberEntry entry : map.values()) {
                        if (!entry.srcName.equals(srcName) || !entry.srcDesc.startsWith(srcDesc)) continue;
                        return (T)entry;
                    }
                    break block13;
                }
                if (hasAnyDesc && (ret = (MemberEntry)map.get(new MemberKey(srcName, srcDesc))) != null) {
                    return (T)ret;
                }
                if (missedAnyDesc) {
                    ret = (MemberEntry)map.get(new MemberKey(srcName, null));
                    if (ret != null) {
                        return (T)ret;
                    }
                    if (srcDesc.indexOf(41) >= 0) {
                        for (MemberEntry entry : map.values()) {
                            if (!entry.srcName.equals(srcName) || !srcDesc.startsWith(entry.srcDesc)) continue;
                            return (T)entry;
                        }
                    }
                }
            }
            return null;
        }

        private <T extends MemberEntry<T>> T addMember(T entry, Map<MemberKey, T> map, int flagHasAny, int flagMissesAny) {
            MemberEntry ret = (MemberEntry)map.putIfAbsent(entry.key, entry);
            if (ret != null) {
                ret.copyFrom(entry, false);
                return (T)ret;
            }
            if (entry.srcDesc != null && !entry.srcDesc.endsWith(")")) {
                this.flags = (byte)(this.flags | flagHasAny);
                if ((this.flags & flagMissesAny) != 0 && (ret = (MemberEntry)map.remove(new MemberKey(this.srcName, null))) != null) {
                    ret.key = entry.key;
                    ret.srcDesc = entry.srcDesc;
                    map.put(ret.key, ret);
                    ret.copyFrom(entry, false);
                    entry = ret;
                }
                return entry;
            }
            if ((this.flags & flagHasAny) != 0) {
                for (MemberEntry prevEntry : map.values()) {
                    if (prevEntry == entry || !prevEntry.srcName.equals(this.srcName) || entry.srcDesc != null && !prevEntry.srcDesc.startsWith(entry.srcDesc)) continue;
                    map.remove(entry.key);
                    prevEntry.copyFrom(entry, false);
                    return (T)prevEntry;
                }
            }
            this.flags = (byte)(this.flags | flagMissesAny);
            return entry;
        }

        void accept(MappingVisitor visitor, VisitOrder order, boolean supplyFieldDstDescs, boolean supplyMethodDstDescs) throws IOException {
            if (visitor.visitClass(this.srcName) && this.acceptElement(visitor, null)) {
                boolean methodsFirst;
                boolean bl = methodsFirst = order.isMethodsFirst() && this.fields != null && this.methods != null;
                if (!methodsFirst && this.fields != null) {
                    for (FieldEntry field : order.sortFields(this.fields.values())) {
                        field.accept(visitor, supplyFieldDstDescs);
                    }
                }
                if (this.methods != null) {
                    for (MethodEntry method : order.sortMethods(this.methods.values())) {
                        method.accept(visitor, order, supplyMethodDstDescs);
                    }
                }
                if (methodsFirst) {
                    for (FieldEntry field : order.sortFields(this.fields.values())) {
                        field.accept(visitor, supplyFieldDstDescs);
                    }
                }
            }
        }

        @Override
        protected void copyFrom(ClassEntry o, boolean replace) {
            super.copyFrom(o, replace);
            if (o.fields != null) {
                for (FieldEntry oField : o.fields.values()) {
                    FieldEntry field = this.getField(oField.srcName, oField.srcDesc);
                    if (field == null) {
                        this.addField(oField);
                        continue;
                    }
                    if (oField.srcDesc != null && field.srcDesc == null) {
                        this.fields.remove(field.key);
                        field.key = oField.key;
                        field.srcDesc = oField.srcDesc;
                        this.fields.put(field.key, field);
                        this.flags = (byte)(this.flags | 1);
                    }
                    field.copyFrom(oField, replace);
                }
            }
            if (o.methods != null) {
                for (MethodEntry oMethod : o.methods.values()) {
                    MethodEntry method = this.getMethod(oMethod.srcName, oMethod.srcDesc);
                    if (method == null) {
                        this.addMethod(oMethod);
                        continue;
                    }
                    if (oMethod.srcDesc != null && method.srcDesc == null) {
                        this.methods.remove(method.key);
                        method.key = oMethod.key;
                        method.srcDesc = oMethod.srcDesc;
                        this.methods.put(method.key, method);
                        this.flags = (byte)(this.flags | 4);
                    }
                    method.copyFrom(oMethod, replace);
                }
            }
        }

        public String toString() {
            return this.srcName;
        }
    }

    static final class FieldEntry
    extends MemberEntry<FieldEntry>
    implements MappingTree.FieldMapping {
        FieldEntry(ClassEntry owner, String srcName, @Nullable String srcDesc) {
            super(owner, srcName, srcDesc);
        }

        FieldEntry(ClassEntry owner, MappingTree.FieldMapping src, int srcNsEquivalent) {
            super(owner, src, srcNsEquivalent);
        }

        @Override
        public MappedElementKind getKind() {
            return MappedElementKind.FIELD;
        }

        @Override
        public void setSrcDesc(@Nullable String desc) {
            if (Objects.equals(desc, this.srcDesc)) {
                return;
            }
            MemberKey newKey = new MemberKey(this.srcName, desc);
            if (this.owner.fields.containsKey(newKey)) {
                throw new IllegalArgumentException("conflicting name+desc after changing desc to " + desc + " for " + this);
            }
            this.owner.fields.remove(this.key);
            this.srcDesc = desc;
            this.key = newKey;
            this.owner.fields.put(newKey, this);
            if (desc != null) {
                this.owner.flags = (byte)(this.owner.flags | 1);
            } else {
                this.owner.flags = (byte)(this.owner.flags | 2);
            }
        }

        void accept(MappingVisitor visitor, boolean supplyDstDescs) throws IOException {
            if (visitor.visitField(this.srcName, this.srcDesc)) {
                this.acceptMember(visitor, supplyDstDescs);
            }
        }

        public String toString() {
            return String.format("%s;;%s", this.srcName, this.srcDesc);
        }
    }

    static final class MethodEntry
    extends MemberEntry<MethodEntry>
    implements MappingTree.MethodMapping {
        private List<MethodArgEntry> args = null;
        private List<MethodVarEntry> vars = null;

        MethodEntry(ClassEntry owner, String srcName, @Nullable String srcDesc) {
            super(owner, srcName, srcDesc);
        }

        MethodEntry(ClassEntry owner, MappingTree.MethodMapping src, int srcNsEquivalent) {
            super(owner, src, srcNsEquivalent);
            for (MappingTree.MethodArgMapping methodArgMapping : src.getArgs()) {
                this.addArg(methodArgMapping);
            }
            for (MappingTree.MethodVarMapping methodVarMapping : src.getVars()) {
                this.addVar(methodVarMapping);
            }
        }

        @Override
        public MappedElementKind getKind() {
            return MappedElementKind.METHOD;
        }

        @Override
        public void setSrcDesc(@Nullable String desc) {
            if (Objects.equals(desc, this.srcDesc)) {
                return;
            }
            MemberKey newKey = new MemberKey(this.srcName, desc);
            if (this.owner.methods.containsKey(newKey)) {
                throw new IllegalArgumentException("conflicting name+desc after changing desc to " + desc + " for " + this);
            }
            this.owner.methods.remove(this.key);
            this.srcDesc = desc;
            this.key = newKey;
            this.owner.methods.put(newKey, this);
            if (desc != null && !desc.endsWith(")")) {
                this.owner.flags = (byte)(this.owner.flags | 4);
            } else {
                this.owner.flags = (byte)(this.owner.flags | 8);
            }
        }

        public Collection<MethodArgEntry> getArgs() {
            if (this.args == null) {
                return Collections.emptyList();
            }
            return this.args;
        }

        @Nullable
        public MethodArgEntry getArg(int argPosition, int lvIndex, @Nullable String srcName) {
            if (this.args == null) {
                return null;
            }
            if (argPosition >= 0 || lvIndex >= 0) {
                for (MethodArgEntry entry : this.args) {
                    if ((argPosition < 0 || entry.argPosition != argPosition) && (lvIndex < 0 || entry.lvIndex != lvIndex) || srcName != null && entry.srcName != null && !srcName.equals(entry.srcName)) continue;
                    return entry;
                }
            }
            if (srcName != null) {
                for (MethodArgEntry entry : this.args) {
                    if (!srcName.equals(entry.srcName) || argPosition >= 0 && entry.argPosition >= 0 || lvIndex >= 0 && entry.lvIndex >= 0) continue;
                    return entry;
                }
            }
            return null;
        }

        public MethodArgEntry addArg(MappingTree.MethodArgMapping arg) {
            MethodArgEntry entry = arg instanceof MethodArgEntry && arg.getMethod() == this ? (MethodArgEntry)arg : new MethodArgEntry(this, arg, this.owner.tree.getSrcNsEquivalent(arg));
            MethodArgEntry prev = this.getArg(arg.getArgPosition(), arg.getLvIndex(), arg.getSrcName());
            if (prev == null) {
                if (this.args == null) {
                    this.args = new ArrayList<MethodArgEntry>();
                }
                this.args.add(entry);
            } else {
                this.updateArg(prev, entry, false);
            }
            return entry;
        }

        private void updateArg(MethodArgEntry existing, MethodArgEntry toAdd, boolean replace) {
            if (toAdd.argPosition >= 0 && existing.argPosition < 0) {
                existing.setArgPosition(toAdd.argPosition);
            }
            if (toAdd.lvIndex >= 0 && existing.lvIndex < 0) {
                existing.setLvIndex(toAdd.getLvIndex());
            }
            existing.copyFrom(toAdd, replace);
        }

        public Collection<MethodVarEntry> getVars() {
            if (this.vars == null) {
                return Collections.emptyList();
            }
            return this.vars;
        }

        @Nullable
        public MethodVarEntry getVar(int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName) {
            boolean hasMissing;
            if (this.vars == null) {
                return null;
            }
            if (lvtRowIndex >= 0) {
                hasMissing = false;
                for (MethodVarEntry entry : this.vars) {
                    if (entry.lvtRowIndex == lvtRowIndex) {
                        return entry;
                    }
                    if (entry.lvtRowIndex >= 0) continue;
                    hasMissing = true;
                }
                if (!hasMissing) {
                    return null;
                }
            }
            if (lvIndex >= 0) {
                hasMissing = false;
                MethodVarEntry bestMatch = null;
                for (MethodVarEntry entry : this.vars) {
                    if (lvtRowIndex >= 0 && entry.lvtRowIndex >= 0 && lvtRowIndex != entry.lvtRowIndex || srcName != null && entry.srcName != null && !srcName.equals(entry.srcName)) continue;
                    if (entry.lvIndex != lvIndex) {
                        if (entry.lvIndex >= 0) continue;
                        hasMissing = true;
                        continue;
                    }
                    if (startOpIdx >= 0 && endOpIdx >= 0 && entry.startOpIdx >= 0 && entry.endOpIdx >= 0) {
                        if (startOpIdx >= entry.endOpIdx || endOpIdx <= entry.startOpIdx) continue;
                        return entry;
                    }
                    if (endOpIdx >= 0 && entry.startOpIdx >= 0 && endOpIdx <= entry.startOpIdx || entry.endOpIdx >= 0 && startOpIdx >= 0 && entry.endOpIdx <= startOpIdx) continue;
                    if (startOpIdx < 0 || startOpIdx == entry.startOpIdx) {
                        return entry;
                    }
                    if (bestMatch != null && (entry.startOpIdx < 0 || Math.abs(entry.startOpIdx - startOpIdx) >= Math.abs(bestMatch.startOpIdx - startOpIdx))) continue;
                    bestMatch = entry;
                }
                if (!hasMissing || bestMatch != null) {
                    return bestMatch;
                }
            }
            if (srcName != null) {
                for (MethodVarEntry entry : this.vars) {
                    if (!srcName.equals(entry.srcName) || lvtRowIndex >= 0 && entry.lvtRowIndex >= 0 || lvIndex >= 0 && entry.lvIndex >= 0) continue;
                    return entry;
                }
            }
            return null;
        }

        public MethodVarEntry addVar(MappingTree.MethodVarMapping var) {
            MethodVarEntry entry = var instanceof MethodVarEntry && var.getMethod() == this ? (MethodVarEntry)var : new MethodVarEntry(this, var, this.owner.tree.getSrcNsEquivalent(var));
            MethodVarEntry prev = this.getVar(var.getLvtRowIndex(), var.getLvIndex(), var.getStartOpIdx(), var.getEndOpIdx(), var.getSrcName());
            if (prev == null) {
                if (this.vars == null) {
                    this.vars = new ArrayList<MethodVarEntry>();
                }
                this.vars.add(entry);
            } else {
                this.updateVar(prev, entry, false);
            }
            return entry;
        }

        private void updateVar(MethodVarEntry existing, MethodVarEntry toAdd, boolean replace) {
            if (toAdd.lvtRowIndex >= 0 && existing.lvtRowIndex < 0) {
                existing.setLvtRowIndex(toAdd.lvtRowIndex);
            }
            if (toAdd.lvIndex >= 0 && toAdd.startOpIdx >= 0 && (existing.lvIndex < 0 || existing.startOpIdx < 0)) {
                existing.setLvIndex(toAdd.lvIndex, toAdd.startOpIdx, toAdd.endOpIdx);
            }
            existing.copyFrom(toAdd, replace);
        }

        void accept(MappingVisitor visitor, VisitOrder order, boolean supplyDstDescs) throws IOException {
            if (visitor.visitMethod(this.srcName, this.srcDesc) && this.acceptMember(visitor, supplyDstDescs)) {
                boolean varsFirst;
                boolean bl = varsFirst = order.isMethodVarsFirst() && this.args != null && this.vars != null;
                if (!varsFirst && this.args != null) {
                    for (MethodArgEntry arg : order.sortMethodArgs(this.args)) {
                        arg.accept(visitor);
                    }
                }
                if (this.vars != null) {
                    for (MethodVarEntry var : order.sortMethodVars(this.vars)) {
                        var.accept(visitor);
                    }
                }
                if (varsFirst) {
                    for (MethodArgEntry arg : order.sortMethodArgs(this.args)) {
                        arg.accept(visitor);
                    }
                }
            }
        }

        @Override
        protected void copyFrom(MethodEntry o, boolean replace) {
            super.copyFrom(o, replace);
            if (o.args != null) {
                for (MethodArgEntry oArg : o.args) {
                    MethodArgEntry arg = this.getArg(oArg.argPosition, oArg.lvIndex, oArg.srcName);
                    if (arg == null) {
                        this.addArg(oArg);
                        continue;
                    }
                    this.updateArg(arg, oArg, replace);
                }
            }
            if (o.vars != null) {
                for (MethodVarEntry oVar : o.vars) {
                    MethodVarEntry var = this.getVar(oVar.lvtRowIndex, oVar.lvIndex, oVar.startOpIdx, oVar.endOpIdx, oVar.srcName);
                    if (var == null) {
                        this.addVar(oVar);
                        continue;
                    }
                    this.updateVar(var, oVar, replace);
                }
            }
        }

        public String toString() {
            return String.format("%s%s", this.srcName, this.srcDesc);
        }
    }

    static final class MethodArgEntry
    extends Entry<MethodArgEntry>
    implements MappingTree.MethodArgMapping {
        private final MethodEntry method;
        private int argPosition;
        private int lvIndex;

        MethodArgEntry(MethodEntry method, int argPosition, int lvIndex, @Nullable String srcName) {
            super(method.owner.tree, srcName);
            this.method = method;
            this.argPosition = argPosition;
            this.lvIndex = lvIndex;
        }

        MethodArgEntry(MethodEntry method, MappingTree.MethodArgMapping src, int srcNsEquivalent) {
            super(method.owner.tree, src, srcNsEquivalent);
            this.method = method;
            this.argPosition = src.getArgPosition();
            this.lvIndex = src.getLvIndex();
        }

        @Override
        public MappingTree getTree() {
            return this.method.owner.tree;
        }

        @Override
        public MappedElementKind getKind() {
            return MappedElementKind.METHOD_ARG;
        }

        @Override
        public MethodEntry getMethod() {
            return this.method;
        }

        @Override
        public int getArgPosition() {
            return this.argPosition;
        }

        public void setArgPosition(int position) {
            this.argPosition = position;
        }

        @Override
        public int getLvIndex() {
            return this.lvIndex;
        }

        public void setLvIndex(int index) {
            this.lvIndex = index;
        }

        public void setSrcName(@Nullable String name) {
            this.srcName = name;
        }

        void accept(MappingVisitor visitor) throws IOException {
            if (visitor.visitMethodArg(this.argPosition, this.lvIndex, this.srcName)) {
                this.acceptElement(visitor, null);
            }
        }

        @Override
        protected void copyFrom(MethodArgEntry o, boolean replace) {
            super.copyFrom(o, replace);
            if (o.srcName != null && (replace || this.srcName == null)) {
                this.srcName = o.srcName;
            }
        }

        public String toString() {
            return String.format("%d/%d:%s", this.argPosition, this.lvIndex, this.srcName);
        }
    }

    static final class MethodVarEntry
    extends Entry<MethodVarEntry>
    implements MappingTree.MethodVarMapping {
        private final MethodEntry method;
        private int lvtRowIndex;
        private int lvIndex;
        private int startOpIdx;
        private int endOpIdx;

        MethodVarEntry(MethodEntry method, int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName) {
            super(method.owner.tree, srcName);
            this.method = method;
            this.lvtRowIndex = lvtRowIndex;
            this.lvIndex = lvIndex;
            this.startOpIdx = startOpIdx;
            this.endOpIdx = endOpIdx;
        }

        MethodVarEntry(MethodEntry method, MappingTree.MethodVarMapping src, int srcNs) {
            super(method.owner.tree, src, srcNs);
            this.method = method;
            this.lvtRowIndex = src.getLvtRowIndex();
            this.lvIndex = src.getLvIndex();
            this.startOpIdx = src.getStartOpIdx();
            this.endOpIdx = src.getEndOpIdx();
        }

        @Override
        public MappingTree getTree() {
            return this.method.owner.tree;
        }

        @Override
        public MappedElementKind getKind() {
            return MappedElementKind.METHOD_VAR;
        }

        @Override
        public MethodEntry getMethod() {
            return this.method;
        }

        @Override
        public int getLvtRowIndex() {
            return this.lvtRowIndex;
        }

        public void setLvtRowIndex(int index) {
            this.lvtRowIndex = index;
        }

        @Override
        public int getLvIndex() {
            return this.lvIndex;
        }

        @Override
        public int getStartOpIdx() {
            return this.startOpIdx;
        }

        @Override
        public int getEndOpIdx() {
            return this.endOpIdx;
        }

        public void setLvIndex(int lvIndex, int startOpIdx, int endOpIdx) {
            this.lvIndex = lvIndex;
            this.startOpIdx = startOpIdx;
            this.endOpIdx = endOpIdx;
        }

        public void setSrcName(@Nullable String name) {
            this.srcName = name;
        }

        void accept(MappingVisitor visitor) throws IOException {
            if (visitor.visitMethodVar(this.lvtRowIndex, this.lvIndex, this.startOpIdx, this.endOpIdx, this.srcName)) {
                this.acceptElement(visitor, null);
            }
        }

        @Override
        protected void copyFrom(MethodVarEntry o, boolean replace) {
            super.copyFrom(o, replace);
            if (o.srcName != null && (replace || this.srcName == null)) {
                this.srcName = o.srcName;
            }
        }

        public String toString() {
            return String.format("%d/%d@%d-%d:%s", this.lvtRowIndex, this.lvIndex, this.startOpIdx, this.endOpIdx, this.srcName);
        }
    }

    static abstract class Entry<T extends Entry<T>>
    implements MappingTree.ElementMapping {
        protected String srcName;
        protected String[] dstNames;
        protected String comment;

        protected Entry(MemoryMappingTree tree, String srcName) {
            this.srcName = srcName;
            this.dstNames = new String[tree.dstNamespaces.size()];
        }

        protected Entry(MemoryMappingTree tree, MappingTree.ElementMapping src, int srcNsEquivalent) {
            this(tree, src.getName(srcNsEquivalent));
            for (int i = 0; i < this.dstNames.length; ++i) {
                int dstNsEquivalent = src.getTree().getNamespaceId((String)tree.dstNamespaces.get(i));
                if (dstNsEquivalent == -2) continue;
                this.setDstName(src.getDstName(dstNsEquivalent), i);
            }
            this.setComment(src.getComment());
        }

        public abstract MappedElementKind getKind();

        @Override
        public final String getSrcName() {
            return this.srcName;
        }

        @Override
        @Nullable
        public final String getDstName(int namespace) {
            return this.dstNames[namespace];
        }

        @Override
        public void setDstName(String name, int namespace) {
            this.dstNames[namespace] = name;
        }

        void resizeDstNames(int newSize) {
            this.dstNames = Arrays.copyOf(this.dstNames, newSize);
        }

        @Override
        @Nullable
        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        protected final boolean acceptElement(MappingVisitor visitor, @Nullable String[] dstDescs) throws IOException {
            int i;
            MappedElementKind kind = this.getKind();
            for (i = 0; i < this.dstNames.length; ++i) {
                String dstName = this.dstNames[i];
                if (dstName == null) continue;
                visitor.visitDstName(kind, i, dstName);
            }
            if (dstDescs != null) {
                for (i = 0; i < dstDescs.length; ++i) {
                    String dstDesc = dstDescs[i];
                    if (dstDesc == null) continue;
                    visitor.visitDstDesc(kind, i, dstDesc);
                }
            }
            if (!visitor.visitElementContent(kind)) {
                return false;
            }
            if (this.comment != null) {
                visitor.visitComment(kind, this.comment);
            }
            return true;
        }

        protected void copyFrom(T o, boolean replace) {
            for (int i = 0; i < this.dstNames.length; ++i) {
                if (((Entry)o).dstNames[i] == null || !replace && this.dstNames[i] != null) continue;
                this.dstNames[i] = ((Entry)o).dstNames[i];
            }
            if (((Entry)o).comment != null && (replace || this.comment == null)) {
                this.comment = ((Entry)o).comment;
            }
        }
    }

    static final class MetadataEntryImpl
    implements MappingTree.MetadataEntry {
        final String key;
        final String value;

        MetadataEntryImpl(String key, @Nullable String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof MetadataEntryImpl)) {
                return false;
            }
            MetadataEntryImpl entry = (MetadataEntryImpl)other;
            return this.key.equals(entry.key) && this.value.equals(entry.value);
        }

        public int hashCode() {
            return this.key.hashCode() | this.value.hashCode();
        }

        public String toString() {
            return this.key + ":" + this.value;
        }
    }

    static abstract class MemberEntry<T extends MemberEntry<T>>
    extends Entry<T>
    implements MappingTree.MemberMapping {
        protected final ClassEntry owner;
        protected String srcDesc;
        MemberKey key;

        protected MemberEntry(ClassEntry owner, String srcName, @Nullable String srcDesc) {
            super(owner.tree, srcName);
            this.owner = owner;
            this.srcDesc = srcDesc;
            this.key = new MemberKey(srcName, srcDesc);
        }

        protected MemberEntry(ClassEntry owner, MappingTree.MemberMapping src, int srcNsEquivalent) {
            super(owner.tree, src, srcNsEquivalent);
            this.owner = owner;
            this.srcDesc = src.getDesc(srcNsEquivalent);
            this.key = new MemberKey(this.srcName, this.srcDesc);
        }

        @Override
        public MappingTree getTree() {
            return this.owner.tree;
        }

        @Override
        public final ClassEntry getOwner() {
            return this.owner;
        }

        @Override
        @Nullable
        public final String getSrcDesc() {
            return this.srcDesc;
        }

        protected final boolean acceptMember(MappingVisitor visitor, boolean supplyDstDescs) throws IOException {
            String[] dstDescs;
            if (!supplyDstDescs || this.srcDesc == null) {
                dstDescs = null;
            } else {
                MemoryMappingTree tree = this.owner.tree;
                dstDescs = new String[tree.getDstNamespaces().size()];
                for (int i = 0; i < dstDescs.length; ++i) {
                    dstDescs[i] = tree.mapDesc(this.srcDesc, i);
                }
            }
            return this.acceptElement(visitor, dstDescs);
        }
    }

    static final class GlobalMemberKey {
        private final ClassEntry owner;
        private final String name;
        private final String desc;
        private final boolean isField;

        GlobalMemberKey(ClassEntry owner, String name, @Nullable String desc, boolean isField) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
            this.isField = isField;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != GlobalMemberKey.class) {
                return false;
            }
            GlobalMemberKey o = (GlobalMemberKey)obj;
            return this.owner == o.owner && this.name.equals(o.name) && Objects.equals(this.desc, o.desc) && this.isField == o.isField;
        }

        public int hashCode() {
            int ret = this.owner.hashCode() * 31 + this.name.hashCode();
            if (this.desc != null) {
                ret |= this.desc.hashCode();
            }
            if (this.isField) {
                ++ret;
            }
            return ret;
        }

        public String toString() {
            return String.format("%s.%s.%s", this.owner, this.name, this.desc);
        }
    }

    static final class MemberKey {
        private final String name;
        private final String desc;
        private final int hash;

        MemberKey(String name, @Nullable String desc) {
            this.name = name;
            this.desc = desc;
            this.hash = desc == null ? name.hashCode() : name.hashCode() * 257 + desc.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != MemberKey.class) {
                return false;
            }
            MemberKey o = (MemberKey)obj;
            return this.name.equals(o.name) && Objects.equals(this.desc, o.desc);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return String.format("%s.%s", this.name, this.desc);
        }
    }
}

