/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import io.github.prospector.modmenu.gui.EntryListWidget;
import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModListScreen;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.RenderUtils;
import java.util.Collection;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Font;
import net.minecraft.core.lang.I18n;

public class DescriptionListWidget
extends EntryListWidget<DescriptionEntry> {
    private final ModListScreen parent;
    private final Font textRenderer;
    private ModListEntry lastSelected = null;

    public DescriptionListWidget(Minecraft client, int width, int height, int top, int bottom, int entryHeight, ModListScreen parent) {
        super(client, width, height, top, bottom, entryHeight);
        this.parent = parent;
        this.textRenderer = client.font;
    }

    @Override
    public DescriptionEntry getSelected() {
        return null;
    }

    @Override
    public int getRowWidth() {
        return this.width - 10;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.width - 6 + this.left;
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        I18n i18n = I18n.getInstance();
        ModListEntry selectedEntry = this.parent.getSelectedEntry();
        if (selectedEntry != this.lastSelected) {
            this.lastSelected = selectedEntry;
            this.clearEntries();
            this.setScrollAmount(-1.7976931348623157E308);
            String description = this.lastSelected.getMetadata().getDescription();
            String id = this.lastSelected.getMetadata().getId();
            Collection authors = this.lastSelected.getMetadata().getAuthors();
            Collection contributors = this.lastSelected.getMetadata().getContributors();
            Collection licenses = this.lastSelected.getMetadata().getLicense();
            if (description.isEmpty() && HardcodedUtil.getHardcodedDescriptions().containsKey(id)) {
                description = HardcodedUtil.getHardcodedDescription(id);
            }
            if (this.lastSelected != null && description != null && !description.isEmpty()) {
                for (String line : RenderUtils.INSTANCE.wrapStringToWidthAsList(this.textRenderer, description.replaceAll("\n", "\n\n"), this.getRowWidth())) {
                    this.children().add(new DescriptionEntry(line));
                }
            }
            if (!authors.isEmpty()) {
                if (!this.children().isEmpty()) {
                    this.children().add(new DescriptionEntry(""));
                }
                this.children().add(new DescriptionEntry(i18n.translateKey("modmenu.authors")));
                for (Person person : authors) {
                    this.children().add(new DescriptionEntry("    " + person.getName()));
                }
            }
            if (!contributors.isEmpty()) {
                if (!this.children().isEmpty()) {
                    this.children().add(new DescriptionEntry(""));
                }
                this.children().add(new DescriptionEntry(i18n.translateKey("modmenu.contributors")));
                for (Person person : contributors) {
                    this.children().add(new DescriptionEntry("    " + person.getName()));
                }
            }
            if (!licenses.isEmpty()) {
                if (!this.children().isEmpty()) {
                    this.children().add(new DescriptionEntry(""));
                }
                this.children().add(new DescriptionEntry(i18n.translateKey("modmenu.licenses")));
                for (String license : licenses) {
                    this.children().add(new DescriptionEntry("    " + license));
                }
            }
        }
        super.render(mouseX, mouseY, delta);
    }

    @Override
    protected void renderHoleBackground(int y1, int y2, int startAlpha, int endAlpha) {
        this.parent.overlayBackground(this.left, y1, this.right, y2, 64, 64, 64, startAlpha, endAlpha);
    }

    protected class DescriptionEntry
    extends EntryListWidget.Entry<DescriptionEntry> {
        protected String text;

        public DescriptionEntry(String text) {
            this.text = text;
        }

        @Override
        public void render(int index, int y, int x, int itemWidth, int itemHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            DescriptionListWidget.this.textRenderer.drawStringWithShadow(this.text, x, y, 0xAAAAAA);
        }
    }
}

