/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import net.minecraft.client.render.window.GameWindow;

public class ScaledResolution {
    private final GameWindow gameWindow;
    private int scaledWidth;
    private int scaledHeight;
    private double scaledWidthExact;
    private double scaledHeightExact;
    private int scale = 1;

    public ScaledResolution(GameWindow gameWindow) {
        this.gameWindow = gameWindow;
    }

    public int getScale() {
        return this.scale;
    }

    public int getWidthScreenCoords() {
        return this.gameWindow.getWidthScreenCoords();
    }

    public int getHeightScreenCoords() {
        return this.gameWindow.getHeightScreenCoords();
    }

    public int getScaledWidthScreenCoords() {
        return this.scaledWidth;
    }

    public int getScaledHeightScreenCoords() {
        return this.scaledHeight;
    }

    public double getExactScaledWidthScreenCoords() {
        return this.scaledWidthExact;
    }

    public double getExactScaledHeightScreenCoords() {
        return this.scaledHeightExact;
    }

    public void setScale(int scale) {
        int width = this.getWidthScreenCoords();
        int height = this.getHeightScreenCoords();
        int maxScale = ScaledResolution.getMaxScale(width, height);
        scale = scale == 0 ? maxScale : Math.min(maxScale, scale);
        double dscale = scale;
        this.scaledWidthExact = (double)width / dscale;
        this.scaledHeightExact = (double)height / dscale;
        this.scaledWidth = (int)Math.ceil(this.scaledWidthExact);
        this.scaledHeight = (int)Math.ceil(this.scaledHeightExact);
        this.scaledWidth = Math.max(this.scaledWidth, 1);
        this.scaledHeight = Math.max(this.scaledHeight, 1);
        this.scale = scale;
    }

    public static int getMaxScale(int width, int height) {
        return Math.max(Math.min(width / 320, height / 240), 1);
    }
}

