/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.world.World;

public class ParticleLava
extends Particle {
    private final float oSize;

    public ParticleLava(World world, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= 0.8;
        this.yd *= 0.8;
        this.zd *= 0.8;
        this.yd = this.random.nextFloat() * 0.4f + 0.05f;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.size *= this.random.nextFloat() * 2.0f + 0.2f;
        this.oSize = this.size;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.noPhysics = false;
        this.tex = TextureRegistry.getTexture("minecraft:particle/bubble_lava");
    }

    @Override
    public float getBrightness(float partialTick) {
        return 1.0f;
    }

    @Override
    public void render(Tessellator t, float partialTick, double xOff, double yOff, double zOff, float xa, float ya, float za, float xa2, float za2) {
        float l = ((float)this.age + partialTick) / (float)this.lifetime;
        this.size = this.oSize * (1.0f - l * l);
        super.render(t, partialTick, xOff, yOff, zOff, xa, ya, za, xa2, za2);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        float odds = (float)this.age / (float)this.lifetime;
        if (this.random.nextFloat() > odds) {
            this.world.spawnParticle("smoke", this.x, this.y, this.z, this.xd, this.yd, this.zd, 0);
        }
        this.yd -= 0.03;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.999;
        this.yd *= 0.999;
        this.zd *= 0.999;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

