/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.achievements.pages;

import java.util.Objects;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.achievements.ScreenAchievements;
import net.minecraft.client.gui.achievements.data.AchievementPage;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AchievementPageOverworld
extends AchievementPage {
    protected final Minecraft mc = Minecraft.getMinecraft();
    protected final ItemStack icon;
    @NotNull
    protected final String key;
    protected static final int ORE_COAL = 0;
    protected static final int ORE_IRON = 1;
    protected static final int ORE_GOLD = 2;
    protected static final int ORE_DIAMOND = 3;
    protected static final int ORE_REDSTONE = 4;
    protected static final int ORE_LAPIS = 5;
    protected static final Block<?>[] STONE_ORES = new Block[]{Blocks.ORE_COAL_STONE, Blocks.ORE_IRON_STONE, Blocks.ORE_GOLD_STONE, Blocks.ORE_DIAMOND_STONE, Blocks.ORE_REDSTONE_STONE, Blocks.ORE_LAPIS_STONE};
    protected static final Block<?>[] GRANITE_ORES = new Block[]{Blocks.ORE_COAL_GRANITE, Blocks.ORE_IRON_GRANITE, Blocks.ORE_GOLD_GRANITE, Blocks.ORE_DIAMOND_GRANITE, Blocks.ORE_REDSTONE_GRANITE, Blocks.ORE_LAPIS_GRANITE};
    protected static final Block<?>[] LIMESTONE_ORES = new Block[]{Blocks.ORE_COAL_LIMESTONE, Blocks.ORE_IRON_LIMESTONE, Blocks.ORE_GOLD_LIMESTONE, Blocks.ORE_DIAMOND_LIMESTONE, Blocks.ORE_REDSTONE_LIMESTONE, Blocks.ORE_LAPIS_LIMESTONE};
    protected static final Block<?>[] BASALT_ORES = new Block[]{Blocks.ORE_COAL_BASALT, Blocks.ORE_IRON_BASALT, Blocks.ORE_GOLD_BASALT, Blocks.ORE_DIAMOND_BASALT, Blocks.ORE_REDSTONE_BASALT, Blocks.ORE_LAPIS_BASALT};
    private static final WeightedRandomBag<Integer> oreBag = new WeightedRandomBag();
    private static final IconCoordinate chest = TextureRegistry.getTexture("minecraft:block/chest/planks/front");
    private static final IconCoordinate spawner = AchievementPageOverworld.getTextureFromBlock(Blocks.MOBSPAWNER);
    protected static PageStructure dungeonBrick = new PageStructure(new Object[][][]{{{Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY}, {Blocks.BRICK_CLAY, null, null, null, null, null, Blocks.BRICK_CLAY}, {Blocks.BRICK_CLAY, null, null, null, null, null, Blocks.BRICK_CLAY}, {Blocks.BRICK_CLAY, null, null, Blocks.MOBSPAWNER, null, chest, Blocks.BRICK_CLAY}, {Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY}}, {{Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY}, {Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY}, {Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY}, {Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY}, {Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY, Blocks.BRICK_CLAY}}});
    protected static PageStructure dungeonCobble = new PageStructure(new Object[][][]{{{Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE}, {Blocks.COBBLE_STONE, null, null, null, null, null, Blocks.COBBLE_STONE_MOSSY}, {Blocks.COBBLE_STONE_MOSSY, null, null, null, null, null, Blocks.COBBLE_STONE}, {Blocks.COBBLE_STONE, chest, null, Blocks.MOBSPAWNER, null, null, Blocks.COBBLE_STONE_MOSSY}, {Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE}}, {{Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE}, {Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE}, {Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE}, {Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE_MOSSY, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE}, {Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE}}});

    public AchievementPageOverworld(String key, ItemStack icon) {
        this.key = key;
        this.icon = icon;
    }

    @Override
    @NotNull
    public String getName() {
        return I18n.getInstance().translateNameKey(this.key);
    }

    @Override
    @NotNull
    public String getDescription() {
        return I18n.getInstance().translateDescKey(this.key);
    }

    @Override
    @NotNull
    public AchievementPage.AchievementEntry onOpenAchievement() {
        return Objects.requireNonNull(this.getEntry(Achievements.BUILD_WORKBENCH));
    }

    @Override
    public IconCoordinate getBackgroundTile(ScreenAchievements screen, int layer, Random random, int tileX, int tileY) {
        random.setSeed(random.nextLong() + (long)this.key.hashCode());
        int sandLayer = -20;
        int dirtLayer = 2;
        int bedrockLayer = 35;
        int stoneLayer = 19;
        int basaltLayer = 27;
        int graniteColumn = 5;
        int limestoneColumn = 50;
        int offsetX = tileX + random.nextInt(3) - random.nextInt(3);
        int offsetY = tileY + random.nextInt(3) - random.nextInt(3);
        if (offsetY <= -20) {
            return AchievementPageOverworld.getTextureFromBlock(Blocks.SAND);
        }
        if (offsetY <= 2) {
            return AchievementPageOverworld.getTextureFromBlock(Blocks.DIRT);
        }
        if (offsetY >= 35) {
            return AchievementPageOverworld.getTextureFromBlock(Blocks.BEDROCK);
        }
        if (offsetY >= 27) {
            return this.getOreFromStone(Blocks.BASALT, random, tileX, tileY);
        }
        if (offsetY >= 19) {
            return this.getOreFromStone(Blocks.STONE, random, tileX, tileY);
        }
        if (offsetX <= 5) {
            return this.getOreFromStone(Blocks.GRANITE, random, tileX, tileY);
        }
        if (offsetX >= 50) {
            return this.getOreFromStone(Blocks.LIMESTONE, random, tileX, tileY);
        }
        return this.getOreFromStone(Blocks.STONE, random, tileX, tileY);
    }

    @Override
    public void postProcessBackground(ScreenAchievements screen, Random random, ScreenAchievements.BGLayer layer, int orgX, int orgY) {
        random.setSeed(random.nextLong() + (long)this.key.hashCode());
        if (layer.id == 0) {
            int _x;
            int y = 5;
            int delta = 0;
            int tYMin = -2;
            int tYMax = -6;
            int lowestY = 0;
            for (int _x2 = -100; _x2 < 100; ++_x2) {
                delta += random.nextInt(2) - random.nextInt(2);
                delta = MathHelper.clamp(delta, -3, 3);
                int sign = (int)Math.signum(delta);
                int _d = Math.abs(delta);
                if (_d != 0) {
                    y += sign * random.nextInt(_d);
                }
                if (y > tYMax) {
                    --delta;
                }
                if (y < tYMin) {
                    ++delta;
                }
                if (y > lowestY) {
                    y = lowestY;
                }
                int rY = y;
                while (rY - orgY >= 0) {
                    if (rY == y) {
                        layer.put(TextureRegistry.getTexture("minecraft:block/grass/side"), _x2 - orgX, rY - orgY);
                    } else {
                        layer.put(null, _x2 - orgX, rY - orgY);
                    }
                    screen.getLayer(1).put(null, _x2 - orgX, rY - orgY);
                    --rY;
                }
            }
            int[] brickPos = null;
            Object cobblePos = null;
            int lastY = 0;
            int cave = -1;
            for (_x = -100; _x <= 100; ++_x) {
                if (random.nextInt(20) == 0 && cave <= 0) {
                    cave = 20 + random.nextInt(5) - random.nextInt(5);
                }
                if (cave > 0) {
                    lastY = 25 + random.nextInt(4) - random.nextInt(4);
                    this.carveCircle(screen, layer, _x - orgX, lastY - orgY, 2 + random.nextInt(3));
                }
                if (cave == 0 && -10 <= _x && _x <= 40) {
                    brickPos = new int[]{_x, lastY};
                }
                --cave;
            }
            cave = -1;
            for (_x = -100; _x <= 100; ++_x) {
                if (random.nextInt(10) == 0 && cave <= 0) {
                    cave = 5 + random.nextInt(5) - random.nextInt(5);
                }
                if (cave > 0) {
                    this.carveCircle(screen, layer, _x - orgX, 10 + random.nextInt(2) - random.nextInt(2) - orgY, random.nextInt(3));
                }
                --cave;
            }
            if (brickPos == null) {
                brickPos = new int[]{5 + random.nextInt(20) + random.nextInt(20), 15 + random.nextInt(10)};
            }
            this.placeStructure(screen, dungeonBrick, (int)(brickPos[0] - orgX), (int)(brickPos[1] - orgY), (struct, cache) -> {
                if (cache == null) {
                    if (struct == chest || struct == spawner) {
                        return struct;
                    }
                    return null;
                }
                return struct;
            });
            this.placeStructure(screen, dungeonCobble, -orgX + 5 + random.nextInt(20) + random.nextInt(20), -orgY + 5 + random.nextInt(5), (struct, cache) -> {
                if (cache == null) {
                    if (struct == chest || struct == spawner) {
                        return struct;
                    }
                    return null;
                }
                return struct;
            });
        } else if (layer.id == 1) {
            IconCoordinate[] foreground = screen.getLayer(0).getData();
            IconCoordinate[] background = layer.getData();
            for (int i = 0; i < background.length; ++i) {
                if (foreground[i] == null || foreground[i] == spawner) continue;
                background[i] = null;
            }
        }
    }

    protected void carveCircle(ScreenAchievements screen, ScreenAchievements.BGLayer layer, int centerX, int centerY, int radius) {
        for (int i = centerX - radius; i <= centerX + radius; ++i) {
            for (int j = centerY - radius; j < centerY + radius; ++j) {
                double diffX = (double)i + 0.5 - (double)centerX;
                double diffY = (double)j + 0.5 - (double)centerY;
                if (!(diffX * diffX + diffY * diffY < (double)(radius * radius))) continue;
                layer.put(null, i, j);
            }
        }
    }

    protected void placeStructure(ScreenAchievements screen, PageStructure structure, int tileX, int tileY, @Nullable BiFunction<IconCoordinate, IconCoordinate, IconCoordinate> coordinateProcessor) {
        if (coordinateProcessor == null) {
            coordinateProcessor = (i, i2) -> i;
        }
        for (int layer = 0; layer < structure.layers; ++layer) {
            ScreenAchievements.BGLayer cache = screen.getLayer(layer);
            if (cache == null) continue;
            for (int _x = 0; _x < structure.width; ++_x) {
                for (int _y = 0; _y < structure.height; ++_y) {
                    IconCoordinate coordinate = structure.getIcon(_x, _y, layer);
                    cache.put(coordinateProcessor.apply(coordinate, cache.get(tileX + _x, tileY + _y)), tileX + _x, tileY + _y);
                }
            }
        }
    }

    private IconCoordinate getOreFromStone(Block<?> stoneBlock, Random random, int tileX, int tileY) {
        int oreIndex;
        oreBag.clear();
        random.setSeed(random.nextLong());
        int coalStart = 2;
        int coalEnd = 20;
        int ironStart = 2;
        int ironEnd = 25;
        int goldStart = 20;
        int goldEnd = 35;
        int diamondStart = 25;
        int diamondEnd = 35;
        int lapisStart = 25;
        int lapisEnd = 35;
        int redstoneStart = 20;
        int redstoneEnd = 35;
        oreBag.addEntry(-1, 300.0);
        if (tileY >= 2 && tileY <= 20) {
            oreBag.addEntry(0, 15.0);
        }
        if (tileY >= 2 && tileY <= 25) {
            oreBag.addEntry(1, 15.0);
        }
        if (tileY >= 20 && tileY <= 35) {
            oreBag.addEntry(2, 3.0);
        }
        if (tileY >= 25 && tileY <= 35) {
            oreBag.addEntry(3, 1.0);
        }
        if (tileY >= 25 && tileY <= 35) {
            oreBag.addEntry(5, 2.0);
        }
        if (tileY >= 20 && tileY <= 35) {
            oreBag.addEntry(4, 5.0);
        }
        if ((oreIndex = oreBag.getRandom(random).intValue()) >= 0) {
            if (stoneBlock == Blocks.STONE) {
                return AchievementPageOverworld.getTextureFromBlock(STONE_ORES[oreIndex]);
            }
            if (stoneBlock == Blocks.BASALT) {
                return AchievementPageOverworld.getTextureFromBlock(BASALT_ORES[oreIndex]);
            }
            if (stoneBlock == Blocks.GRANITE) {
                return AchievementPageOverworld.getTextureFromBlock(GRANITE_ORES[oreIndex]);
            }
            if (stoneBlock == Blocks.LIMESTONE) {
                return AchievementPageOverworld.getTextureFromBlock(LIMESTONE_ORES[oreIndex]);
            }
        }
        return AchievementPageOverworld.getTextureFromBlock(stoneBlock);
    }

    @Override
    @NotNull
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public int backgroundLayers() {
        return 2;
    }

    @Override
    public int backgroundColor() {
        return 7780095;
    }

    @Override
    public IconCoordinate getAchievementIcon(Achievement achievement) {
        return TextureRegistry.getTexture(achievement.getType().texture);
    }

    @Override
    public int lineColorLocked(boolean isHovered) {
        return 0;
    }

    @Override
    public int lineColorUnlocked(boolean isHovered) {
        return 0x707070;
    }

    @Override
    public int lineColorCanUnlock(boolean isHovered) {
        return 65280;
    }

    public static class PageStructure {
        private final IconCoordinate[] data;
        public final int width;
        public final int height;
        public final int layers;

        public PageStructure(Object[][][] structure) {
            this.layers = structure.length;
            this.width = structure[0][0].length;
            this.height = structure[0].length;
            this.data = new IconCoordinate[this.width * this.height * this.layers];
            for (int l = 0; l < this.layers; ++l) {
                for (int x = 0; x < this.width; ++x) {
                    for (int y = 0; y < this.height; ++y) {
                        Object o = structure[l][y][x];
                        IconCoordinate c = null;
                        if (o instanceof Block) {
                            c = AchievementPage.getTextureFromBlock((Block)o);
                        } else if (o instanceof IconCoordinate) {
                            c = (IconCoordinate)o;
                        }
                        this.data[this.makeIndex((int)x, (int)y, (int)l)] = c;
                    }
                }
            }
        }

        public PageStructure(int width, int height, int layers) {
            this.width = width;
            this.height = height;
            this.layers = layers;
            this.data = new IconCoordinate[width * height * layers];
        }

        public PageStructure setIcon(IconCoordinate icon, int x, int y, int layer) {
            if (x < 0 || x >= this.width || y < 0 || y >= this.height || layer < 0 || layer >= this.layers) {
                return this;
            }
            this.data[this.makeIndex((int)x, (int)y, (int)layer)] = icon;
            return this;
        }

        public IconCoordinate getIcon(int x, int y, int layer) {
            if (x < 0 || x >= this.width || y < 0 || y >= this.height || layer < 0 || layer >= this.layers) {
                return null;
            }
            return this.data[this.makeIndex(x, y, layer)];
        }

        private int makeIndex(int x, int y, int layer) {
            return x % this.width + y * this.width + layer * (this.width * this.height);
        }
    }
}

