/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.crafting;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.SearchableGuidebookSection;
import net.minecraft.client.gui.guidebook.crafting.RecipePageCrafting;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.Pair;
import net.minecraft.core.util.helper.MathHelper;

public class GuidebookSectionCrafting
extends SearchableGuidebookSection {
    private final List<GuidebookPage> pages = new ArrayList<GuidebookPage>();
    private Pair<String, List<GuidebookPage>> filteredPages = null;

    public GuidebookSectionCrafting() {
        super("guidebook.section.crafting", new ItemStack(Blocks.WORKBENCH), 11035445, 10823970);
        this.reloadRecipes();
    }

    public void reloadRecipes() {
        this.pages.clear();
        ArrayList allRecipes = new ArrayList(Registries.RECIPES.getAllCraftingRecipes());
        allRecipes.removeIf(R -> !RecipePageCrafting.guidebookSupportsRecipe(R));
        int totalRecipes = allRecipes.size();
        int totalPages = MathHelper.ceilInt(totalRecipes, 3);
        for (int i = 0; i < totalPages; ++i) {
            int j = i * 3;
            ArrayList recipes = new ArrayList(allRecipes.subList(Math.min(j, totalRecipes), Math.min(j + 3, totalRecipes)));
            this.pages.add(new RecipePageCrafting(this, recipes));
        }
    }

    @Override
    public List<GuidebookPage> getPages() {
        return this.pages;
    }

    @Override
    public List<GuidebookSection.Index> getIndices() {
        return null;
    }

    @Override
    public List<GuidebookPage> searchPages(SearchQuery query) {
        if (this.filteredPages == null || !Objects.equals(this.filteredPages.getLeft(), query.rawQuery)) {
            ArrayList<RecipeEntryCrafting> filteredRecipes = new ArrayList<RecipeEntryCrafting>();
            ArrayList allRecipes = new ArrayList(Registries.RECIPES.getAllCraftingRecipes());
            allRecipes.removeIf(R -> !RecipePageCrafting.guidebookSupportsRecipe(R));
            for (RecipeEntryCrafting recipeEntryCrafting : allRecipes) {
                if (!recipeEntryCrafting.matchesQueryIgnoreExceptions(query)) continue;
                filteredRecipes.add(recipeEntryCrafting);
            }
            ArrayList<GuidebookPage> filteredPages = new ArrayList<GuidebookPage>();
            int n = filteredRecipes.size();
            int filteredPageCount = MathHelper.ceilInt(n, 3);
            for (int i = 0; i < filteredPageCount; ++i) {
                int j = i * 3;
                ArrayList recipes = new ArrayList(filteredRecipes.subList(Math.min(j, n), Math.min(j + 3, n)));
                if (recipes.isEmpty()) continue;
                filteredPages.add(new RecipePageCrafting(this, recipes));
            }
            this.filteredPages = Pair.of(query.rawQuery, filteredPages);
            return filteredPages;
        }
        return this.filteredPages.getRight();
    }
}

