/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.crafting.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.gui.guidebook.crafting.displays.RecipeDisplayAdapter;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryDyeing;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;

public class DisplayAdapterDyeing
implements RecipeDisplayAdapter<RecipeEntryDyeing> {
    @Override
    public List<SlotGuidebook> getSlots(RecipeEntryDyeing recipe, int recipeAmount, int xOffset, int yOffset) {
        ArrayList<SlotGuidebook> recipeSlots = new ArrayList<SlotGuidebook>();
        int[] sharedMeta = new int[1];
        int slotsAmount = 10;
        for (int i = 0; i < slotsAmount - 1; ++i) {
            if (i == 4) {
                recipeSlots.add(new SlotGuidebookDye(i, 1 + 18 * (i % 3) + xOffset, 1 + 18 * (i / 3 + recipeAmount * 3) + yOffset, new RecipeSymbol(new ItemStack(Items.DYE, 1, 26)), false, recipe, sharedMeta));
                continue;
            }
            RecipeSymbol stack = recipe.inputSymbol;
            recipeSlots.add(new SlotGuidebook(i, 1 + 18 * (i % 3) + xOffset, 1 + 18 * (i / 3 + recipeAmount * 3) + yOffset, stack, false, recipe));
        }
        int centerY = (((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 8))).y) / 2;
        recipeSlots.add(new SlotGuidebookDyeResult(slotsAmount - 1, 81 + xOffset, centerY, new RecipeSymbol(new ItemStack(recipe.output.getItem(), 8, 26)), false, recipe, sharedMeta).setAsOutput());
        return recipeSlots;
    }

    public static class SlotGuidebookDye
    extends SlotGuidebook {
        private final int[] metadata;

        public SlotGuidebookDye(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe, int[] sharedMeta) {
            super(id, x, y, symbol, discovered, recipe);
            this.metadata = sharedMeta;
        }

        @Override
        public void showRandomItem() {
            this.metadata[0] = new Random().nextInt(16);
            this.item = new ItemStack(Items.DYE, 1, this.metadata[0]);
        }
    }

    public static class SlotGuidebookDyeResult
    extends SlotGuidebook {
        private final int[] metadata;
        private final RecipeEntryDyeing recipeEntryDyeing;

        public SlotGuidebookDyeResult(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryDyeing recipe, int[] sharedMeta) {
            super(id, x, y, symbol, discovered, recipe);
            this.metadata = sharedMeta;
            this.recipeEntryDyeing = recipe;
        }

        @Override
        public void showRandomItem() {
            super.showRandomItem();
            this.item = new ItemStack(this.item.itemID, this.item.stackSize, this.recipeEntryDyeing.getOutputMetaFromInputMeta(this.metadata[0]));
        }
    }
}

