/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.crafting.displays;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.gui.guidebook.crafting.displays.RecipeDisplayAdapter;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShaped;
import net.minecraft.core.item.ItemStack;

public class DisplayAdapterShaped
implements RecipeDisplayAdapter<RecipeEntryCraftingShaped> {
    @Override
    public List<SlotGuidebook> getSlots(RecipeEntryCraftingShaped recipe, int recipeAmount, int xOffset, int yOffset) {
        ArrayList<SlotGuidebook> recipeSlots = new ArrayList<SlotGuidebook>();
        if (recipe.recipeHeight > 2 || recipe.recipeWidth > 2) {
            int slotsAmount = 10;
            for (int i = 0; i < slotsAmount - 1; ++i) {
                int slotX = i % 3;
                int slotY = i / 3;
                if (slotX >= recipe.recipeWidth || slotY >= recipe.recipeHeight) {
                    recipeSlots.add(new SlotGuidebook(i, 1 + 18 * (i % 3) + xOffset, 1 + 18 * (i / 3 + recipeAmount * 3) + yOffset, null, false, recipe));
                    continue;
                }
                RecipeSymbol stack = ((RecipeSymbol[])recipe.getInput())[slotX + slotY * recipe.recipeWidth];
                recipeSlots.add(new SlotGuidebook(i, 1 + 18 * (i % 3) + xOffset, 1 + 18 * (i / 3 + recipeAmount * 3) + yOffset, stack, false, recipe));
            }
            int centerY = (((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 8))).y) / 2;
            recipeSlots.add(new SlotGuidebook(slotsAmount - 1, 81 + xOffset, centerY, new RecipeSymbol(((ItemStack)recipe.getOutput()).copy()), false, recipe).setAsOutput());
        } else {
            int slotsAmount = 5;
            for (int i = 0; i < slotsAmount - 1; ++i) {
                int slotX = i % 2;
                int slotY = i / 2;
                if (slotX >= recipe.recipeWidth || slotY >= recipe.recipeHeight) {
                    recipeSlots.add(new SlotGuidebook(i, 13 + 18 * (i % 2) + xOffset, 10 + 18 * (i / 2 + recipeAmount * 3) + yOffset, null, false, recipe));
                    continue;
                }
                RecipeSymbol stack = ((RecipeSymbol[])recipe.getInput())[slotX + slotY * recipe.recipeWidth];
                recipeSlots.add(new SlotGuidebook(i, 13 + 18 * (i % 2) + xOffset, 10 + 18 * (i / 2 + recipeAmount * 3) + yOffset, stack, false, recipe));
            }
            int centerY = (((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 3))).y) / 2;
            recipeSlots.add(new SlotGuidebook(slotsAmount - 1, 81 + xOffset, centerY, new RecipeSymbol((ItemStack)recipe.getOutput()), false, recipe).setAsOutput());
        }
        return recipeSlots;
    }
}

