/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.crafting.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.gui.guidebook.crafting.displays.RecipeDisplayAdapter;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryScrap;
import net.minecraft.core.item.ItemStack;

public class displayAdapterScrap
implements RecipeDisplayAdapter<RecipeEntryScrap> {
    @Override
    public List<SlotGuidebook> getSlots(RecipeEntryScrap recipe, int recipeAmount, int xOffset, int yOffset) {
        ArrayList<SlotGuidebook> recipeSlots = new ArrayList<SlotGuidebook>();
        ItemStack[] sharedItemBuffer = new ItemStack[1];
        RecipeSymbol[] symbols = new RecipeSymbol[]{new RecipeSymbol(recipe.itemToScrap.getDefaultStack()), null, null, null, new RecipeSymbol(recipe.scrapYieldStack)};
        for (int i = 0; i < 4; ++i) {
            int x = 13 + 18 * (i % 2) + xOffset;
            int y = 10 + 18 * (i / 2 + recipeAmount * 3) + yOffset;
            SlotGuidebook slot = i == 0 ? new SlotGuidebookToScrap(i, x, y, symbols[i], false, recipe, sharedItemBuffer) : new SlotGuidebook(i, x, y, symbols[i], false, recipe);
            recipeSlots.add(slot);
        }
        int centerY = (((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((SlotGuidebook)recipeSlots.get((int)(recipeSlots.size() - 3))).y) / 2;
        recipeSlots.add(new SlotGuidebookScrapYield(symbols.length - 1, 81 + xOffset, centerY, symbols[4], false, recipe, sharedItemBuffer).setAsOutput());
        return recipeSlots;
    }

    public static class SlotGuidebookToScrap
    extends SlotGuidebook {
        private final ItemStack[] itemBuffer;

        public SlotGuidebookToScrap(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryBase<?, ?, ?> recipe, ItemStack[] itemBuffer) {
            super(id, x, y, symbol, discovered, recipe);
            this.itemBuffer = itemBuffer;
        }

        @Override
        public void showRandomItem() {
            Random r = new Random();
            if (this.symbol != null && this.symbol.getItemGroup() != null) {
                List<ItemStack> list = this.symbol.resolve();
                ItemStack newItem = list.get(r.nextInt(list.size()));
                if (list.size() > 1) {
                    while (newItem == this.item) {
                        newItem = list.get(r.nextInt(list.size()));
                    }
                }
                this.item = newItem;
            }
            this.item.setMetadata(r.nextInt(this.item.getMaxDamage()));
            this.itemBuffer[0] = this.item;
        }
    }

    public static class SlotGuidebookScrapYield
    extends SlotGuidebook {
        private final ItemStack[] itemBuffer;
        private final RecipeEntryScrap recipe;

        public SlotGuidebookScrapYield(int id, int x, int y, RecipeSymbol symbol, boolean discovered, RecipeEntryScrap recipe, ItemStack[] itemBuffer) {
            super(id, x, y, symbol, discovered, recipe);
            this.itemBuffer = itemBuffer;
            this.recipe = recipe;
        }

        @Override
        public void showRandomItem() {
            if (this.itemBuffer[0] == null) {
                this.item = null;
                return;
            }
            this.item = this.recipe.scrapYield.getDefaultStack();
            Random r = new Random();
            if (this.symbol != null && this.symbol.getItemGroup() != null) {
                List<ItemStack> list = this.symbol.resolve();
                ItemStack newItem = list.get(r.nextInt(list.size()));
                if (list.size() > 1) {
                    while (newItem == this.item) {
                        newItem = list.get(r.nextInt(list.size()));
                    }
                }
                this.item = newItem;
            }
            this.item.stackSize = (int)((float)(this.itemBuffer[0].getMaxDamage() - this.itemBuffer[0].getMetadata()) / (float)this.itemBuffer[0].getMaxDamage() * (float)(this.recipe.maxYield - 1)) + 1;
            if (this.item.stackSize <= 0) {
                this.item = null;
            }
        }
    }
}

