/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.search;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookPageManager;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.RecipePage;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.TextureManager;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.lang.I18n;

public class GuidebookPageSearch
extends GuidebookPage {
    public static final TextFieldElement searchField = new TextFieldElement(null, Minecraft.getMinecraft().font, 0, 0, 120, 20, "", "Search...");
    public final ButtonElement searchClearButton = new ButtonElement(0, 0, 0, 20, 20, "X");
    private final Minecraft mc = Minecraft.getMinecraft();

    public GuidebookPageSearch(GuidebookSection section) {
        super(section);
    }

    @Override
    protected void renderForeground(TextureManager re, Font fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        GuidebookPageSearch.searchField.xPosition = x + 79 - GuidebookPageSearch.searchField.width / 2 - 10;
        GuidebookPageSearch.searchField.yPosition = y + 110 - GuidebookPageSearch.searchField.height / 2 - 70;
        this.searchClearButton.xPosition = GuidebookPageSearch.searchField.xPosition + GuidebookPageSearch.searchField.width + 5;
        this.searchClearButton.yPosition = GuidebookPageSearch.searchField.yPosition;
        searchField.drawTextBox();
        this.searchClearButton.drawButton(this.mc, mouseX, mouseY);
        int results = 0;
        for (GuidebookPage page : ScreenGuidebook.getPageManager().getPages()) {
            if (!(page instanceof RecipePage)) continue;
            results += ((RecipePage)page).recipes.size();
        }
        I18n tr = I18n.getInstance();
        this.drawStringCenteredNoShadow(fr, tr.translateKeyAndFormat("guidebook.section.search.result.found", results), x + 79, y + 10, -12566464);
        int offset = y + 70;
        this.drawStringCenteredNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.title"), x + 79, offset, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.1"), x + 10, offset += 15, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.2"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.3"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.4"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.5"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.6"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.7"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.8"), x + 10, offset += 10, -12566464);
        this.drawStringNoShadow(fr, tr.translateKey("guidebook.section.search.info.modifiers.9"), x + 10, offset += 15, -12566464);
    }

    @Override
    public void onTick() {
        super.onTick();
        if (GuidebookPageSearch.searchField.isFocused) {
            searchField.updateCursorCounter();
        }
    }

    @Override
    public void onStopBeingVisible() {
        super.onStopBeingVisible();
        searchField.setFocused(false);
    }

    @Override
    public void onMouseDown(int x, int y, int mouseX, int mouseY, int button) {
        super.onMouseDown(x, y, mouseX, mouseY, button);
        searchField.mouseClicked(mouseX, mouseY, button);
        if (GuidebookPageSearch.searchField.isFocused) {
            GuidebookPageManager.searchQuery = SearchQuery.resolve(searchField.getText());
            ScreenGuidebook.getPageManager().updatePages();
        }
        if (this.searchClearButton.mouseClicked(this.mc, mouseX, mouseY)) {
            searchField.setText("");
            GuidebookPageManager.searchQuery = SearchQuery.resolve(searchField.getText());
            ScreenGuidebook.getPageManager().updatePages();
        }
    }

    @Override
    public boolean keyTyped(char c, int key, int x, int y, int mouseX, int mouseY) {
        if (GuidebookPageSearch.searchField.isFocused) {
            searchField.textboxKeyTyped(c, key);
            GuidebookPageManager.searchQuery = SearchQuery.resolve(searchField.getText());
            ScreenGuidebook.getPageManager().updatePages();
            return true;
        }
        return false;
    }
}

