/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.particle;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.particle.ParticleBlockBreaking;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.gui.modelviewer.categories.entries.particle.ParticleEntryGeneric;
import net.minecraft.client.gui.modelviewer.elements.ListSelectorButtonElement;
import net.minecraft.client.gui.modelviewer.elements.TextCycleElement;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.Item;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ParticleEntryBlock
extends ParticleEntryGeneric {
    protected int blockId;
    protected int meta;
    private Side side = Side.BOTTOM;

    public ParticleEntryBlock() {
        super("block");
    }

    @Override
    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen) {
        List<ButtonElement> buttonList = super.getEntryButtons(mc, parentScreen);
        TextCycleElement<Integer> blockIdCycle = new TextCycleElement<Integer>(parentScreen, mc.font, -120, buttonList.get(buttonList.size() - 1).getY() + 21, 120, 20, Integer.valueOf(this.blockId)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return ScreenModelViewer.cycleBlockId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    return MathHelper.clamp(id, 0, Item.itemsList.length);
                }
                catch (Exception exception) {
                    return ParticleEntryBlock.this.blockId;
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        blockIdCycle.textField.setPrefaceText("ID: ");
        blockIdCycle.textField.setPlaceholder("Block ID");
        blockIdCycle.setOnValueChanged(() -> {
            this.blockId = (Integer)blockIdCycle.getCurrentElement();
        });
        buttonList.add(blockIdCycle);
        TextCycleElement<Integer> metaCycle = new TextCycleElement<Integer>(parentScreen, mc.font, -120, blockIdCycle.getY() + 21, 120, 20, Integer.valueOf(0)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return current + offset & 0x3FFF;
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    return MathHelper.clamp(id, 0, 16383);
                }
                catch (Exception exception) {
                    return ParticleEntryBlock.this.meta;
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        metaCycle.textField.setPrefaceText("Meta: ");
        metaCycle.textField.setPlaceholder("Meta");
        metaCycle.setOnValueChanged(() -> {
            this.meta = (Integer)metaCycle.getCurrentElement();
        });
        buttonList.add(metaCycle);
        ListSelectorButtonElement<Side> sideButton = new ListSelectorButtonElement<Side>(-1, -120, metaCycle.getY() + 21, 120, 20, I18n.getInstance().translateKey("model.category.particle.block.side"), Arrays.asList(Side.sides), this.side){

            @Override
            public String getNameFromElement(Side element) {
                return element.name();
            }
        };
        sideButton.setOnValueChanged(() -> {
            this.side = (Side)((Object)((Object)sideButton.getCurrentElement()));
        });
        buttonList.add(sideButton);
        return buttonList;
    }

    @Override
    public void spawnParticle(Minecraft mc, World world, double x, double y, double z) {
        mc.particleEngine.add(new ParticleBlockBreaking(world, x, y, z, this.motionX, this.motionY, this.motionZ, Blocks.getBlock(this.blockId), this.side, this.meta));
    }

    @Override
    public void onOpen() {
        this.blockId = 1;
    }
}

