/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.options.data.OptionsPage;
import net.minecraft.client.gui.options.data.OptionsPages;

public class OptionsPageRegistry {
    private static final OptionsPageRegistry INSTANCE = new OptionsPageRegistry();
    private final List<OptionsPage> pages = new ArrayList<OptionsPage>();

    public static OptionsPageRegistry getInstance() {
        return INSTANCE;
    }

    private OptionsPageRegistry() {
    }

    public void register(OptionsPage page) {
        if (!this.pages.contains(page)) {
            this.pages.add(page);
            if (OptionsPages.SEARCH != null) {
                this.pages.remove(OptionsPages.SEARCH);
                this.pages.add(OptionsPages.SEARCH);
            }
        }
    }

    public int getPageIndex(OptionsPage page) {
        return this.pages.indexOf(page);
    }

    public List<OptionsPage> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    static {
        OptionsPages.init();
    }
}

