/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.holiday;

import java.time.Month;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.minecraft.client.holiday.Holidays;

public class Holiday {
    protected int monthStart;
    protected int monthEnd;
    protected int dayStart;
    protected int dayEnd;
    protected String resourcePath = null;

    public Holiday(Month month, int day) {
        this.monthStart = this.monthEnd = month.ordinal();
        this.dayStart = this.dayEnd = day;
        Holidays.allHolidays.add(this);
    }

    public Holiday(Month monthStart, int dayStart, Month monthEnd, int dayEnd) {
        this.monthStart = monthStart.ordinal();
        this.dayStart = dayStart;
        this.monthEnd = monthEnd.ordinal();
        this.dayEnd = dayEnd;
        Holidays.allHolidays.add(this);
    }

    public Holiday setCustomResourcePath(String path) {
        if (path == null) {
            Holidays.allThemedHolidays.remove(this);
        } else {
            Holidays.allThemedHolidays.add(this);
        }
        this.resourcePath = path;
        return this;
    }

    public boolean hasCustomResources() {
        return this.resourcePath != null;
    }

    public String getCustomResourcesSubPath() {
        return this.resourcePath;
    }

    public boolean isActive() {
        Calendar c = Holiday.getLocalCalendar();
        return c.get(2) >= this.monthStart && c.get(2) <= this.monthEnd && c.get(5) >= this.dayStart && c.get(5) <= this.dayEnd;
    }

    public static Calendar getLocalCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone(ZoneId.systemDefault()), Locale.getDefault());
    }

    public static Date getLocalDate(int year, int month, int day) {
        Calendar c = Holiday.getLocalCalendar();
        c.set(year, month, day);
        return c.getTime();
    }
}

