/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.nio.FloatBuffer;
import net.minecraft.client.GLAllocation;
import net.minecraft.core.util.phys.Vec3;
import org.lwjgl.opengl.GL11;

public class Lighting {
    private static final FloatBuffer buffer = GLAllocation.createDirectFloatBuffer(16);

    public static void disable() {
        GL11.glDisable(2896);
        GL11.glDisable(16384);
        GL11.glDisable(16385);
        GL11.glDisable(2903);
    }

    public static void enableInventoryLight() {
        GL11.glPushMatrix();
        GL11.glRotatef(-30.0f, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(155.0f, 1.0f, 0.0f, 0.0f);
        Lighting.enableLight(0.4f, 0.5f);
        GL11.glPopMatrix();
    }

    public static void enableLight() {
        Lighting.enableLight(0.4f, 0.6f);
    }

    public static void enableLight(float ambientBrightness, float lightBrightness) {
        GL11.glEnable(2896);
        GL11.glEnable(16384);
        GL11.glEnable(16385);
        GL11.glEnable(2903);
        GL11.glColorMaterial(1032, 5634);
        Vec3 vec = Vec3.getTempVec3(0.2, 1.0, -0.7).normalize();
        GL11.glLightfv(16384, 4611, Lighting.getBuffer(vec.x, vec.y, vec.z, 0.0));
        GL11.glLightfv(16384, 4609, Lighting.getBuffer(lightBrightness, lightBrightness, lightBrightness, 1.0f));
        GL11.glLightfv(16384, 4608, Lighting.getBuffer(0.0f, 0.0f, 0.0f, 1.0f));
        GL11.glLightfv(16384, 4610, Lighting.getBuffer(0.0f, 0.0f, 0.0f, 1.0f));
        vec = Vec3.getTempVec3(-0.2, 1.0, 0.7).normalize();
        GL11.glLightfv(16385, 4611, Lighting.getBuffer(vec.x, vec.y, vec.z, 0.0));
        GL11.glLightfv(16385, 4609, Lighting.getBuffer(lightBrightness, lightBrightness, lightBrightness, 1.0f));
        GL11.glLightfv(16385, 4608, Lighting.getBuffer(0.0f, 0.0f, 0.0f, 1.0f));
        GL11.glLightfv(16385, 4610, Lighting.getBuffer(0.0f, 0.0f, 0.0f, 1.0f));
        GL11.glShadeModel(7424);
        GL11.glLightModelfv(2899, Lighting.getBuffer(ambientBrightness, ambientBrightness, ambientBrightness, 1.0f));
    }

    private static FloatBuffer getBuffer(double d, double d1, double d2, double d3) {
        return Lighting.getBuffer((float)d, (float)d1, (float)d2, (float)d3);
    }

    private static FloatBuffer getBuffer(float f, float f1, float f2, float f3) {
        buffer.clear();
        buffer.put(f).put(f1).put(f2).put(f3);
        buffer.flip();
        return buffer;
    }
}

