/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicDoor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;

public class BlockModelDoor<T extends BlockLogicDoor>
extends BlockModelStandard<T> {
    public BlockModelDoor(Block<T> block) {
        super(block);
    }

    public void setBrightness(Tessellator tessellator, int x, int y, int z, float sideBrightness) {
        float brightness = sideBrightness;
        if (LightmapHelper.isLightmapEnabled()) {
            tessellator.setLightmapCoord(this.block.getLightmapCoord(BlockModelDoor.renderBlocks.blockAccess, x, y, z));
        } else {
            brightness *= renderBlocks.getBlockBrightness(BlockModelDoor.renderBlocks.blockAccess, x, y, z);
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        if (LightmapHelper.isLightmapEnabled()) {
            tessellator.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 15));
        }
        tessellator.setColorOpaque_F(1.0f, 1.0f, 1.0f);
        AABB bounds = this.block.getBlockBoundsFromState(BlockModelDoor.renderBlocks.blockAccess, x, y, z);
        float sideBottom = 1.0f;
        float sideTop = 1.0f;
        float sideNorthSouth = 1.0f;
        float sideEastWest = 1.0f;
        if (RenderBlocks.enableDirectionalLight) {
            sideBottom = 0.5f;
            sideTop = 1.0f;
            sideNorthSouth = 0.8f;
            sideEastWest = 0.6f;
        }
        boolean aboveIsDoor = Block.hasLogicClass(BlockModelDoor.renderBlocks.blockAccess.getBlock(x, y + 1, z), BlockLogicDoor.class);
        boolean belowIsDoor = Block.hasLogicClass(BlockModelDoor.renderBlocks.blockAccess.getBlock(x, y - 1, z), BlockLogicDoor.class);
        int meta = BlockModelDoor.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        if (!belowIsDoor) {
            this.setBrightness(tessellator, x, y - 1, z, sideBottom);
            this.renderBottomFace(tessellator, bounds, x, y, z, this.getBlockTexture(BlockModelDoor.renderBlocks.blockAccess, x, y, z, Side.BOTTOM));
        }
        if (!aboveIsDoor) {
            this.setBrightness(tessellator, x, y + 1, z, sideTop);
            this.renderTopFace(tessellator, bounds, x, y, z, this.getBlockTexture(BlockModelDoor.renderBlocks.blockAccess, x, y, z, Side.TOP));
        }
        if (bounds.minZ > 0.0625) {
            this.setBrightness(tessellator, x, y, z, sideNorthSouth);
        } else {
            this.setBrightness(tessellator, x, y, z - 1, sideNorthSouth);
        }
        BlockModelDoor.renderBlocks.flipTexture = this.shouldFlipTexture(Side.NORTH, meta);
        IconCoordinate texture = this.getBlockTexture(BlockModelDoor.renderBlocks.blockAccess, x, y, z, Side.NORTH);
        this.renderNorthFace(tessellator, bounds, x, y, z, texture);
        BlockModelDoor.renderBlocks.flipTexture = false;
        if (bounds.maxZ < 0.9375) {
            this.setBrightness(tessellator, x, y, z, sideNorthSouth);
        } else {
            this.setBrightness(tessellator, x, y, z + 1, sideNorthSouth);
        }
        BlockModelDoor.renderBlocks.flipTexture = this.shouldFlipTexture(Side.SOUTH, meta);
        texture = this.getBlockTexture(BlockModelDoor.renderBlocks.blockAccess, x, y, z, Side.SOUTH);
        this.renderSouthFace(tessellator, bounds, x, y, z, texture);
        BlockModelDoor.renderBlocks.flipTexture = false;
        if (bounds.minX > 0.0625) {
            this.setBrightness(tessellator, x, y, z, sideEastWest);
        } else {
            this.setBrightness(tessellator, x - 1, y, z, sideEastWest);
        }
        BlockModelDoor.renderBlocks.flipTexture = this.shouldFlipTexture(Side.WEST, meta);
        texture = this.getBlockTexture(BlockModelDoor.renderBlocks.blockAccess, x, y, z, Side.WEST);
        this.renderWestFace(tessellator, bounds, x, y, z, texture);
        BlockModelDoor.renderBlocks.flipTexture = false;
        if (bounds.maxX < 0.9375) {
            this.setBrightness(tessellator, x, y, z, sideEastWest);
        } else {
            this.setBrightness(tessellator, x + 1, y, z, sideEastWest);
        }
        BlockModelDoor.renderBlocks.flipTexture = this.shouldFlipTexture(Side.EAST, meta);
        texture = this.getBlockTexture(BlockModelDoor.renderBlocks.blockAccess, x, y, z, Side.EAST);
        this.renderEastFace(tessellator, bounds, x, y, z, texture);
        BlockModelDoor.renderBlocks.flipTexture = false;
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    protected boolean shouldFlipTexture(Side side, int meta) {
        if (side == Side.TOP || side == Side.BOTTOM) {
            return false;
        }
        int state = ((BlockLogicDoor)this.block.getLogic()).getRotation(meta);
        int l = state / 2 + (side.getId() & 1 ^ state);
        if ((state == 0 || state == 2) ^ side.getId() <= 3) {
            return false;
        }
        return ((l += (meta & 4) / 4) & 1) != 0;
    }
}

