/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRendererBiped;
import net.minecraft.client.render.model.ModelZombie;
import net.minecraft.core.entity.monster.MobZombieArmored;

public class MobRendererZombieArmored
extends MobRendererBiped<MobZombieArmored> {
    private final ModelZombie modelArmorChestplate;
    private final ModelZombie modelArmor;

    public MobRendererZombieArmored(ModelZombie model, float shadowSize) {
        super(model, shadowSize);
        this.modelBipedMain = model;
        this.modelArmorChestplate = new ModelZombie(1.0f);
        this.modelArmor = new ModelZombie(0.5f);
    }

    @Override
    protected boolean prepareArmor(MobZombieArmored zombie, int renderPass, float partialTick) {
        this.bindTexture("/assets/minecraft/textures/armor/chain_" + (renderPass != 2 ? 1 : 2) + ".png");
        ModelZombie model = renderPass != 2 ? this.modelArmorChestplate : this.modelArmor;
        model.head.visible = renderPass == 0;
        model.hair.visible = renderPass == 0;
        model.body.visible = renderPass == 1 || renderPass == 2;
        model.armRight.visible = renderPass == 1;
        model.armLeft.visible = renderPass == 1;
        model.legRight.visible = renderPass == 2 || renderPass == 3;
        model.legLeft.visible = renderPass == 2 || renderPass == 3;
        int[] armorBreakPoints = zombie.getArmorBreakPoints();
        int[] armorBreakOrder = zombie.getArmorBreakOrder();
        for (int i = 0; i < 4; ++i) {
            if (zombie.getHealth() > armorBreakPoints[i]) continue;
            this.hideArmorPiece(armorBreakOrder[i]);
        }
        this.setArmorModel(model);
        return true;
    }

    private void hideArmorPiece(int piece) {
        if (piece == 0) {
            this.modelArmorChestplate.head.visible = false;
            this.modelArmorChestplate.hair.visible = false;
        } else if (piece == 1) {
            this.modelArmorChestplate.body.visible = false;
            this.modelArmorChestplate.armLeft.visible = false;
            this.modelArmorChestplate.armRight.visible = false;
        } else if (piece == 2) {
            this.modelArmor.body.visible = false;
            this.modelArmor.legLeft.visible = false;
            this.modelArmor.legRight.visible = false;
        } else if (piece == 3) {
            this.modelArmorChestplate.legLeft.visible = false;
            this.modelArmorChestplate.legRight.visible = false;
        }
    }
}

