/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import org.jetbrains.annotations.NotNull;

public class FontFile
implements Font {
    protected static final List<Character> DEFAULT_BLACKLIST = Arrays.asList(Character.valueOf('\uff0c'), Character.valueOf('\u3002'), Character.valueOf('\u3001'), Character.valueOf('\u3010'), Character.valueOf('\u3011'), Character.valueOf('\uff1b'), Character.valueOf('\u2019'), Character.valueOf('\u2018'), Character.valueOf('\u201c'), Character.valueOf('\u201d'), Character.valueOf('\uff1f'), Character.valueOf('\uff01'), Character.valueOf('\u00b7'));
    protected static final int ITALICS_SHIFT = 1;
    protected static final int GLYPHS_PER_TEXTURE = 256;
    protected static final int TEXTURE_UNASSIGNED = -1;
    protected final byte[] charWidth;
    protected final int[] texHandleCache;
    @NotNull
    protected final String textureFormat;
    @NotNull
    protected final String glyphSizesPath;
    @NotNull
    protected final String key;

    public FontFile(@NotNull String key, @NotNull String texturesFormat, @NotNull String glyphSizesPath) {
        this.key = key;
        this.textureFormat = texturesFormat;
        this.glyphSizesPath = glyphSizesPath;
        this.charWidth = new byte[65536];
        this.texHandleCache = new int[256];
    }

    @Override
    public void init(@NotNull TexturePackList packList) {
        Arrays.fill(this.texHandleCache, -1);
        try (InputStream glyphStreamDefault = packList.getResourceAsStream(this.glyphSizesPath);){
            glyphStreamDefault.read(this.charWidth);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    public int textureForChar(char c) {
        int index = c / 256;
        if (this.texHandleCache[index] != -1) {
            return this.texHandleCache[index];
        }
        Texture texture = Minecraft.getMinecraft().textureManager.loadTextureNoDefault(String.format(this.textureFormat, index));
        if (texture == null) {
            this.texHandleCache[index] = 0;
            return 0;
        }
        this.texHandleCache[index] = texture.id();
        return texture.id();
    }

    @Override
    public char getObfuscatedChar(char c, Random random) {
        char randomChar;
        if (ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c) < 0) {
            return c;
        }
        int counter = 0;
        do {
            randomChar = ChatAllowedCharacters.ALLOWED_CHARACTERS.charAt(random.nextInt(ChatAllowedCharacters.ALLOWED_CHARACTERS.length()));
            if (counter++ <= 1000) continue;
            randomChar = c;
            break;
        } while (this.charWidth(c) != this.charWidth(randomChar) || !this.canRenderChar(randomChar));
        return randomChar;
    }

    @Override
    public boolean canRenderChar(char c) {
        return c == ' ' || this.textureForChar(c) != 0;
    }

    @Override
    public double charWidthDouble(char c) {
        if (c == ' ') {
            return 4.0;
        }
        int upper = this.charWidth[c] >> 4;
        int lower = this.charWidth[c] & 0xF;
        double fUpper = upper;
        double fLower = lower + 1;
        return (fLower - fUpper) / 2.0 + 1.0;
    }

    @Override
    public int fontHeight() {
        return 8;
    }

    @Override
    public double renderChar(Tessellator tessellator, char c, double x, double y, double z, boolean italics) {
        if (c == ' ') {
            return 4.0;
        }
        boolean shift = italics;
        int lower = this.charWidth[c] & 0xF;
        double fLower = lower + 1;
        int upper = this.charWidth[c] >> 4;
        double fUpper = upper;
        if (fLower - fUpper == 0.0) {
            return 0.0;
        }
        double epsilon = 7.8125E-5;
        double u = (double)(c % 16 * 16) + fUpper;
        double v = (c & 0xFF) / 16 * 16;
        double uWidth = fLower - fUpper;
        double vHeight = 16.0;
        double uMin = u / 256.0;
        double uMax = (u + uWidth) / 256.0;
        double vMin = v / 256.0;
        double vMax = (v + 16.0) / 256.0;
        double width = uWidth / 2.0;
        double height = 8.0;
        tessellator.addVertexWithUV(x + (double)shift, y, z, uMin + 7.8125E-5, vMin + 7.8125E-5);
        tessellator.addVertexWithUV(x - (double)shift, y + 8.0, z, uMin + 7.8125E-5, vMax - 7.8125E-5);
        tessellator.addVertexWithUV(x - (double)shift + width, y + 8.0, z, uMax - 7.8125E-5, vMax - 7.8125E-5);
        tessellator.addVertexWithUV(x + (double)shift + width, y, z, uMax - 7.8125E-5, vMin + 7.8125E-5);
        return (fLower - fUpper) / 2.0 + 1.0;
    }
}

