/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.enums.EnumOS;
import org.slf4j.Logger;

public final class FileOpener {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static boolean toClipboard(String path) {
        EnumOS os = Minecraft.getOs();
        switch (os) {
            case windows: {
                return FileOpener.run("powershell", "-Command %s", "Get-ChildItem \"" + path + "\" | Set-Clipboard");
            }
            case macos: {
                return FileOpener.run("osascript", "-e %s", "set the clipboard to (read (POSIX file \"" + path + "\") as {\u00abclass PNGf\u00bb})");
            }
        }
        return FileOpener.run("xclip-copyfile", "%s", path);
    }

    public static void open(File file) {
        if (!FileOpener.openSystem(file.getPath())) {
            LOGGER.error("unable to open file {}", (Object)System.getProperty("os.name"));
        }
    }

    private static boolean openSystem(String what) {
        EnumOS os = Minecraft.getOs();
        switch (os) {
            case windows: {
                return FileOpener.run("explorer", "%s", what);
            }
            case macos: {
                return FileOpener.run("open", "%s", what);
            }
        }
        return FileOpener.run("kde-open", "%s", what) || FileOpener.run("gnome-open", "%s", what) || FileOpener.run("xdg-open", "%s", what);
    }

    private static boolean run(String command, String arg, String file) {
        String[] args = arg.split(" ");
        CharSequence[] parts = new String[args.length + 1];
        parts[0] = command;
        for (int i = 0; i < args.length; ++i) {
            parts[i + 1] = String.format(args[i], file).trim();
        }
        LOGGER.info(String.join((CharSequence)" ", parts));
        try {
            Process p = Runtime.getRuntime().exec((String[])parts);
            if (p == null) {
                return false;
            }
            try {
                return p.exitValue() == 0;
            }
            catch (IllegalThreadStateException itse) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.error("", e);
            return false;
        }
    }
}

