/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.enums.EnumOS;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class UrlHelper {
    private static final Logger LOGGER = LogUtils.getLogger();

    private UrlHelper() {
    }

    public static boolean openURL(@NotNull String url) {
        EnumOS os = Minecraft.getOs();
        Runtime rt = Runtime.getRuntime();
        try {
            switch (os) {
                case linux: 
                case solaris: {
                    rt.exec("xdg-open " + url);
                    break;
                }
                case windows: {
                    rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
                    break;
                }
                case macos: {
                    rt.exec("open " + url);
                    break;
                }
                default: {
                    LOGGER.error("No url handling behavior for os '{}'!", (Object)System.getProperty("os.name"));
                    return false;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException while trying to open url '{}'", (Object)url, (Object)e);
            return false;
        }
        return true;
    }
}

