/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFlower;
import net.minecraft.core.block.BlockLogicMoss;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class BlockLogicTallGrass
extends BlockLogicFlower {
    public BlockLogicTallGrass(Block<?> block) {
        super(block);
        float f = 0.4f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, 0.8f, 0.5f + f);
        block.withOverrideColor(MaterialColor.grass);
    }

    @Override
    protected boolean mayPlaceOn(int blockId) {
        Block<?> block = Blocks.getBlock(blockId);
        if (block != null && block.getLogic() instanceof BlockLogicMoss) {
            return true;
        }
        return super.mayPlaceOn(blockId);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return null;
    }
}

