/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

public class ChunkCoordinate {
    public final int x;
    public final int z;

    public ChunkCoordinate(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public static int toInt(int x, int z) {
        return (x >= 0 ? 0 : Integer.MIN_VALUE) | (x & 0x3FFF) << 16 | (z >= 0 ? 0 : 32768) | z & 0x3FFF;
    }

    public int hashCode() {
        return ChunkCoordinate.toInt(this.x, this.z);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChunkCoordinate) {
            ChunkCoordinate otherPair = (ChunkCoordinate)obj;
            return otherPair.x == this.x && otherPair.z == this.z;
        }
        return false;
    }
}

