package teamport.aether.entity.animal.aerbunny;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.monster.MobMonster;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.packet.PacketSetRiding;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import teamport.aether.entity.AetherRideable;
import teamport.aether.entity.animal.MobAetherAnimal;
import teamport.aether.helper.ParticleHelper;
import teamport.aether.items.AetherItemTags;
import teamport.aether.mixin.accessors.EntityAccessor;
import teamport.aether.net.message.AetherRideableNetworkMessage;
import turniplabs.halplibe.helper.EnvironmentHelper;
import turniplabs.halplibe.helper.network.NetworkHandler;

public class MobAerbunny extends MobAetherAnimal implements AetherRideable {
    public boolean grab;

    public MobAerbunny(World world) {
        super(world);
        this.setSize(0.4F, 0.4F);
        this.textureIdentifier = NamespaceID.getPermanent("aether", "aerbunny");
        this.mobDrops.add(new WeightedRandomLootObject(Items.STRING.getDefaultStack(), 1));
    }

    public boolean isFavouriteItem(ItemStack itemStack) {
        return itemStack != null && itemStack.itemID < Blocks.blocksList.length && Blocks.blocksList[itemStack.itemID].hasTag(BlockTags.SHEEPS_FAVOURITE_BLOCK) || itemStack != null && itemStack.getItem().hasTag(AetherItemTags.NATURE_STAFF_FOLLOW);
    }

    public int getMaxHealth() {
        return 4;
    }

    public double getRidingHeight() {
        return this.heightOffset - 1.1f;
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(20, 0, Integer.class);
    }

    public float getPuffiness() {
        return Float.intBitsToFloat(this.entityData.getInt(20));
    }

    public void setPuffiness(float val) {
        this.entityData.set(20, Float.floatToIntBits(val));
    }


    @Override
    public void controlEntity(float moveForward, float moveStrafe, boolean isJumping, float xRot, float yRot) {
        if (EnvironmentHelper.isClientWorld()) {
            NetworkHandler.sendToServer(
                    new AetherRideableNetworkMessage(moveForward, moveStrafe, isJumping, xRot, yRot)
            );
        }

        Player player = (Player) vehicle;

        assert player != null;
        if (player.yd < -0.225F && isJumping && !player.noPhysics) {
            ((Mob) this.vehicle).yd = 0.125F;
            this.cloudPoop();
            setPuffiness(1.15F);
        }
    }

    public void tick() {
        float puffiness = getPuffiness();

        if (puffiness > 0.0F) {
            puffiness -= 0.1F;
        } else {
            puffiness = 0.0F;
        }

        setPuffiness(puffiness);

        if (vehicle != null) {
            if (this.vehicle.isRemoved()) this.startRiding(this.vehicle);
        } else if (!grab) {
            if (this.moveForward != 0.0F) {
                int x = MathHelper.floor(this.x);
                int y = MathHelper.floor(this.bb.minY);
                int z = MathHelper.floor(this.z);

                if ((this.world.getBlockId(x, y - 1, z) != 0 || this.world.getBlockId(x, y - 2, z) != 0)
                        && this.world.getBlockId(x, y + 1, z) == 0 && this.world.getBlockId(x, y + 2, z) == 0
                ) {
                    if (this.yd < 0.0) {
                        this.cloudPoop();
                        setPuffiness(0.9F);
                    }
                    this.yd = 0.2;
                }
            }

            if (this.yd < -0.1) {
                this.yd = -0.1;
            }
        }

        if (this.vehicle instanceof Player) {
            Player player = (Player) vehicle;

            if (!player.onGround && !player.isInWaterOrRain() && !player.noPhysics) {
                ((EntityAccessor) player).setFallDistance(0.0F);
                player.yd += 0.05F;
            }

            player.handleSpecialVehicleControl();
            player.sendSpecialVehiclePacket();
        }

        super.tick();
    }

    public void causeFallDamage(float distance) {
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    public void onLivingUpdate() {
        if (onGround && this.moveForward != 0.0F) {
            this.jump();
            setPuffiness(1.15F);
            this.cloudPoop();
        }

        if (grab && onGround) {
            grab = false;

            this.world.playSoundAtEntity(null, this, "aether:mob.aerbunny.land", 1.0F, (this.random.nextFloat() - this.random.nextFloat()) * 0.2F + 1.0F);

            for (Entity entity : this.world.getEntitiesWithinAABBExcludingEntity(this, this.bb.expand(12.0, 12.0, 12.0))) {
                if (entity instanceof MobMonster) {
                    ((MobMonster) entity).setTarget(this);
                }
            }
        }

        if (this.isInWater()) {
            this.jump();
        }

        super.onLivingUpdate();
    }

    public void cloudPoop() {
        double a = this.random.nextFloat() - 0.5F;
        double d = this.x + a * 0.4000000059604645;
        double e = this.bb.minY;
        double f = this.z + a * 0.4000000059604645;
        if (!EnvironmentHelper.isServerEnvironment()) {
            ParticleHelper.spawnParticle(world, "explode", d, e, f, 0.0, -0.07500000298023224, 0.0, 0);
        }
    }

    public boolean hurt(Entity entity, int i, DamageType type) {
        if (this.vehicle != null) {
            return false;
        } else {
            return super.hurt(entity, i, type);
        }
    }

    public boolean interact(@NotNull Player player) {
        if (player.isSneaking()) return super.interact(player);

        if (this.vehicle == player) {
            grab = false;

            vehicle.ejectRider();
            return true;
        }

        if (player.getPassenger() instanceof MobAerbunny) {
            return false;
        }

        this.startRiding(player);

        grab = true;
        this.world.playSoundAtEntity(null, this, "aether:mob.aerbunny.lift", 1.0F, (this.random.nextFloat() - this.random.nextFloat()) * 0.2F + 1.0F);
        this.isJumping = false;

        return true;
    }

    public String getLivingSound() {
        return "aether:mob.aerbunny.lift";
    }

    public String getHurtSound() {
        return "aether:mob.aerbunny.hurt";
    }

    public String getDeathSound() {
        return "aether:mob.aerbunny.death";
    }


    @Override
    public void startRiding(IVehicle vehicle) {
        super.startRiding(vehicle);

        if (EnvironmentHelper.isServerEnvironment()) {
            MinecraftServer.getInstance().playerList.sendPacketToPlayersAroundPoint(
                    x, y, z, 32, world.dimension.id,
                    new PacketSetRiding(this, (Entity) this.vehicle)
            );
        }
    }
}
