package teamport.aether.mixin.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import teamport.aether.helper.ParticleHelper;
import teamport.aether.world.AetherDimension;

import java.util.List;

@Mixin(value = ItemBlock.class, remap = false)
public abstract class ItemBlockBlacklistMixin {

    @Shadow
    @NotNull
    protected Block<?> block;

    @Shadow
    public abstract int getPlacedBlockMetadata(@Nullable Player player, ItemStack stack, World world, int x, int y, int z, Side side, double xPlaced, double yPlaced);

    @Inject(method = "onUseItemOnBlock", at = @At(value = "HEAD"), cancellable = true)
    public void banBlocksFromDimensions(ItemStack stack, Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced, CallbackInfoReturnable<Boolean> cir) {
        Dimension dim = world.dimension;
        List<Integer> BLACKLIST = AetherDimension.getDimensionBlacklist(dim);

        if (BLACKLIST.contains(block.id())) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();

            if (dim == AetherDimension.AETHER) {
                if (block.id() == Blocks.PUMPKIN_CARVED_ACTIVE.id()) {
                    if (world.canBlockBePlacedAt(this.block.id(), blockX, blockY, blockZ, false, side) && stack.consumeItem(player)) {
                        int meta = this.getPlacedBlockMetadata(player, stack, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);

                        if (world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.PUMPKIN_CARVED_IDLE.id(), meta)) {
                            if (player != null)
                                this.block.onBlockPlacedByMob(world, blockX, blockY, blockZ, side, player, xPlaced, yPlaced);
                            else this.block.onBlockPlacedByWorld(world, blockX, blockY, blockZ);

                            world.playBlockSoundEffect(player, (float) blockX + 0.5F, (float) blockY + 0.5F, (float) blockZ + 0.5F, this.block, EnumBlockSoundEffectType.PLACE);
                        }

                        if (player != null && player.getGamemode().consumeBlocks()) {
                            ++stack.stackSize;
                        }
                    }
                }
                if (block.id() == Blocks.BRAZIER_ACTIVE.id()) {
                    if (world.canBlockBePlacedAt(this.block.id(), blockX, blockY, blockZ, false, side) && stack.consumeItem(player)) {
                        int meta = this.getPlacedBlockMetadata(player, stack, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);

                        if (world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, Blocks.BRAZIER_INACTIVE.id(), meta)) {
                            if (player != null)
                                this.block.onBlockPlacedByMob(world, blockX, blockY, blockZ, side, player, xPlaced, yPlaced);
                            else this.block.onBlockPlacedByWorld(world, blockX, blockY, blockZ);

                            world.playBlockSoundEffect(player, (float) blockX + 0.5F, (float) blockY + 0.5F, (float) blockZ + 0.5F, this.block, EnumBlockSoundEffectType.PLACE);
                        }

                        if (player != null && player.getGamemode().consumeBlocks()) {
                            ++stack.stackSize;
                        }
                    }
                }

                for (int l = 0; l < 8; ++l) {
                    double angle = Math.toRadians(l * 45);
                    ParticleHelper.spawnParticle(world, "smoke", (double) blockX + 0.5, (double) blockY + .2, (double) blockZ + 0.5, -Math.cos(angle) / 20.0, 0.03, -Math.sin(angle) / 20.0, 0);
                    ParticleHelper.spawnParticle(world, "largesmoke", (double) blockX + Math.random(), (double) blockY + .2, (double) blockZ + Math.random(), 0.0, 0.0, 0.0, 0);
                }
                world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double) blockX + 0.5, (double) blockY + 0.5, (double) blockZ + 0.5, "fire.ignite", 1.0F, world.rand.nextFloat() * 0.4F + 0.8F);
                world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float) blockX + 0.5f, (float) blockY + 0.5f, (float) blockZ + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            }
            cir.setReturnValue(true);
        }
    }
}
