/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.ArgumentTypeInteger;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntity;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.net.command.util.CommandHelper;
import teamport.aether.helper.HealthHelper;

public class CommandExtraHealth
implements CommandManager.CommandRegistry {
    static int add(CommandContext<?> c) {
        List entities;
        CommandSource source = (CommandSource)c.getSource();
        int amount = (Integer)c.getArgument("amount", Integer.class);
        EntitySelector entitySelector = (EntitySelector)c.getArgument("target", EntitySelector.class);
        try {
            entities = entitySelector.get(source).stream().filter(e -> e instanceof Player).map(e -> (Player)e).collect(Collectors.toList());
        }
        catch (CommandSyntaxException e2) {
            throw new RuntimeException(e2);
        }
        int max_health_added = 0;
        for (Player player : entities) {
            HealthHelper.addExtraHealth(player, amount);
        }
        if (entities.size() == 1) {
            source.sendTranslatableMessage("command.aether.add.extra_health.success_single_entity", new Object[]{max_health_added, CommandHelper.getEntityName((Entity)((Entity)entities.get(0)))});
        } else {
            source.sendTranslatableMessage("command.aether.add.extra_health.success_multiple_entities", new Object[]{max_health_added});
        }
        return 0;
    }

    static int set(CommandContext<?> c) {
        List entities;
        CommandSource source = (CommandSource)c.getSource();
        int amount = (Integer)c.getArgument("amount", Integer.class);
        amount = Math.min(20, amount);
        EntitySelector entitySelector = (EntitySelector)c.getArgument("target", EntitySelector.class);
        try {
            entities = entitySelector.get(source).stream().filter(e -> e instanceof Player).map(e -> (Player)e).collect(Collectors.toList());
        }
        catch (CommandSyntaxException e2) {
            throw new RuntimeException(e2);
        }
        for (Player player : entities) {
            HealthHelper.setExtraHealth(player, amount);
        }
        if (entities.size() == 1) {
            source.sendTranslatableMessage("command.aether.set.extra_health.success_single_entity", new Object[]{CommandHelper.getEntityName((Entity)((Entity)entities.get(0))), amount});
        } else {
            source.sendTranslatableMessage("command.aether.set.extra_health.success_multiple_entities", new Object[]{amount});
        }
        return 0;
    }

    static int get(CommandContext<?> c) throws CommandSyntaxException {
        CommandSource source = (CommandSource)c.getSource();
        EntitySelector entitySelector = (EntitySelector)c.getArgument("target", EntitySelector.class);
        List entities = entitySelector.get(source);
        int total_health = 0;
        for (Entity player : entities) {
            total_health += HealthHelper.getExtraHealth((Player)player);
        }
        if (entities.size() == 1) {
            source.sendTranslatableMessage("command.aether.get.extra_health.success_single_entity", new Object[]{CommandHelper.getEntityName((Entity)((Entity)entities.get(0))), total_health});
        } else {
            source.sendTranslatableMessage("command.aether.get.extra_health.success_multiple_entities", new Object[]{total_health});
        }
        return 0;
    }

    public void register(CommandDispatcher<CommandSource> commandDispatcher) {
        ArgumentBuilderLiteral commandExtraHealth = (ArgumentBuilderLiteral)((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal((String)"aether:extraHealth").requires(t -> ((CommandSource)t).hasAdmin())).then(ArgumentBuilderLiteral.literal((String)"add").then(ArgumentBuilderRequired.argument((String)"target", (ArgumentType)ArgumentTypeEntity.usernames()).then(ArgumentBuilderRequired.argument((String)"amount", (ArgumentType)ArgumentTypeInteger.integer()).executes(CommandExtraHealth::add)))).then(ArgumentBuilderLiteral.literal((String)"get").then(ArgumentBuilderRequired.argument((String)"target", (ArgumentType)ArgumentTypeEntity.usernames()).executes(CommandExtraHealth::get))).then(ArgumentBuilderLiteral.literal((String)"set").then(ArgumentBuilderRequired.argument((String)"target", (ArgumentType)ArgumentTypeEntity.usernames()).then(ArgumentBuilderRequired.argument((String)"amount", (ArgumentType)ArgumentTypeInteger.integer()).executes(CommandExtraHealth::set))));
        commandDispatcher.register(commandExtraHealth);
    }
}

