/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.animal.sheepuff;

import com.mojang.nbt.tags.CompoundTag;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemDye;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tool.ItemToolShears;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import teamport.aether.blocks.AetherBlocks;
import teamport.aether.entity.animal.MobAetherAnimal;
import teamport.aether.items.AetherItemTags;

public class MobSheepuff
extends MobAetherAnimal {
    public static final float[][] FLEECE_COLOR_TABLE = new float[][]{{1.0f, 1.0f, 1.0f}, {0.95f, 0.7f, 0.2f}, {0.9f, 0.5f, 0.85f}, {0.6f, 0.7f, 0.95f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.7f, 0.8f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.6f, 0.7f}, {0.7f, 0.4f, 0.9f}, {0.2f, 0.4f, 0.8f}, {0.5f, 0.4f, 0.3f}, {0.4f, 0.5f, 0.2f}, {0.8f, 0.3f, 0.3f}, {0.1f, 0.1f, 0.1f}};
    public int growthTimer;
    public int timeSheepEating;
    public int prevTimeSheepEating;

    public MobSheepuff(World world) {
        super(world);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"sheepuff");
        this.growthTimer = this.random.nextInt(100) + 100;
        this.setSize(0.9f, 1.3f);
    }

    public boolean isFavouriteItem(ItemStack itemStack) {
        return itemStack != null && itemStack.itemID < Blocks.blocksList.length && Blocks.blocksList[itemStack.itemID].hasTag(BlockTags.SHEEPS_FAVOURITE_BLOCK) || itemStack != null && itemStack.getItem().hasTag(AetherItemTags.NATURE_STAFF_FOLLOW);
    }

    public void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(16, (Object)0, Byte.class);
        this.entityData.define(17, (Object)0, Byte.class);
    }

    public void dropDeathItems() {
        super.dropDeathItems();
        if (!this.getSheared()) {
            this.dropItem(new ItemStack(Blocks.WOOL.id(), 1, this.getFleeceColor().blockMeta), 0.0f);
        }
        if (this.getPuffed()) {
            this.dropItem(new ItemStack(Blocks.WOOL.id(), 2, this.getFleeceColor().blockMeta), 0.0f);
        }
    }

    public void onLivingUpdate() {
        Block blockBelow;
        int blockZ;
        int blockY;
        int blockX;
        super.onLivingUpdate();
        if (!this.getPuffed()) {
            ++this.growthTimer;
        }
        if (this.getPuffed()) {
            this.setSheared(false);
        }
        if (this.getSheared()) {
            this.setPuffed(false);
        }
        if (this.getPuffed()) {
            this.fallDistance = 0.0f;
            if (this.yd < -0.05) {
                this.yd *= 0.4;
            }
        }
        if (this.growthTimer > 400) {
            blockX = MathHelper.floor((double)this.x);
            blockY = MathHelper.floor((double)this.y);
            blockZ = MathHelper.floor((double)this.z);
            blockBelow = this.world.getBlock(blockX, blockY - 1, blockZ);
            this.growthTimer = 0;
            if (blockBelow == AetherBlocks.GRASS_AETHER && !this.world.isClientSide) {
                this.setIsSheepEating(true);
            }
            if (!(blockBelow != Blocks.GRASS && blockBelow != Blocks.GRASS_RETRO || this.world.isClientSide)) {
                this.setIsSheepEating(true);
            }
            this.timeSheepEating = 0;
            this.prevTimeSheepEating = 0;
        }
        if (this.getIsSheepEating()) {
            blockX = MathHelper.floor((double)this.x);
            blockY = MathHelper.floor((double)this.y);
            blockZ = MathHelper.floor((double)this.z);
            blockBelow = this.world.getBlock(blockX, blockY - 1, blockZ);
            if (this.timeSheepEating >= 5 && this.timeSheepEating <= 35 && this.timeSheepEating % 5 == 0 && !this.world.isClientSide) {
                this.world.playBlockSoundEffect(null, this.x + 0.5, this.y + 0.5, this.z + 0.5, AetherBlocks.GRASS_AETHER, EnumBlockSoundEffectType.DIG);
            }
            this.prevTimeSheepEating = this.timeSheepEating++;
            if (this.prevTimeSheepEating == 35 && blockBelow == AetherBlocks.GRASS_AETHER && !this.world.isClientSide) {
                this.world.playBlockEvent(null, 2001, (int)this.x, (int)this.y - 1, (int)this.z, this.world.getBlockId((int)this.x, (int)this.y - 1, (int)this.z));
                this.world.setBlockWithNotify(blockX, blockY - 1, blockZ, AetherBlocks.DIRT_AETHER.id());
                this.setPuffed(true);
                this.setSheared(false);
            }
            if (!(this.prevTimeSheepEating != 35 || blockBelow != Blocks.GRASS && blockBelow != Blocks.GRASS_RETRO || this.world.isClientSide)) {
                this.world.playBlockEvent(null, 2001, (int)this.x, (int)this.y - 1, (int)this.z, this.world.getBlockId((int)this.x, (int)this.y - 1, (int)this.z));
                this.world.setBlockWithNotify(blockX, blockY - 1, blockZ, Blocks.DIRT.id());
                this.setPuffed(true);
                this.setSheared(false);
            }
            if (this.prevTimeSheepEating >= 40) {
                this.prevTimeSheepEating = 0;
                this.timeSheepEating = 0;
                if (!this.world.isClientSide) {
                    this.setIsSheepEating(false);
                }
            }
        }
    }

    public boolean interact(@NotNull Player player) {
        if (super.interact(player)) {
            return true;
        }
        ItemStack itemstack = player.inventory.getCurrentItem();
        if (itemstack != null && itemstack.getItem() instanceof ItemToolShears && this.getPuffed()) {
            if (!this.world.isClientSide) {
                this.setPuffed(false);
                int count = 2 + this.random.nextInt(3);
                for (int j = 0; j < count; ++j) {
                    EntityItem entityitem = this.dropItem(new ItemStack(Blocks.WOOL.id(), 1, this.getFleeceColor().blockMeta), 1.0f);
                    entityitem.yd += (double)(this.random.nextFloat() * 0.05f);
                    entityitem.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                    entityitem.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                }
            }
            itemstack.damageItem(1, (Entity)player);
            if (itemstack.stackSize <= 0) {
                player.destroyCurrentEquippedItem();
            }
            return true;
        }
        if (itemstack != null && itemstack.getItem() instanceof ItemToolShears && !this.getSheared() && !this.getPuffed()) {
            if (!this.world.isClientSide) {
                this.setSheared(true);
                int count = 2 + this.random.nextInt(3);
                for (int j = 0; j < count; ++j) {
                    EntityItem entityitem = this.dropItem(new ItemStack(Blocks.WOOL.id(), 1, this.getFleeceColor().blockMeta), 1.0f);
                    entityitem.yd += (double)(this.random.nextFloat() * 0.05f);
                    entityitem.xd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                    entityitem.zd += (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f);
                }
            }
            itemstack.damageItem(1, (Entity)player);
            if (itemstack.stackSize <= 0) {
                player.destroyCurrentEquippedItem();
            }
            return true;
        }
        if (itemstack != null && itemstack.getItem() instanceof ItemDye && !this.world.isClientSide) {
            DyeColor woolColor = DyeColor.colorFromItemMeta((int)itemstack.getMetadata());
            if (this.getFleeceColor() != woolColor && itemstack.consumeItem(player)) {
                this.setFleeceColor(woolColor);
                return true;
            }
        }
        return false;
    }

    public String getLivingSound() {
        return "mob.sheep";
    }

    public String getHurtSound() {
        return "mob.sheep";
    }

    public String getDeathSound() {
        return "mob.sheep";
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Sheared", this.getSheared());
        tag.putBoolean("Puffed", this.getPuffed());
        tag.putByte("Color", (byte)this.getFleeceColor().blockMeta);
        tag.putShort("GrowthTimer", (short)this.growthTimer);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSheared(tag.getBoolean("Sheared"));
        this.setPuffed(tag.getBoolean("Puffed"));
        this.setFleeceColor(DyeColor.colorFromBlockMeta((int)tag.getByte("Color")));
        this.setGrowthTimer(tag.getShort("GrowthTimer"));
    }

    public boolean getPuffed() {
        return (this.entityData.getByte(16) & 0x20) != 0;
    }

    public void setPuffed(boolean flag) {
        byte byte0 = this.entityData.getByte(16);
        if (flag) {
            this.entityData.set(16, (Object)((byte)(byte0 | 0x20)));
        } else {
            this.entityData.set(16, (Object)((byte)(byte0 & 0xFFFFFFDF)));
        }
    }

    public DyeColor getFleeceColor() {
        return DyeColor.colorFromBlockMeta((int)(this.entityData.getByte(16) & 0xF));
    }

    public void setFleeceColor(DyeColor color) {
        byte woolState = this.entityData.getByte(16);
        this.entityData.set(16, (Object)((byte)(woolState & 0xFFFFFFF0 | color.blockMeta & 0xF)));
    }

    public boolean getSheared() {
        return (this.entityData.getByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean flag) {
        byte woolState = this.entityData.getByte(16);
        if (flag) {
            this.entityData.set(16, (Object)((byte)(woolState | 0x10)));
        } else {
            this.entityData.set(16, (Object)((byte)(woolState & 0xFFFFFFEF)));
        }
    }

    public boolean isMovementBlocked() {
        return super.isMovementBlocked() || this.getIsSheepEating();
    }

    public boolean getIsSheepEating() {
        return this.entityData.getByte(17) != 0;
    }

    public void setIsSheepEating(boolean value) {
        this.entityData.set(17, (Object)((byte)(value ? 1 : 0)));
    }

    public void setGrowthTimer(int growthTimer) {
        this.growthTimer = growthTimer;
    }

    public void jump() {
        if (this.getPuffed()) {
            this.yd = 1.5;
            this.xd += this.random.nextGaussian() * 0.5;
            this.zd += this.random.nextGaussian() * 0.5;
        } else {
            this.yd = 0.42f;
        }
    }

    public void spawnInit() {
        this.setFleeceColor(MobSheepuff.getRandomFleeceColor(this.random));
    }

    public static DyeColor getRandomFleeceColor(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return DyeColor.CYAN;
        }
        if (i < 10) {
            return DyeColor.LIGHT_BLUE;
        }
        if (i < 15) {
            return DyeColor.LIME;
        }
        if (i < 18) {
            return DyeColor.PURPLE;
        }
        return random.nextInt(500) != 0 ? DyeColor.WHITE : DyeColor.PINK;
    }
}

