/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.boss.sunspirit;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sunsetsatellite.catalyst.core.util.vector.Vec2f;
import teamport.aether.AetherMod;
import teamport.aether.achievements.AetherAchievements;
import teamport.aether.entity.boss.AetherBossList;
import teamport.aether.entity.boss.sunspirit.MobBossFlying;
import teamport.aether.entity.monster.fireminion.MobFireMinion;
import teamport.aether.entity.projectile.ProjectileElementFire;
import teamport.aether.entity.projectile.ProjectileElementIce;
import teamport.aether.helper.ParticleHelper;
import teamport.aether.world.AetherDimension;

public class MobBossSunspirit
extends MobBossFlying {
    public int timesShot = 0;
    public int chatLog;
    public int chatCooldown;
    public int direction;
    public double rotary;
    public static final int START_FIGHT = 9;
    @Nullable
    public Entity target;
    public boolean isAgro;
    public boolean hasAttacked;
    public Vec2f DVDMoveAmount = new Vec2f(0.25, 0.25);

    public MobBossSunspirit(@Nullable World world) {
        super(world);
        this.setSize(2.25f, 3.0f);
        this.textureIdentifier = NamespaceID.getPermanent((String)"aether", (String)"boss_sunspirit");
        this.fireImmune = true;
        this.maxHurtTime = 40;
        this.scoreValue = 100000;
        this.chatColor = (byte)(TextFormatting.YELLOW.id & 0xFF);
        this.canBreatheUnderwater();
    }

    public void returnToOriginalState() {
        this.isAgro = false;
        this.target = null;
        this.returnToHome();
        this.runWithDungeon(d -> d.unlock(this, this.world));
        this.setHealthRaw(this.getMaxHealth());
    }

    public void updateAI() {
        super.updateAI();
        if (this.isAgro) {
            this.DVDMove();
            this.target = this.findPlayerToAttack();
            if (this.target != null) {
                this.lookAt(this.target, 20.0f, 20.0f);
                this.attackEntity(this.target, 32.0f);
            } else if (this.world.getClosestPlayerToEntity((Entity)this, 80.0) == null) {
                this.returnToOriginalState();
            }
        }
    }

    public double speedness() {
        return 0.5 - (double)this.getHealth() / 70.0 * 0.2;
    }

    protected void DVDMove() {
        HitResult hitResult = this.world.checkBlockCollisionBetweenPoints(Vec3.getPermanentVec3((double)this.x, (double)(this.y + (double)(this.bbHeight / 2.0f)), (double)this.z), Vec3.getPermanentVec3((double)(this.x + this.xd + this.DVDMoveAmount.x + (double)(this.DVDMoveAmount.x > 0.0 ? this.bbWidth / 2.0f : -this.bbWidth / 2.0f)), (double)(this.y + (double)(this.bbHeight / 2.0f)), (double)(this.z + this.zd + this.DVDMoveAmount.y + (double)(this.DVDMoveAmount.y > 0.0 ? this.bbWidth / 2.0f : -this.bbWidth / 2.0f))), false);
        if (hitResult != null) {
            double speed = 0.25 * this.speedness();
            switch (hitResult.side) {
                case NORTH: {
                    this.DVDMoveAmount.y -= speed;
                    break;
                }
                case SOUTH: {
                    this.DVDMoveAmount.y += speed;
                    break;
                }
                case WEST: {
                    this.DVDMoveAmount.x -= speed;
                    break;
                }
                case EAST: {
                    this.DVDMoveAmount.x += speed;
                }
            }
            this.DVDMoveAmount.x += (double)this.random.nextFloat() * 0.1 - (double)this.random.nextFloat() * 0.1;
            this.DVDMoveAmount.y += (double)this.random.nextFloat() * 0.1 - (double)this.random.nextFloat() * 0.1;
        }
        double maxSpeed = 0.035;
        double currSpeed = Math.hypot(this.DVDMoveAmount.x, this.DVDMoveAmount.y);
        if (currSpeed > maxSpeed) {
            this.DVDMoveAmount.multiply(maxSpeed / currSpeed);
        }
        this.xd += this.DVDMoveAmount.x;
        this.zd += this.DVDMoveAmount.y;
    }

    @Override
    public void returnToHome() {
        if (this.returnPoint == null || !this.hasHadReturnPointSet) {
            return;
        }
        this.moveTo((double)this.returnPoint.x + 0.5, this.returnPoint.y, (double)this.returnPoint.z + 0.5, 0.0f, 0.0f);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
    }

    public void knockBack(Entity entity, int damage, double xd, double yd) {
    }

    public void tick() {
        super.tick();
        if (this.getHealth() > 0) {
            double a = this.random.nextFloat() - 0.5f;
            double b = this.random.nextFloat();
            double c = this.random.nextFloat() - 0.5f;
            double flameX = this.x + a * b;
            double flameY = this.bb.minY + b - 0.5;
            double flameZ = this.z + c * b;
            ParticleHelper.spawnParticle(this.world, "flame", flameX, flameY, flameZ, 0.0, -0.075f, 0.0, 0);
            this.evaporateWater();
        }
        this.maxFireTicks = 0;
        this.fireImmune = true;
        this.remainingFireTicks = 0;
        if (this.chatCooldown > 0) {
            --this.chatCooldown;
        }
    }

    public boolean collidesWith(Entity entity) {
        if (!(entity instanceof MobBossSunspirit) && !(entity instanceof MobFireMinion)) {
            entity.hurt((Entity)this, 20, DamageType.FIRE);
            entity.hurt((Entity)this, 10, DamageType.COMBAT);
            entity.maxFireTicks = 300;
            entity.remainingFireTicks = 300;
            return false;
        }
        return false;
    }

    public void evaporateWater() {
        int x = MathHelper.floor((double)this.x);
        int z = MathHelper.floor((double)this.z);
        for (int i = 0; i < 8; ++i) {
            int b = (int)(this.yo - 2.0 + (double)i);
            if (this.world.getBlockMaterial(x, b, z) != Material.water) continue;
            this.world.setBlockWithNotify(x, b, z, 0);
            this.world.playSoundEffect((Entity)this, SoundCategory.ENTITY_SOUNDS, (double)((float)x + 0.5f), (double)((float)b + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.25f, 2.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                ParticleHelper.spawnParticle(this.world, "largesmoke", (double)x - 1.0 + 2.0 * Math.random(), (double)b + 0.75, (double)z - 1.0 + 2.0 * Math.random(), 0.0, 0.025f, 0.0, 0);
            }
        }
    }

    public boolean isPushable() {
        return false;
    }

    public boolean chatWithMe(Player player) {
        if (this.isAgro && this.target != null) {
            return false;
        }
        if (this.chatCooldown <= 0) {
            if (this.chatLog < 9) {
                player.sendMessage(TextFormatting.ORANGE + AetherMod.TRANSLATOR.translateKey("aether.entity.boss_sunspirit.chat_" + this.chatLog));
                if (this.chatLog >= 5 && this.chatLog < 8) {
                    player.sendMessage(TextFormatting.ORANGE + AetherMod.TRANSLATOR.translateKey("aether.entity.boss_sunspirit.chat_" + this.chatLog + "_1"));
                }
                this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.sunspirit.talk", 1.0f, 1.0f);
                ++this.chatLog;
                this.chatCooldown = 10;
                return false;
            }
            if (this.chatLog == 9) {
                player.sendMessage(TextFormatting.RED + AetherMod.TRANSLATOR.translateKey("aether.entity.boss_sunspirit.fight.start"));
                this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.sunspirit.talk", 1.0f, 0.5f);
                ((AetherBossList)player).aether$TryAddBossList((Mob)this);
                ++this.chatLog;
                this.isAgro = true;
                this.runWithDungeon(d -> d.lock(this, this.world));
                return true;
            }
            if (this.target == null) {
                player.sendMessage(TextFormatting.RED + AetherMod.TRANSLATOR.translateKey("aether.entity.boss_sunspirit.fight.repeat"));
                this.world.playSoundAtEntity(null, (Entity)this, "aether:mob.sunspirit.talk", 1.0f, 1.0f);
                ((AetherBossList)player).aether$TryAddBossList((Mob)this);
                this.chatLog = 9;
                this.chatCooldown = 40;
                this.isAgro = true;
                return false;
            }
        }
        return false;
    }

    public boolean interact(@NotNull Player player) {
        if (this.chatWithMe(player)) {
            this.rotary = 57.295772552490234 * Math.atan2(this.x - player.x, this.z - player.z);
            this.target = player;
        }
        return false;
    }

    @Override
    public void onDeath(Entity entityKilledBy) {
        this.runWithDungeon(d -> d.unlock(this, this.world));
        if (!this.world.isClientSide && this.world.dimension == AetherDimension.AETHER) {
            AetherDimension.unlockDaylightCycle(this.world);
        }
        this.world.players.stream().filter(player -> player.distanceTo((Entity)this) < 32.0f).forEach(players -> {
            players.sendMessage(TextFormatting.LIGHT_BLUE + AetherMod.TRANSLATOR.translateKey("aether.entity.boss_sunspirit.dies"));
            players.triggerAchievement((Stat)AetherAchievements.GOLD);
            this.world.playSoundEffect((Entity)players, SoundCategory.WORLD_SOUNDS, players.x, players.y, players.z, "", 0.5f, 1.0f);
        });
        super.onDeath(entityKilledBy);
    }

    public int getMaxHealth() {
        return 50;
    }

    public Entity findPlayerToAttack() {
        Player player = this.world.getClosestPlayerToEntity((Entity)this, 16.0);
        if (player != null && this.canEntityBeSeen((Entity)player) && player.gamemode.areMobsHostile()) {
            ((AetherBossList)player).aether$TryAddBossList((Mob)this);
            return player;
        }
        return null;
    }

    @Override
    public boolean canFight() {
        return this.isAlive() && this.isAgro;
    }

    public float getBrightness(float partialTick) {
        return 1.0f;
    }

    public int getLightmapCoord(float partialTick) {
        return this.world.getLightmapCoord(15, 15);
    }

    public void attackEntity(@NotNull Entity entity, float distance) {
        int totalShots = 4;
        float healthPercentage = (float)this.getHealth() / (float)this.getMaxHealth();
        float fireballSpeed = 0.5f + (1.0f - healthPercentage) * 0.5f;
        float iceballSpeed = 0.1f + (1.0f - healthPercentage) * 0.2f;
        if (this.attackTime == 0) {
            if (!this.world.isClientSide) {
                if (this.timesShot < totalShots) {
                    ProjectileElementFire elementFire = new ProjectileElementFire(this.world, (Mob)this);
                    elementFire.setHeading(this.world.rand.nextDouble(), this.getLookAngle().y, this.world.rand.nextDouble(), fireballSpeed, 0.0f);
                    this.world.playSoundAtEntity(null, (Entity)this, "mob.ghast.fireball", this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                    this.world.entityJoinedWorld((Entity)elementFire);
                    ++this.timesShot;
                } else {
                    ProjectileElementIce elementIce = new ProjectileElementIce(this.world, (Mob)this);
                    elementIce.setHeading(this.getLookAngle().x, this.getLookAngle().y, this.getLookAngle().z, iceballSpeed, this.world.rand.nextFloat());
                    this.world.playSoundAtEntity(null, (Entity)this, "mob.ghast.fireball", this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 2.0f);
                    this.world.entityJoinedWorld((Entity)elementIce);
                    this.timesShot = 0;
                }
            }
            this.attackTime = this.getHealth() <= this.getMaxHealth() / 2 ? 25 : 35;
        }
        this.hasAttacked = true;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.timesShot = tag.getInteger("timesShot");
        this.chatLog = tag.getByte("chatLog");
        this.isAgro = tag.getBoolean("isAgro");
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("timesShot", this.timesShot);
        tag.putByte("chatLog", (byte)this.chatLog);
        tag.putBoolean("isAgro", this.isAgro);
    }

    public boolean hurt(Entity attacker, int damage, DamageType type) {
        if (attacker == null && type == null && damage == 100) {
            this.setHealthRaw(0);
            this.playDeathSound();
            this.onDeath(null);
            return true;
        }
        if (attacker instanceof ProjectileElementIce) {
            super.hurt(attacker, 5, type);
            if (this.target instanceof Player) {
                ((Player)this.target).triggerAchievement((Stat)AetherAchievements.ICE_DEFLECT);
            }
            if (this.getHealth() > 0) {
                if (this.getHealth() <= this.getMaxHealth() / 2) {
                    MobFireMinion minion1 = new MobFireMinion(this.world);
                    minion1.setPos(this.x + 1.0, this.y + 1.0, this.z);
                    MobFireMinion minion2 = new MobFireMinion(this.world);
                    minion2.setPos(this.x, this.y + 1.0, this.z);
                    MobFireMinion minion3 = new MobFireMinion(this.world);
                    minion3.setPos(this.x - 1.0, this.y + 1.0, this.z);
                    this.world.entityJoinedWorld((Entity)minion1);
                    this.world.entityJoinedWorld((Entity)minion2);
                    this.world.entityJoinedWorld((Entity)minion3);
                } else {
                    MobFireMinion minion = new MobFireMinion(this.world);
                    minion.setPos(this.x, this.y, this.z);
                    this.world.entityJoinedWorld((Entity)minion);
                }
            }
            return true;
        }
        if (!this.isAgro) {
            this.chatLog = 9;
        }
        return false;
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public String getHurtSound() {
        return "aether:mob.sunspirit.hurt";
    }

    public String getDeathSound() {
        return "aether:mob.sunspirit.death";
    }

    public String getEntityTexture() {
        if (this.hurtTime > 0) {
            return "/assets/aether/textures/entity/boss_sunspirit/sunspirit_hurt.png";
        }
        return "/assets/aether/textures/entity/boss_sunspirit/sunspirit.png";
    }

    @NotNull
    public String getDefaultEntityTexture() {
        if (this.hurtTime > 0) {
            return "/assets/aether/textures/entity/boss_sunspirit/sunspirit_hurt.png";
        }
        return "/assets/aether/textures/entity/boss_sunspirit/sunspirit.png";
    }
}

