/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.entity.monster.fireminion;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class ModelFireMinion
extends ModelBiped {
    public Cube bipedBody2;
    public Cube bipedBody3;
    public Cube bipedRightArm2;
    public Cube bipedLeftArm2;
    public Cube bipedRightArm3;
    public Cube bipedLeftArm3;

    public ModelFireMinion() {
        this(0.0f);
    }

    public ModelFireMinion(float f) {
        this(f, 0.0f);
    }

    public ModelFireMinion(float f, float f1) {
        this.holdingLeftHand = false;
        this.holdingRightHand = false;
        this.sneaking = false;
        this.head = new Cube(0, 0);
        this.head.addBox(-4.0f, -8.0f, -3.0f, 8, 5, 7, f);
        this.head.setRotationPoint(0.0f, 0.0f + f1, 0.0f);
        this.hair = new Cube(32, 0);
        this.hair.addBox(-4.0f, -3.0f, -4.0f, 8, 3, 8, f);
        this.hair.setRotationPoint(0.0f, 0.0f + f1, 0.0f);
        this.body = new Cube(0, 12);
        this.body.addBox(-5.0f, 0.0f, -2.5f, 10, 6, 5, f);
        this.body.setRotationPoint(0.0f, 0.0f + f1, 0.0f);
        this.bipedBody2 = new Cube(0, 23);
        this.bipedBody2.addBox(-4.5f, 6.0f, -2.0f, 9, 5, 4, f);
        this.bipedBody2.setRotationPoint(0.0f, 0.0f + f1, 0.0f);
        this.bipedBody3 = new Cube(27, 27);
        this.bipedBody3.addBox(-4.5f, 11.0f, -2.0f, 9, 1, 4, f + 0.5f);
        this.bipedBody3.setRotationPoint(0.0f, 0.0f + f1, 0.0f);
        this.armRight = new Cube(30, 11);
        this.armRight.addBox(-2.5f, -2.5f, -2.5f, 5, 5, 5, f + 0.5f);
        this.armRight.setRotationPoint(-8.0f, 2.0f + f1, 0.0f);
        this.bipedRightArm2 = new Cube(30, 11);
        this.bipedRightArm2.addBox(-2.5f, 2.5f, -2.5f, 5, 10, 5, f);
        this.bipedRightArm2.setRotationPoint(-8.0f, 2.0f + f1, 0.0f);
        this.bipedRightArm3 = new Cube(30, 26);
        this.bipedRightArm3.addBox(-2.5f, 7.5f, -2.5f, 5, 1, 5, f + 0.25f);
        this.bipedRightArm3.setRotationPoint(-8.0f, 2.0f + f1, 0.0f);
        this.armLeft = new Cube(30, 11);
        this.armLeft.mirror = true;
        this.armLeft.addBox(-2.5f, -2.5f, -2.5f, 5, 5, 5, f + 0.5f);
        this.armLeft.setRotationPoint(8.0f, 2.0f + f1, 0.0f);
        this.bipedLeftArm2 = new Cube(30, 11);
        this.bipedLeftArm2.mirror = true;
        this.bipedLeftArm2.addBox(-2.5f, 2.5f, -2.5f, 5, 10, 5, f);
        this.bipedLeftArm2.setRotationPoint(8.0f, 2.0f + f1, 0.0f);
        this.bipedLeftArm3 = new Cube(30, 26);
        this.bipedLeftArm3.mirror = true;
        this.bipedLeftArm3.addBox(-2.5f, 7.5f, -2.5f, 5, 1, 5, f + 0.25f);
        this.bipedLeftArm3.setRotationPoint(8.0f, 2.0f + f1, 0.0f);
    }

    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
        this.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.head.render(scale);
        this.hair.render(scale);
        this.body.render(scale);
        this.bipedBody2.render(scale);
        this.bipedBody3.render(scale);
        this.armRight.render(scale);
        this.bipedRightArm2.render(scale);
        this.bipedRightArm3.render(scale);
        this.armLeft.render(scale);
        this.bipedLeftArm2.render(scale);
        this.bipedLeftArm3.render(scale);
    }

    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        Cube var10000;
        this.head.yRot = headYaw / 57.29578f;
        this.head.xRot = headPitch / 57.29578f;
        this.hair.yRot = this.head.yRot;
        this.hair.xRot = this.head.xRot;
        this.armRight.xRot = 0.0f;
        this.armLeft.xRot = 0.0f;
        this.armRight.zRot = 0.0f;
        this.armLeft.zRot = 0.0f;
        if (this.holdingLeftHand) {
            this.armLeft.xRot = this.armLeft.xRot * 0.5f - 0.3141593f;
        }
        if (this.holdingRightHand) {
            this.armRight.xRot = this.armRight.xRot * 0.5f - 0.3141593f;
        }
        this.armRight.yRot = 0.0f;
        this.armLeft.yRot = 0.0f;
        if (this.onGround > -9990.0f) {
            float f6 = this.onGround;
            this.body.yRot = MathHelper.sin((float)(MathHelper.sqrt((double)f6) * 3.141593f * 2.0f)) * 0.2f;
            var10000 = this.armRight;
            var10000.yRot += this.body.yRot;
            var10000 = this.armLeft;
            var10000.yRot += this.body.yRot;
            var10000.xRot += this.body.xRot;
            f6 = 1.0f - this.onGround;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            float f7 = MathHelper.sin((float)(f6 * 3.141593f));
            float f8 = MathHelper.sin((float)(this.onGround * 3.141593f)) * -(this.head.xRot - 0.7f) * 0.75f;
            var10000 = this.armRight;
            var10000.xRot = (float)((double)var10000.xRot - ((double)f7 * 1.2 + (double)f8));
            var10000.yRot += this.body.yRot * 2.0f;
            this.armRight.zRot = MathHelper.sin((float)(this.onGround * 3.141593f)) * -0.4f;
        }
        var10000 = this.armRight;
        var10000.zRot += MathHelper.cos((float)(limbPitch * 0.09f)) * 0.05f + 0.05f;
        var10000 = this.armLeft;
        var10000.zRot -= MathHelper.cos((float)(limbPitch * 0.09f)) * 0.05f + 0.05f;
        var10000 = this.armRight;
        var10000.xRot += MathHelper.sin((float)(limbPitch * 0.067f)) * 0.05f;
        var10000 = this.armLeft;
        var10000.xRot -= MathHelper.sin((float)(limbPitch * 0.067f)) * 0.05f;
        this.bipedBody3.xRot = this.bipedBody2.xRot = this.body.xRot;
        this.bipedBody3.yRot = this.bipedBody2.yRot = this.body.yRot;
        this.bipedLeftArm3.xRot = this.bipedLeftArm2.xRot = this.armLeft.xRot;
        this.bipedLeftArm3.yRot = this.bipedLeftArm2.yRot = this.armLeft.yRot;
        this.bipedLeftArm3.zRot = this.bipedLeftArm2.zRot = this.armLeft.zRot;
        this.bipedRightArm3.xRot = this.bipedRightArm2.xRot = this.armRight.xRot;
        this.bipedRightArm3.yRot = this.bipedRightArm2.yRot = this.armRight.yRot;
        this.bipedRightArm3.zRot = this.bipedRightArm2.zRot = this.armRight.zRot;
    }
}

