/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScreenHudDesigner;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.core.entity.Entity;
import org.lwjgl.opengl.GL11;
import teamport.aether.entity.AetherJumpAmount;

public class ComponentJumpBar
extends HudComponentMovable {
    private static final String texture = "/assets/aether/textures/gui/jumpbar.png";
    private static final int iconWidth = 9;
    private static final int iconHeight = 9;
    private static final int rowLength = 10;
    private static final int spacingX = -1;
    private static final int spacingY = -1;
    private Minecraft mc = Minecraft.getMinecraft();
    private int xScreenSize;
    private int yScreenSize;
    private Gui gui;
    private int rowAmount;

    public ComponentJumpBar(String key, Layout layout) {
        super(key, 81, 9, layout);
    }

    public int getYSize(Minecraft mc) {
        if (!(mc.currentScreen instanceof ScreenHudDesigner) && !this.isVisible(mc)) {
            return 0;
        }
        return 10 * this.rowAmount;
    }

    public int getXSize(Minecraft mc) {
        return 81;
    }

    public int getAnchorY(ComponentAnchor anchor) {
        return (int)(anchor.yPosition * (float)this.getYSize(this.mc));
    }

    public int getAnchorX(ComponentAnchor anchor) {
        return (int)(anchor.xPosition * (float)this.getXSize(this.mc));
    }

    public boolean isVisible(Minecraft minecraft) {
        return this.mc.thePlayer.vehicle instanceof AetherJumpAmount && this.mc.gameSettings.immersiveMode.drawHotbar();
    }

    public void render(Minecraft minecraft, HudIngame gui, int xScreenSize, int yScreenSize, float f) {
        Entity vehicle;
        this.mc = minecraft;
        this.gui = gui;
        this.xScreenSize = xScreenSize;
        this.yScreenSize = yScreenSize;
        if (this.mc.thePlayer.isPassenger() && (vehicle = (Entity)this.mc.thePlayer.vehicle) instanceof AetherJumpAmount) {
            this.drawJumpBar(((AetherJumpAmount)vehicle).getJumpMaxAmount(), ((AetherJumpAmount)vehicle).getJumpAmount());
        }
    }

    public void renderPreview(Minecraft minecraft, Gui gui, Layout layout, int xScreenSize, int yScreenSize) {
        this.mc = minecraft;
        this.gui = gui;
        this.xScreenSize = xScreenSize;
        this.yScreenSize = yScreenSize;
        this.drawJumpBar(3, 2);
    }

    public void drawJumpBar(int jumpMaxAmount, int jumpAmount) {
        this.rowAmount = this.getRows(jumpMaxAmount);
        int barX = this.getLayout().getComponentX(this.mc, (HudComponent)this, this.xScreenSize);
        int barY = this.getLayout().getComponentY(this.mc, (HudComponent)this, this.yScreenSize) + 10 * (this.rowAmount - 1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.bindTexture(this.mc.textureManager.loadTexture(texture));
        this.drawRowsOfIcons(barX, barY, 9, 0, jumpMaxAmount);
        this.drawRowsOfIcons(barX, barY, 0, 0, jumpAmount);
    }

    public int getRows(int amount) {
        return amount % 10 <= 0 ? amount / 10 : amount / 10 + 1;
    }

    public void drawRowsOfIcons(int screenX, int screenY, int U, int V, int iconAmount) {
        int iconsToDraw = iconAmount;
        for (int row = 0; row < this.getRows(iconAmount); ++row) {
            for (int collumn = 0; collumn < Math.min(10, iconsToDraw); ++collumn) {
                int currentX = screenX + 9 * collumn + -1 * collumn;
                int currentY = screenY - 9 * row + -1 * row;
                this.gui.drawTexturedModalRect(currentX, currentY, U, V, 9, 9);
            }
            iconsToDraw -= 10;
        }
    }
}

