/*
 * Decompiled with CFR 0.152.
 */
package teamport.aether.items.accessory;

import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemQuiver;
import net.minecraft.core.item.ItemQuiverEndless;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuInventory;
import net.minecraft.core.player.inventory.slot.Slot;
import org.jetbrains.annotations.Nullable;
import teamport.aether.achievements.AetherAchievements;
import teamport.aether.items.AetherItemTags;
import teamport.aether.items.accessory.ItemAccessoryArmor;

public class SlotAccessory
extends Slot {
    public static final byte GLOVES_SLOT = 4;
    public static final byte CAPE_SLOT = 5;
    public static final byte TRINKET_1_SLOT = 6;
    public static final byte TRINKET_2_SLOT = 7;
    public static final String[] accessoryOutline = new String[]{"aether:item/armor_gloves_outline", "aether:item/armor_capes_outline", "aether:item/armor_wildcard_outline", "aether:item/armor_wildcard_outline"};
    public final MenuInventory menu;
    public final int armorType;

    public SlotAccessory(MenuInventory menu, Container container, int index, int x, int y, int armorType) {
        super(container, index, x, y);
        this.menu = menu;
        this.armorType = armorType;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean mayPlace(ItemStack itemstack) {
        Item item = itemstack.getItem();
        if (item instanceof ItemAccessoryArmor) {
            return ((ItemAccessoryArmor)item).getSlotID() == this.armorType;
        }
        if ((item instanceof ItemQuiverEndless || item instanceof ItemQuiver) && this.armorType == 5) {
            return true;
        }
        return item.hasTag(AetherItemTags.TRINKET) && this.armorType >= 6;
    }

    public void setChanged() {
        super.setChanged();
        int count = 0;
        for (int i = 0; i < this.menu.slots.size(); ++i) {
            ItemStack stack;
            if (!(this.menu.slots.get(i) instanceof SlotAccessory) || (stack = ((Slot)this.menu.slots.get(i)).getItemStack()) == null) continue;
            ++count;
        }
        if (count == 4) {
            this.menu.inventory.player.triggerAchievement((Stat)AetherAchievements.ALL_ACCESSORY_TYPES);
        }
        if (this.getItemStack() != null && this.container instanceof ContainerInventory) {
            Player player = ((ContainerInventory)this.container).player;
            player.world.playSoundAtEntity((Entity)player, (Entity)player, "random.equip", 2.0f, 1.0f);
        }
    }

    public void set(@Nullable ItemStack itemstack) {
        super.set(itemstack);
    }

    public String getItemIcon() {
        return accessoryOutline[this.armorType - 4];
    }
}

